/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.clock;

import com.spacekiller.game2d.Clock;
import java.util.ArrayList;

public class FuzzyClock
implements Clock {
    private long lms;
    private long cms;
    private long dms;
    private long sms;
    private long[] fms;
    private int fmi;
    private int fmc;
    private long fmt;
    private double ems;
    private double mspf;
    private double lost;
    private long f;

    public FuzzyClock(double millisPerFrame) {
        this.mspf = millisPerFrame;
        this.reset();
    }

    @Override
    public void reset() {
        this.fms = new long[32];
        this.fmi = 0;
        this.fmc = this.fms.length;
        this.fmt = 0L;
        this.sms = 1L;
        this.ems = 0.0;
        this.f = 0L;
        this.lost = 0.0;
        this.lms = System.currentTimeMillis();
    }

    public double ms() {
        this.cms = System.currentTimeMillis();
        this.dms = this.cms - this.lms;
        this.lms = this.cms;
        this.fmt += this.dms - this.fms[this.fmi];
        this.fms[this.fmi] = this.dms;
        if (++this.fmi >= this.fmc) {
            this.fmi = 0;
        }
        this.sms += this.dms;
        ++this.f;
        this.mspf = (this.mspf * 3.0 + (double)this.fmt / (double)this.fmc + this.lost / 1000.0) / 4.0;
        this.ems += this.mspf;
        this.lost += (double)this.dms - this.mspf;
        return this.ems;
    }

    @Override
    public long millis() {
        return (long)this.ms();
    }

    public static void main(String[] args) {
        try {
            double minMSPF;
            int c;
            double initNPF = 10.0;
            FuzzyClock beat = new FuzzyClock(initNPF);
            System.out.println("Testing: " + beat);
            ArrayList<String> test = new ArrayList<String>();
            String testObj = "Hallo Nano";
            int loops = 20000;
            long[] fms = new long[loops];
            double[] mspf = new double[loops];
            long ms = -System.currentTimeMillis();
            beat.reset();
            for (c = 0; c < loops; ++c) {
                for (int j = 0; j < 15000; ++j) {
                    test.add(testObj);
                }
                test.clear();
                fms[c] = beat.millis();
                mspf[c] = beat.mspf;
            }
            System.out.println("System millis:   " + (ms += System.currentTimeMillis()));
            System.out.println("System millis:   " + beat.sms);
            System.out.println("Engine millis:   " + fms[loops - 1]);
            System.out.println("Millis per frame: " + beat.mspf);
            for (c = 0; c < 2000; ++c) {
                System.out.println(" - fms[" + c + "] = " + fms[c] + " -> mspf=" + mspf[c]);
            }
            double maxMSPF = minMSPF = mspf[1000];
            for (int c2 = 1000; c2 < mspf.length; ++c2) {
                if (mspf[c2] < minMSPF) {
                    minMSPF = mspf[c2];
                }
                if (!(mspf[c2] > maxMSPF)) continue;
                maxMSPF = mspf[c2];
            }
            System.out.println("Minimum mspf: " + minMSPF);
            System.out.println("Maximum mspf: " + maxMSPF);
            System.out.println("Difference:   " + (maxMSPF - minMSPF));
            System.out.println("Test completed.");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

