/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.config;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ConfigNode {
    private String type;
    private List keys;
    private Properties props;
    private List children;

    public ConfigNode(String type) {
        this.setType(type);
        this.keys = new ArrayList();
        this.props = new Properties();
        this.children = new ArrayList();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void read(Reader r) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(r);
        tok.commentChar(35);
        tok.wordChars(95, 95);
        tok.ordinaryChar(47);
        tok.ordinaryChar(46);
        tok.wordChars(46, 46);
        tok.ordinaryChars(48, 57);
        tok.wordChars(48, 57);
        tok.ordinaryChar(34);
        this.read(tok);
    }

    public void read(StreamTokenizer tok) throws IOException {
        String configType = null;
        String configKey = null;
        boolean prevEqual = false;
        block9: while (true) {
            int t = tok.nextToken();
            switch (t) {
                case 34: {
                    continue block9;
                }
                case 60: {
                    ConfigNode child = new ConfigNode(null);
                    this.addChild(child);
                    child.read(tok);
                    continue block9;
                }
                case 62: {
                    return;
                }
                case 61: {
                    if (prevEqual || configType == null) {
                        throw new IOException("Invalid token '=' at line: " + tok.lineno());
                    }
                    prevEqual = true;
                    continue block9;
                }
                case -2: {
                    tok.sval = String.valueOf(tok.nval);
                }
                case -3: {
                    if (configType == null) {
                        configType = tok.sval;
                        this.setType(configType);
                    } else if (configKey == null) {
                        if (prevEqual) {
                            throw new IOException("Invalid key '" + tok.sval + "' at line: " + tok.lineno());
                        }
                        configKey = tok.sval;
                    } else {
                        if (!prevEqual) {
                            throw new IOException("Invalid value '" + tok.sval + "' at line: " + tok.lineno());
                        }
                        this.setValue(configKey, tok.sval);
                        configKey = null;
                    }
                    prevEqual = false;
                    continue block9;
                }
                case -1: {
                    return;
                }
            }
            prevEqual = false;
        }
    }

    public void write(Writer w) throws IOException {
        w.write(60);
        w.write(this.type);
        for (String key : this.keys) {
            w.write(32);
            w.write(key);
            w.write(61);
            w.write(this.formatValue(this.props.getProperty(key)));
        }
        if (!this.children.isEmpty()) {
            w.write("\r\n");
            this.writeChildren(w);
        }
        w.write(47);
        w.write(62);
        w.write("\r\n");
    }

    public void writeChildren(Writer w) throws IOException {
        for (ConfigNode child : this.children) {
            child.write(w);
        }
    }

    protected String formatValue(String v) {
        try {
            Double.parseDouble(v);
            return v;
        }
        catch (NumberFormatException numberFormatException) {
            return '\"' + v + '\"';
        }
    }

    public void addChild(ConfigNode child) {
        this.children.add(child);
    }

    public void removeChild(ConfigNode child) {
        this.children.remove(child);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ConfigNode getChildAt(int i) {
        return (ConfigNode)this.children.get(i);
    }

    public void setValue(String key, String value) {
        if (value == null) {
            this.keys.remove(key);
            this.props.remove(key);
            return;
        }
        if (!this.props.containsKey(key)) {
            this.keys.add(key);
        }
        this.props.put(key, value);
    }

    public String getValue(String key) {
        return (String)this.props.get(key);
    }

    public Enumeration getKeys() {
        return this.props.propertyNames();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ConfigNode{");
        int index = 0;
        Iterator i = this.keys.iterator();
        while (i.hasNext()) {
            if (index > 0) {
                buf.append(", ");
            }
            String key = (String)i.next();
            buf.append(key);
            buf.append("=");
            buf.append(this.props.getProperty(key));
            ++index;
        }
        buf.append("}");
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            System.out.println("Test..");
            FileReader reader = new FileReader("c:\\test.txt");
            ConfigNode node = new ConfigNode("");
            node.read(reader);
            reader.close();
            System.out.println("Nodes: " + node.getChildCount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

