/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.config;

import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Model;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.config.ConfigNode;
import com.spacekiller.game2d.config.PersistenceManager;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DefaultPersistenceManager
implements PersistenceManager {
    private static final String MODEL_ZIP_ENTRY = "model.txt";
    private String versionId = "Roomclan-2D-Model-1.0.0";
    private ResourceRegistry registry;

    public DefaultPersistenceManager(ResourceRegistry registry) {
        this.setRegistry(registry);
    }

    @Override
    public Model readModel(InputStream in) throws Exception {
        ZipEntry entry;
        ConfigNode configRoot = null;
        ZipInputStream zin = new ZipInputStream(in);
        while ((entry = zin.getNextEntry()) != null) {
            if (entry.getName().equals(MODEL_ZIP_ENTRY)) {
                System.out.println("reading model configuration..");
                configRoot = new ConfigNode(null);
                InputStreamReader reader = new InputStreamReader(zin);
                configRoot.read(reader);
            } else {
                System.err.println("Invalid model zip-entry: " + entry.getName());
            }
            zin.closeEntry();
        }
        zin.close();
        if (configRoot == null) {
            throw new Exception("No model zip-entry found: model.txt");
        }
        System.out.println("parsing model configuration..");
        Model model = this.parseModelConfig(configRoot);
        return model;
    }

    @Override
    public void writeModel(Model m, OutputStream out) throws Exception {
        ConfigNode configRoot = new ConfigNode(this.versionId);
        this.generateModelConfig(m, configRoot);
        ZipOutputStream zout = new ZipOutputStream(out);
        ZipEntry entry = new ZipEntry(MODEL_ZIP_ENTRY);
        zout.putNextEntry(entry);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zout));
        writer.write("#!" + this.versionId);
        writer.newLine();
        configRoot.writeChildren(writer);
        writer.flush();
        zout.closeEntry();
        zout.flush();
        zout.finish();
        zout.close();
    }

    protected void generateModelConfig(Model m, ConfigNode dstRoot) throws Exception {
        Rectangle2D bounds = m.getBounds();
        ConfigNode configBounds = new ConfigNode("model_bounds");
        configBounds.setValue("x", "" + bounds.getX());
        configBounds.setValue("y", "" + bounds.getY());
        configBounds.setValue("width", "" + bounds.getWidth());
        configBounds.setValue("height", "" + bounds.getHeight());
        dstRoot.addChild(configBounds);
        if (m instanceof ElementModel) {
            ElementModel dm = (ElementModel)m;
            ConfigNode configGrid = new ConfigNode("grid_map");
            configGrid.setValue("columns", "" + dm.getMapColumns());
            configGrid.setValue("rows", "" + dm.getMapRows());
            configGrid.setValue("cellWidth", "" + dm.getMapCellWidth());
            configGrid.setValue("cellHeight", "" + dm.getMapCellHeight());
            dstRoot.addChild(configGrid);
        }
        if (m instanceof ElementModel) {
            ElementModel em = (ElementModel)m;
            Iterator i = em.getElements();
            while (i.hasNext()) {
                Element el = (Element)i.next();
                if (el == null) continue;
                ConfigNode configElement = new ConfigNode("element");
                Map custom = em.getElementProperties(el);
                if (custom != null) {
                    for (Map.Entry me : custom.entrySet()) {
                        String key = String.valueOf(me.getKey());
                        String val = String.valueOf(me.getValue());
                        configElement.setValue(key, val);
                    }
                }
                configElement.setValue("id", String.valueOf(el.getId()));
                ElementType type = el.getType();
                if (type != null) {
                    configElement.setValue("type", String.valueOf(type.getId()));
                }
                configElement.setValue("x", String.valueOf(el.getX()));
                configElement.setValue("y", String.valueOf(el.getY()));
                configElement.setValue("width", String.valueOf(el.getWidth()));
                configElement.setValue("height", String.valueOf(el.getHeight()));
                dstRoot.addChild(configElement);
            }
        }
    }

    protected Model parseModelConfig(ConfigNode srcRoot) throws Exception {
        double cellWidth = 500.0;
        double cellHeight = 500.0;
        int columns = 5;
        int rows = 5;
        double modelX = 0.0;
        double modelY = 0.0;
        double modelWidth = 0.0;
        double modelHeight = 0.0;
        HashMap elementProps = new HashMap();
        int count = srcRoot.getChildCount();
        System.out.println(" -> Number of configuration nodes: " + count);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int c = 0; c < count; ++c) {
            Element element;
            String v;
            ConfigNode cfg = srcRoot.getChildAt(c);
            String type = cfg.getType();
            if (type == null) continue;
            if (type.equalsIgnoreCase("model_bounds")) {
                v = cfg.getValue("x");
                if (v != null) {
                    modelX = Double.parseDouble(v.trim());
                }
                if ((v = cfg.getValue("y")) != null) {
                    modelY = Double.parseDouble(v.trim());
                }
                if ((v = cfg.getValue("width")) != null) {
                    modelWidth = Double.parseDouble(v.trim());
                }
                if ((v = cfg.getValue("height")) == null) continue;
                modelHeight = Double.parseDouble(v.trim());
                continue;
            }
            if (type.equalsIgnoreCase("grid_map")) {
                v = cfg.getValue("cellWidth");
                if (v != null) {
                    cellWidth = Double.parseDouble(v.trim());
                }
                if ((v = cfg.getValue("cellHeight")) != null) {
                    cellHeight = Double.parseDouble(v.trim());
                }
                if ((v = cfg.getValue("columns")) != null) {
                    columns = Integer.parseInt(v.trim());
                }
                if ((v = cfg.getValue("rows")) == null) continue;
                rows = Integer.parseInt(v.trim());
                continue;
            }
            if (!type.equalsIgnoreCase("element")) continue;
            String elementId = cfg.getValue("id");
            String elementTypeKey = cfg.getValue("type");
            ElementType elementType = this.registry.getElementType(elementTypeKey);
            if (elementType == null) {
                throw new Exception("ElementType not found: " + elementTypeKey);
            }
            double elementX = 0.0;
            double elementY = 0.0;
            double elementW = 0.0;
            double elementH = 0.0;
            v = cfg.getValue("x");
            if (v != null) {
                elementX = Double.parseDouble(v.trim());
            }
            if ((v = cfg.getValue("y")) != null) {
                elementY = Double.parseDouble(v.trim());
            }
            if ((v = cfg.getValue("width")) != null) {
                elementW = Double.parseDouble(v.trim());
            }
            if ((v = cfg.getValue("height")) != null) {
                elementH = Double.parseDouble(v.trim());
            }
            if ((element = elementType.createElement(elementId, elementX, elementY, elementW, elementH)) != null) {
                elements.add(element);
            }
            HashMap<String, String> elProps = null;
            Enumeration en = cfg.getKeys();
            while (en.hasMoreElements()) {
                String customKey = (String)en.nextElement();
                v = cfg.getValue(customKey);
                if (elProps == null) {
                    elProps = new HashMap<String, String>();
                }
                elProps.put(customKey, v);
            }
            if (elProps == null) continue;
            elementProps.put(element, elProps);
        }
        System.out.println("Model bounds: x=" + modelX + ", y=" + modelY + ", width=" + modelWidth + ", height=" + modelHeight);
        System.out.println("Creating model: cellWidth=" + cellWidth + ", cellHeight=" + cellHeight + ", columns=" + columns + ", rows=" + rows);
        ElementModel model = new ElementModel(cellWidth, cellHeight, columns, rows);
        int elementCount = elements.size();
        System.out.println("Number of elements: " + elementCount);
        for (int c = 0; c < elementCount; ++c) {
            model.add((Element)elements.get(c));
        }
        for (Element el : elementProps.keySet()) {
            Map elProps = (Map)elementProps.get(el);
            model.setElementProperties(el, elProps);
        }
        return model;
    }

    public ResourceRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ResourceRegistry registry) {
        this.registry = registry;
    }
}

