/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputButton;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.AbstractInputButton;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class AWTKeyboardController
implements InputController,
KeyListener {
    private AWTKeyboardButton[] buttons;

    public AWTKeyboardController(int buttonCount) {
        this.buttons = new AWTKeyboardButton[buttonCount];
        for (int c = 0; c < buttonCount; ++c) {
            String name = "" + (char)c;
            int keyCode = c;
            this.buttons[c] = new AWTKeyboardButton(name, keyCode);
        }
    }

    @Override
    public void poll() {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code >= 0 && code < this.buttons.length) {
            this.buttons[code].pressed = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (code >= 0 && code < this.buttons.length) {
            this.buttons[code].pressed = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public int getButtonCount() {
        return this.buttons.length;
    }

    public InputButton getButtonAt(int i) {
        return this.buttons[i];
    }

    @Override
    public InputAxis getAxisAt(int i) {
        return this.buttons[i];
    }

    @Override
    public int getAxisCount() {
        return this.buttons.length;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public InputAxis getAxisForKey(int keyCode) {
        return keyCode < this.buttons.length ? this.buttons[keyCode] : null;
    }

    @Override
    public int getRumblerCount() {
        return 0;
    }

    @Override
    public Rumbler getRumblerAt(int i) {
        return null;
    }

    protected class AWTKeyboardButton
    extends AbstractInputButton {
        public AWTKeyboardButton(String name, int keyCode) {
            super(AWTKeyboardController.this, name, 1000, keyCode);
        }

        @Override
        public boolean isPolling() {
            return false;
        }

        public String toString() {
            int keyCode = this.getKeyCode();
            if (keyCode < 32 || keyCode > 126) {
                return "AWTKeyboardButton[keyCode=" + keyCode + "]";
            }
            return "AWTKeyboardButton[" + this.getName() + "]";
        }
    }
}

