/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.input.AWTKeyboardController;
import com.spacekiller.game2d.input.AbstractInputManager;

public class AWTKeyboardManager
extends AbstractInputManager {
    private AWTKeyboardController keyboard;

    public AWTKeyboardManager() {
        super(AWTKeyboardManager.class.getName(), "AWT-Keyboard");
    }

    @Override
    public synchronized void activate() throws Exception {
        if (this.keyboard != null) {
            throw new Exception("Keyboard already activated: " + this.keyboard);
        }
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        this.keyboard = this.createAWTKeyboardController();
        surface.getWindow().addKeyListener(this.keyboard);
    }

    protected AWTKeyboardController createAWTKeyboardController() {
        return new AWTKeyboardController(150);
    }

    @Override
    public synchronized void deactivate() throws Exception {
        if (this.keyboard == null) {
            return;
        }
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        surface.getWindow().removeKeyListener(this.keyboard);
        this.keyboard = null;
    }

    @Override
    public InputController[] getControllers() {
        return new InputController[]{this.keyboard};
    }

    @Override
    public boolean isSupported() {
        return true;
    }
}

