/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import com.spacekiller.game2d.input.AbstractInputAxis;
import com.spacekiller.game2d.input.AbstractInputButton;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class AWTMouseController
implements InputController,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private int x;
    private int y;
    private int w;
    private AWTMouseXAxis xAxis = new AWTMouseXAxis("x-axis");
    private AWTMouseYAxis yAxis = new AWTMouseYAxis("y-axis");
    private AWTMouseWheel wheel = new AWTMouseWheel("wheel");
    private AWTMouseButton[] buttons;
    private InputAxis[] axes;

    public AWTMouseController(int buttonCount) {
        int c;
        this.buttons = new AWTMouseButton[buttonCount];
        for (c = 0; c < buttonCount; ++c) {
            this.buttons[c] = new AWTMouseButton("button" + (c + 1));
        }
        this.axes = new InputAxis[buttonCount + 3];
        this.axes[0] = this.xAxis;
        this.axes[1] = this.yAxis;
        this.axes[2] = this.wheel;
        for (c = 0; c < buttonCount; ++c) {
            this.axes[3 + c] = this.buttons[c];
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int b = e.getButton() - 1;
        if (b >= 0 && b < this.buttons.length) {
            this.buttons[b].pressed = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int b = e.getButton() - 1;
        if (b >= 0 && b < this.buttons.length) {
            this.buttons[b].pressed = false;
        }
    }

    @Override
    public void poll() {
    }

    @Override
    public InputAxis getAxisAt(int i) {
        return this.axes[i];
    }

    @Override
    public int getAxisCount() {
        return this.axes.length;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.w += e.getWheelRotation();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public InputAxis getAxisForKey(int keyCode) {
        return null;
    }

    @Override
    public int getRumblerCount() {
        return 0;
    }

    @Override
    public Rumbler getRumblerAt(int i) {
        return null;
    }

    protected class AWTMouseWheel
    extends AbstractInputAxis {
        public AWTMouseWheel(String name) {
            super(AWTMouseController.this, name, 2020);
        }

        @Override
        public float getValue() {
            return AWTMouseController.this.w;
        }

        @Override
        public boolean isAnalog() {
            return true;
        }

        @Override
        public boolean isNormalized() {
            return false;
        }

        @Override
        public boolean isRelative() {
            return false;
        }

        @Override
        public boolean isPolling() {
            return false;
        }
    }

    protected class AWTMouseYAxis
    extends AbstractInputAxis {
        public AWTMouseYAxis(String name) {
            super(AWTMouseController.this, name, 2001);
        }

        @Override
        public float getValue() {
            return AWTMouseController.this.y;
        }

        @Override
        public boolean isAnalog() {
            return true;
        }

        @Override
        public boolean isNormalized() {
            return false;
        }

        @Override
        public boolean isRelative() {
            return false;
        }

        @Override
        public boolean isPolling() {
            return false;
        }
    }

    protected class AWTMouseXAxis
    extends AbstractInputAxis {
        public AWTMouseXAxis(String name) {
            super(AWTMouseController.this, name, 2000);
        }

        @Override
        public float getValue() {
            return AWTMouseController.this.x;
        }

        @Override
        public boolean isAnalog() {
            return true;
        }

        @Override
        public boolean isNormalized() {
            return false;
        }

        @Override
        public boolean isRelative() {
            return false;
        }

        @Override
        public boolean isPolling() {
            return false;
        }
    }

    protected class AWTMouseButton
    extends AbstractInputButton {
        public AWTMouseButton(String name) {
            super(AWTMouseController.this, name, 1000, -1);
        }

        @Override
        public boolean isPolling() {
            return false;
        }
    }
}

