/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Surface;
import com.spacekiller.game2d.input.AWTMouseController;
import com.spacekiller.game2d.input.AbstractInputManager;

public class AWTMouseManager
extends AbstractInputManager {
    private AWTMouseController mouse;

    public AWTMouseManager() {
        super(AWTMouseManager.class.getName(), "AWT-Mouse");
    }

    @Override
    public synchronized void activate() throws Exception {
        if (this.mouse != null) {
            throw new Exception("Mouse already activated: " + this.mouse);
        }
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        this.mouse = this.createAWTMouseController();
        surface.getWindow().addMouseListener(this.mouse);
        surface.getWindow().addMouseMotionListener(this.mouse);
        surface.getWindow().addMouseWheelListener(this.mouse);
    }

    protected AWTMouseController createAWTMouseController() {
        return new AWTMouseController(3);
    }

    @Override
    public synchronized void deactivate() throws Exception {
        if (this.mouse == null) {
            return;
        }
        Surface surface = this.getSurface();
        if (surface == null) {
            throw new NullPointerException("surface==null");
        }
        surface.getWindow().removeMouseListener(this.mouse);
        surface.getWindow().removeMouseMotionListener(this.mouse);
        surface.getWindow().removeMouseWheelListener(this.mouse);
        this.mouse = null;
    }

    @Override
    public InputController[] getControllers() {
        return new InputController[]{this.mouse};
    }

    @Override
    public boolean isSupported() {
        return true;
    }
}

