/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputButton;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.input.AbstractInputAxis;

public class ButtonAxis1D
extends AbstractInputAxis {
    private InputButton minus;
    private InputButton plus;
    private boolean polling;
    private float speed;

    public ButtonAxis1D(InputController controller, String name, int type, InputButton minus, InputButton plus, float speed) {
        super(controller, name, type);
        this.minus = minus;
        this.plus = plus;
        this.speed = speed;
        this.polling = minus.isPolling() || plus.isPolling();
    }

    @Override
    public float getValue() {
        float v = 0.0f;
        if (this.minus.isPressed()) {
            v -= this.speed;
        }
        if (this.plus.isPressed()) {
            v += this.speed;
        }
        return v;
    }

    @Override
    public boolean isPolling() {
        return this.polling;
    }

    @Override
    public boolean isAnalog() {
        return false;
    }

    @Override
    public boolean isNormalized() {
        return false;
    }

    @Override
    public boolean isRelative() {
        return true;
    }
}

