/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputButton;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.input.AbstractInputAxis;

public class ButtonWheelAxis
extends AbstractInputAxis {
    private InputButton minus;
    private InputButton plus;
    private boolean polling;
    private boolean minusPressed;
    private boolean plusPressed;

    public ButtonWheelAxis(InputController controller, String name, int type, InputButton minus, InputButton plus) {
        super(controller, name, type);
        this.minus = minus;
        this.plus = plus;
        this.polling = minus.isPolling() || plus.isPolling();
    }

    @Override
    public float getValue() {
        float v = 0.0f;
        boolean p = this.minus.isPressed();
        if (p != this.minusPressed) {
            this.minusPressed = p;
            if (p) {
                v -= 1.0f;
            }
        }
        if ((p = this.plus.isPressed()) != this.plusPressed) {
            this.plusPressed = p;
            if (p) {
                v += 1.0f;
            }
        }
        return v;
    }

    @Override
    public boolean isPolling() {
        return this.polling;
    }

    @Override
    public boolean isAnalog() {
        return false;
    }

    @Override
    public boolean isNormalized() {
        return false;
    }

    @Override
    public boolean isRelative() {
        return true;
    }
}

