/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.input;

import com.spacekiller.game2d.InputAxis;
import com.spacekiller.game2d.InputController;
import com.spacekiller.game2d.Rumbler;
import java.util.HashSet;
import java.util.Iterator;

public final class CustomInputController
implements InputController {
    private InputController[] ctrl;
    private InputAxis[] axes;

    public CustomInputController(InputAxis[] axes) {
        this.axes = axes;
        HashSet<InputController> pollingControllers = new HashSet<InputController>();
        for (int c = 0; c < axes.length; ++c) {
            if (!axes[c].isPolling()) continue;
            pollingControllers.add(axes[c].getController());
        }
        int num = pollingControllers.size();
        this.ctrl = new InputController[num];
        int c = 0;
        Iterator i = pollingControllers.iterator();
        while (i.hasNext()) {
            this.ctrl[c++] = (InputController)i.next();
        }
    }

    @Override
    public InputAxis getAxisAt(int i) {
        return this.axes[i];
    }

    @Override
    public int getAxisCount() {
        return this.axes.length;
    }

    @Override
    public void poll() {
        for (int c = 0; c < this.ctrl.length; ++c) {
            this.ctrl[c].poll();
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public InputAxis getAxisForKey(int keyCode) {
        return null;
    }

    @Override
    public int getRumblerCount() {
        return 0;
    }

    @Override
    public Rumbler getRumblerAt(int i) {
        return null;
    }
}

