/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceProvider;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.resource.AbstractResourceRegistry;
import com.spacekiller.game2d.resource.DefaultImageResource;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.sound.AudioBufferPool;
import java.awt.DisplayMode;
import java.awt.MediaTracker;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class AbstractResourceProvider
implements ResourceProvider {
    private static final Logger logger = Logger.getLogger(AbstractResourceProvider.class.getName());
    private ArrayList resources = new ArrayList();
    private ResourceRegistry registry;
    private MediaTracker mediaTracker;
    private AudioBufferPool audioBufferPool;
    private File tempAudioDirectory;
    private DisplayMode sourceDisplayMode;
    private DisplayMode targetDisplayMode;
    private double scaleFactorX;
    private double scaleFactorY;
    private boolean debug = false;

    @Override
    public ResourceRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(ResourceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public MediaTracker getMediaTracker() {
        return this.mediaTracker;
    }

    @Override
    public void setMediaTracker(MediaTracker mediaTracker) {
        this.mediaTracker = mediaTracker;
    }

    @Override
    public AudioBufferPool getAudioBufferPool() {
        return this.audioBufferPool;
    }

    @Override
    public void setAudioBufferPool(AudioBufferPool audioBufferPool) {
        this.audioBufferPool = audioBufferPool;
    }

    @Override
    public File getTempAudioDirectory() {
        return this.tempAudioDirectory;
    }

    @Override
    public void setTempAudioDirectory(File tempAudioDirectory) {
        this.tempAudioDirectory = tempAudioDirectory;
    }

    @Override
    public DisplayMode getTargetDisplayMode() {
        return this.targetDisplayMode;
    }

    @Override
    public void setTargetDisplayMode(DisplayMode targetDisplayMode) {
        this.targetDisplayMode = targetDisplayMode;
        this.computeScaleFactor();
    }

    @Override
    public Resource[] getResources() {
        Resource[] rc = new Resource[this.resources.size()];
        rc = this.resources.toArray(rc);
        return rc;
    }

    @Override
    public void getResources(Collection dst) {
        dst.addAll(this.resources);
    }

    protected void dispose() throws Exception {
        this.resources.clear();
    }

    protected void addResource(Resource r) {
        if (r == null) {
            throw new NullPointerException();
        }
        this.resources.add(r);
        if (this.registry != null && this.registry instanceof AbstractResourceRegistry) {
            AbstractResourceRegistry absRegistry = (AbstractResourceRegistry)this.registry;
            absRegistry.add(r);
        }
    }

    protected void removeResource(Resource r) {
        this.resources.remove(r);
    }

    public DisplayMode getSourceDisplayMode() {
        return this.sourceDisplayMode;
    }

    public void setSourceDisplayMode(DisplayMode sourceDisplayMode) {
        this.sourceDisplayMode = sourceDisplayMode;
        this.computeScaleFactor();
    }

    protected void computeScaleFactor() {
        double scaleX = 1.0;
        double scaleY = 1.0;
        DisplayMode srcMode = this.getSourceDisplayMode();
        DisplayMode dstMode = this.getTargetDisplayMode();
        if (srcMode != null && dstMode != null) {
            double srcWidth = srcMode.getWidth();
            double srcHeight = srcMode.getHeight();
            double dstWidth = dstMode.getWidth();
            double dstHeight = dstMode.getHeight();
            scaleX = dstWidth / srcWidth;
            scaleY = dstHeight / srcHeight;
        }
        this.setScaleFactorX(scaleX);
        this.setScaleFactorY(scaleY);
    }

    public double getScaleFactorX() {
        return this.scaleFactorX;
    }

    public void setScaleFactorX(double scaleFactorX) {
        this.scaleFactorX = scaleFactorX;
    }

    public double getScaleFactorY() {
        return this.scaleFactorY;
    }

    public void setScaleFactorY(double scaleFactorY) {
        this.scaleFactorY = scaleFactorY;
    }

    private URL getResource(String resource) throws Exception {
        URL url = this.getClass().getResource(resource);
        if (url != null) {
            return url;
        }
        ClassLoader loader = this.getClass().getClassLoader();
        url = loader.getResource(resource);
        if (url != null) {
            return url;
        }
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        url = systemLoader.getResource(resource);
        if (url != null) {
            return url;
        }
        logger.info("Resource not found: " + resource);
        logger.info("Class: " + this.getClass().getName());
        logger.info("ClassLoader: " + loader);
        logger.info("System-ClassLoader: " + systemLoader);
        throw new Exception("Resource not found: " + resource);
    }

    protected ImageResource createImageResource(String id, String imageResource) throws Exception {
        return new DefaultImageResource(id, imageResource);
    }

    protected ImageResource createImageResource(String imageResource) throws Exception {
        String id = imageResource;
        int x = id.lastIndexOf("/");
        if (x >= 0) {
            id = id.substring(x + 1);
        }
        return this.createImageResource(id, imageResource);
    }

    protected ImageResource[] createImageResourceArray(String[] imageResources) throws Exception {
        int num = imageResources.length;
        ImageResource[] rc = new ImageResource[num];
        for (int c = 0; c < num; ++c) {
            String path = imageResources[c];
            String id = path;
            int x = id.lastIndexOf("/");
            if (x > 0) {
                id = path.substring(x + 1);
            }
            rc[c] = this.createImageResource(id, path);
        }
        return rc;
    }

    protected void debug(String s) {
        if (this.debug) {
            logger.fine(String.valueOf(s));
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

