/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.ResourceType;
import java.awt.Color;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.Icon;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractResourceType
implements ResourceType {
    public static final String ATTR_RESOURCE_ID = "id";
    public static final String ATTR_RESOURCE_TYPE = "type";
    private final String typeId;
    private String typeName;
    private Icon typeIcon;

    public AbstractResourceType(String typeId) {
        this.typeId = typeId;
    }

    @Override
    public final String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    protected void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Icon getTypeIcon() {
        return this.typeIcon;
    }

    protected void setTypeIcon(Icon typeIcon) {
        this.typeIcon = typeIcon;
    }

    @Override
    public Icon getTypeIcon(int kind) {
        return this.getTypeIcon();
    }

    protected Element createChildElement(Node node, String tagName) {
        Document document = node.getOwnerDocument();
        if (document == null) {
            throw new NullPointerException("Owner document is null: node=" + node);
        }
        Element element = document.createElement(tagName);
        return element;
    }

    protected Element createChildElement(Node node, String tagName, String nodeValue) {
        Element element = this.createChildElement(node, tagName);
        element.setNodeValue(nodeValue);
        return element;
    }

    protected String getChildNodeValue(Node node, String tagName) {
        NodeList childNodes = node.getChildNodes();
        int num = childNodes.getLength();
        for (int i = 0; i < num; ++i) {
            Node childNode = childNodes.item(i);
            String childName = childNode.getNodeName();
            if (tagName == null || !tagName.equals(childName)) continue;
            return childNode.getNodeValue();
        }
        return null;
    }

    protected void addChildNode(Node node, Node child) {
        node.appendChild(child);
    }

    protected void clearChildNodes(Node node) {
        NodeList childNodes = node.getChildNodes();
        int num = childNodes.getLength();
        for (int i = 0; i < num; ++i) {
            Node childNode = childNodes.item(i);
            node.removeChild(childNode);
        }
    }

    protected String getAttrValue(Node node, String attrName) {
        Node resourceIdNode;
        NamedNodeMap attrMap = node.getAttributes();
        if (attrMap != null && (resourceIdNode = attrMap.getNamedItem(attrName)) != null && resourceIdNode instanceof Attr) {
            return ((Attr)resourceIdNode).getValue();
        }
        return null;
    }

    protected String getResourceId(Node node) {
        return this.getAttrValue(node, ATTR_RESOURCE_ID);
    }

    protected String getResourceTypeId(Node node) {
        return this.getAttrValue(node, ATTR_RESOURCE_TYPE);
    }

    protected String formatFloat(float value) {
        return Float.toString(value);
    }

    protected float parseFloat(String s) {
        return Float.parseFloat(s.trim());
    }

    protected String formatDouble(double value) {
        return Double.toString(value);
    }

    protected double parseDouble(String s) {
        return Double.parseDouble(s.trim());
    }

    protected String formatColor(Color color) {
        if (color == null) {
            return null;
        }
        float[] colComps = color.getColorComponents(new float[4]);
        int num = colComps.length;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < num; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.formatFloat(colComps[i]));
        }
        return sb.toString();
    }

    protected Color parseColor(String colorString) {
        if (colorString == null) {
            return null;
        }
        if ((colorString = colorString.trim()).length() < 1) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(colorString, ",", false);
        float[] colComps = new float[4];
        Arrays.fill(colComps, 1.0f);
        int colIndex = 0;
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if ((s = s.trim()).length() > 0 && colIndex < colComps.length) {
                colComps[colIndex] = this.parseFloat(s);
            }
            ++colIndex;
        }
        return new Color(colComps[0], colComps[1], colComps[2], colComps[3]);
    }
}

