/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationElementType;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.resource.AbstractElementTypeResource;
import com.spacekiller.game2d.resource.AnimationResource;
import com.spacekiller.game2d.resource.DefaultElementTypeResourceType;

public class AnimationElementTypeResource
extends AbstractElementTypeResource {
    private AnimationResource animationResource;
    private int loops;
    private boolean autoDispose;
    private volatile transient AnimationElementType animationElementType;

    public AnimationElementTypeResource(String id, AnimationResource animationResource, int loops, boolean autoDispose) {
        super(id, DefaultElementTypeResourceType.getDefaultElementTypeResourceType());
        this.animationResource = animationResource;
        this.loops = loops;
        this.autoDispose = autoDispose;
    }

    @Override
    protected ElementType createElementType() throws Exception {
        return this.getAnimationElementType();
    }

    public AnimationElementType getAnimationElementType() throws Exception {
        if (this.animationElementType == null) {
            this.setAnimationElementType(this.createAnimationElementType());
        }
        return this.animationElementType;
    }

    protected void setAnimationElementType(AnimationElementType animationElementType) {
        this.animationElementType = animationElementType;
    }

    protected AnimationElementType createAnimationElementType() throws Exception {
        Animation ani = this.animationResource.getAnimation();
        AnimationElementType elementType = this.createAnimationType(this.getId(), ani, this.loops, this.autoDispose);
        return elementType;
    }

    @Override
    public void flush() throws Exception {
        super.flush();
        this.setAnimationElementType(null);
    }

    protected AnimationElementType createAnimationType(String typeId, Animation ani, int loops, boolean autoDispose) throws Exception {
        AnimationElementType rc = new AnimationElementType(typeId, ani, loops, autoDispose);
        rc.setGroup("Animation");
        return rc;
    }

    @Override
    public String toString() {
        return super.toString() + "[animationElementType=" + this.animationElementType + "]";
    }
}

