/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationImage;
import com.spacekiller.game2d.resource.AbstractAnimationResource;
import com.spacekiller.game2d.resource.DefaultAnimationResourceType;
import com.spacekiller.game2d.resource.ImageResource;
import java.awt.Image;

public class DefaultAnimationResource
extends AbstractAnimationResource {
    private ImageResource[] imageResources;
    private int delay;
    private boolean centerImages;

    public DefaultAnimationResource(String id, ImageResource[] imageResources, int delay, boolean centerImages) {
        super(id, DefaultAnimationResourceType.getAnimationResourceType());
        this.imageResources = imageResources;
        this.delay = delay;
        this.centerImages = centerImages;
    }

    @Override
    protected Animation createAnimation() throws Exception {
        Image[] images = this.getImages();
        Animation ani = this.createAnimation(images, this.delay, this.centerImages);
        return ani;
    }

    protected Image[] getImages() throws Exception {
        int num = this.imageResources.length;
        Image[] rc = new Image[num];
        for (int c = 0; c < num; ++c) {
            rc[c] = this.imageResources[c].getImage();
        }
        return rc;
    }

    public ImageResource[] getImageResources() {
        return this.imageResources;
    }

    public boolean isCenterImages() {
        return this.centerImages;
    }

    protected void setCenterImages(boolean centerImages) {
        this.centerImages = centerImages;
    }

    public int getDelay() {
        return this.delay;
    }

    protected void setDelay(int delay) {
        this.delay = delay;
    }

    protected Animation createAnimation(Image[] images, int delay, boolean centerImages) throws Exception {
        int c;
        Animation ani = new Animation();
        int width = 0;
        int height = 0;
        int num = images.length;
        for (c = 0; c < num; ++c) {
            int ih;
            Image image = images[c];
            int iw = image.getWidth(null);
            if (iw > width) {
                width = iw;
            }
            if ((ih = image.getHeight(null)) > height) {
                height = ih;
            }
            AnimationImage aniImage = new AnimationImage(image, 0, 0, delay);
            ani.addAnimationImage(aniImage);
        }
        ani.setWidth(width);
        ani.setHeight(height);
        if (centerImages) {
            for (c = 0; c < num; ++c) {
                AnimationImage aniImage = ani.getAnimationImageAt(c);
                aniImage.setX(width / 2 - aniImage.getWidth() / 2);
                aniImage.setY(height / 2 - aniImage.getHeight() / 2);
            }
        }
        return ani;
    }
}

