/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.AbstractResource;
import com.spacekiller.game2d.resource.AudioClipResource;
import com.spacekiller.game2d.resource.DefaultAudioClipResourceType;
import com.spacekiller.game2d.sound.PooledAudioClip;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.Clip;

public class DefaultAudioClipResource
extends AbstractResource
implements AudioClipResource {
    private String resourcePath;
    private int maxConcurrentClips = 1;
    private volatile transient PooledAudioClip pooledAudioClip;

    public DefaultAudioClipResource(String id, String resourcePath, int maxConcurrentClips) {
        super(id, DefaultAudioClipResourceType.getAudioClipResourceType());
        this.setResourcePath(resourcePath);
        this.setMaxConcurrentClips(maxConcurrentClips);
    }

    @Override
    public Object getObject() throws Exception {
        return this.getAudioClip();
    }

    @Override
    public Clip getAudioClip() throws Exception {
        return this.getPooledAudioClip();
    }

    public PooledAudioClip getPooledAudioClip() throws Exception {
        if (this.pooledAudioClip == null) {
            this.setPooledAudioClip(this.createPooledAudioClip());
        }
        return this.pooledAudioClip;
    }

    protected void setPooledAudioClip(PooledAudioClip pooledAudioClip) {
        this.pooledAudioClip = pooledAudioClip;
    }

    protected PooledAudioClip createPooledAudioClip() throws Exception {
        URL url = this.getResource(this.resourcePath);
        if (url == null) {
            throw new IOException("Resource not found: " + this.resourcePath);
        }
        PooledAudioClip clip = new PooledAudioClip(url);
        clip.setMaxClips(this.maxConcurrentClips);
        return clip;
    }

    @Override
    public void flush() throws Exception {
        this.setPooledAudioClip(null);
    }

    @Override
    public String toString() {
        return "DefaultAudioClipResource[id=" + this.getId() + ", resourcePath=" + this.resourcePath + "]";
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    protected void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public int getMaxConcurrentClips() {
        return this.maxConcurrentClips;
    }

    protected void setMaxConcurrentClips(int maxConcurrentClips) {
        this.maxConcurrentClips = maxConcurrentClips;
    }
}

