/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceProvider;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.resource.AbstractResourceType;
import com.spacekiller.game2d.resource.DefaultAudioClipResource;
import java.beans.Customizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultAudioClipResourceType
extends AbstractResourceType {
    public static final String TYPE_ID = "DefaultAudioClipResourceType";
    public static final String NODE_RESOURCE_PATH = "resourcePath";
    public static final String NODE_MAX_CONCURRENT_CLIPS = "maxConcurrentClips";
    private static DefaultAudioClipResourceType INSTANCE;

    protected DefaultAudioClipResourceType(String typeId) {
        super(typeId);
    }

    public static DefaultAudioClipResourceType getAudioClipResourceType() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultAudioClipResourceType(TYPE_ID);
        }
        return INSTANCE;
    }

    @Override
    public Customizer createCustomizer(ResourceProvider provider) throws Exception {
        return null;
    }

    @Override
    public void writeResource(Resource resource, Node node, ResourceRegistry registry) throws Exception {
        if (resource instanceof DefaultAudioClipResource) {
            int maxConcurrentClips;
            DefaultAudioClipResource audioClipResource = (DefaultAudioClipResource)resource;
            this.clearChildNodes(node);
            String resourcePath = audioClipResource.getResourcePath();
            if (resourcePath != null) {
                Element element = this.createChildElement(node, NODE_RESOURCE_PATH, resourcePath);
                node.appendChild(element);
            }
            if ((maxConcurrentClips = audioClipResource.getMaxConcurrentClips()) != 0) {
                String valueString = Integer.toString(maxConcurrentClips);
                Element element = this.createChildElement(node, NODE_MAX_CONCURRENT_CLIPS, valueString);
                node.appendChild(element);
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource.getClass());
    }

    @Override
    public Resource readResource(String id, Node node, ResourceRegistry registry) throws Exception {
        String resourcePath = this.getChildNodeValue(node, NODE_RESOURCE_PATH);
        int maxConcurrentClips = 0;
        String maxConcurrentClipsString = this.getChildNodeValue(node, NODE_MAX_CONCURRENT_CLIPS);
        if (maxConcurrentClipsString != null) {
            double doubleValue = this.parseDouble(maxConcurrentClipsString);
            maxConcurrentClips = (int)doubleValue;
        }
        if (maxConcurrentClips < 1) {
            maxConcurrentClips = 1;
        }
        return new DefaultAudioClipResource(id, resourcePath, maxConcurrentClips);
    }
}

