/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Element;
import com.spacekiller.game2d.ElementModel;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Model;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceProvider;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.config.DefaultPersistenceManager;
import com.spacekiller.game2d.resource.AbstractResourceType;
import com.spacekiller.game2d.resource.DefaultElementModelResource;
import com.spacekiller.game2d.resource.ElementModelResource;
import java.awt.geom.Rectangle2D;
import java.beans.Customizer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultElementModelResourceType
extends AbstractResourceType {
    public static final String TYPE_ID = "DefaultElementModelResourceType";
    public static final String NODE_BOUNDS = "bounds";
    public static final String NODE_ELEMENT = "element";
    public static final String ATTR_BOUNDS_X = "x";
    public static final String ATTR_BOUNDS_Y = "y";
    public static final String ATTR_BOUNDS_WIDTH = "width";
    public static final String ATTR_BOUNDS_HEIGHT = "height";
    public static final String ATTR_ELEMENT_ID = "id";
    public static final String ATTR_ELEMENT_TYPE = "type";
    public static final String ATTR_ELEMENT_X = "x";
    public static final String ATTR_ELEMENT_Y = "y";
    public static final String ATTR_ELEMENT_WIDTH = "width";
    public static final String ATTR_ELEMENT_HEIGHT = "height";
    private static DefaultElementModelResourceType INSTANCE;

    protected DefaultElementModelResourceType(String typeId) {
        super(typeId);
    }

    public static DefaultElementModelResourceType getDefaultElementModelResourceType() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultElementModelResourceType(TYPE_ID);
        }
        return INSTANCE;
    }

    @Override
    public Customizer createCustomizer(ResourceProvider provider) throws Exception {
        return null;
    }

    @Override
    public void writeResource(Resource resource, Node node, ResourceRegistry registry) throws Exception {
        if (resource != null && resource instanceof ElementModelResource) {
            ElementModelResource elementModelResource = (ElementModelResource)resource;
            ElementModel elementModel = elementModelResource.getElementModel();
            if (elementModel != null) {
                this.writeElementModel(elementModel, node, registry);
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource.getClass());
    }

    @Override
    public Resource readResource(String id, Node node, ResourceRegistry registry) throws Exception {
        DefaultElementModelResource elementModelResource = new DefaultElementModelResource(id, DefaultElementModelResourceType.getDefaultElementModelResourceType(), registry, node);
        return elementModelResource;
    }

    public void writeElementModel(ElementModel elementModel, Node resourceNode, ResourceRegistry resourceRegistry) throws Exception {
        this.clearChildNodes(resourceNode);
        Rectangle2D modelBounds = elementModel.getBounds();
        double modelX = modelBounds.getX();
        double modelY = modelBounds.getY();
        double modelWidth = modelBounds.getWidth();
        double modelHeight = modelBounds.getHeight();
        org.w3c.dom.Element modelBoundsNode = this.createChildElement(resourceNode, NODE_BOUNDS);
        modelBoundsNode.setAttribute("x", this.formatDouble(modelX));
        modelBoundsNode.setAttribute("y", this.formatDouble(modelY));
        modelBoundsNode.setAttribute("width", this.formatDouble(modelWidth));
        modelBoundsNode.setAttribute("height", this.formatDouble(modelHeight));
        resourceNode.appendChild(modelBoundsNode);
        LinkedList modelElements = new LinkedList();
        elementModel.getElements(modelElements);
        for (Element element : modelElements) {
            ElementType elementType;
            if (element == null || (elementType = element.getType()) == null) continue;
            org.w3c.dom.Element elementNode = this.createChildElement(resourceNode, NODE_ELEMENT);
            String elementId = String.valueOf(element.getId());
            elementNode.setAttribute(ATTR_ELEMENT_ID, elementId);
            elementNode.setAttribute(ATTR_ELEMENT_TYPE, elementType.getId());
            Element rect = element;
            elementNode.setAttribute("x", this.formatDouble(rect.getX()));
            elementNode.setAttribute("y", this.formatDouble(rect.getY()));
            elementNode.setAttribute("width", this.formatDouble(rect.getWidth()));
            elementNode.setAttribute("height", this.formatDouble(rect.getHeight()));
            resourceNode.appendChild(elementNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel readElementModel(Node resourceNode, ResourceRegistry resourceRegistry) throws Exception {
        ElementModel elementModel = null;
        double modelX = Double.NaN;
        double modelY = Double.NaN;
        double modelWidth = Double.NaN;
        double modelHeight = Double.NaN;
        LinkedList<Element> modelElements = null;
        String legacyResourcePath = null;
        if (resourceNode != null) {
            modelElements = new LinkedList<Element>();
            NodeList childNodes = resourceNode.getChildNodes();
            int num = childNodes.getLength();
            for (int i = 0; i < num; ++i) {
                Element element;
                String s;
                Node childNode = childNodes.item(i);
                if (childNode == null || !(childNode instanceof org.w3c.dom.Element)) continue;
                org.w3c.dom.Element childElement = (org.w3c.dom.Element)childNode;
                String tagName = childElement.getTagName();
                if (NODE_BOUNDS.equals(tagName)) {
                    s = this.getAttrValue(childElement, "x");
                    if (s != null) {
                        modelX = this.parseDouble(s);
                    }
                    if ((s = this.getAttrValue(childElement, "y")) != null) {
                        modelY = this.parseDouble(s);
                    }
                    if ((s = this.getAttrValue(childElement, "width")) != null) {
                        modelWidth = this.parseDouble(s);
                    }
                    if ((s = this.getAttrValue(childElement, "height")) == null) continue;
                    modelHeight = this.parseDouble(s);
                    continue;
                }
                if (!NODE_ELEMENT.equals(tagName)) continue;
                String elementId = this.getAttrValue(childElement, ATTR_ELEMENT_ID);
                String elementTypeKey = this.getAttrValue(childElement, ATTR_ELEMENT_TYPE);
                ElementType elementType = resourceRegistry.getElementType(elementTypeKey);
                if (elementType == null) {
                    throw new Exception("ElementType not found: " + elementTypeKey);
                }
                double elementX = Double.NaN;
                double elementY = Double.NaN;
                double elementW = Double.NaN;
                double elementH = Double.NaN;
                s = this.getAttrValue(childElement, "x");
                if (s != null) {
                    elementX = this.parseDouble(s);
                }
                if ((s = this.getAttrValue(childElement, "y")) != null) {
                    elementY = this.parseDouble(s);
                }
                if ((s = this.getAttrValue(childElement, "width")) != null) {
                    elementW = this.parseDouble(s);
                }
                if ((s = this.getAttrValue(childElement, "height")) != null) {
                    elementH = this.parseDouble(s);
                }
                if ((element = elementType.createElement(elementId, elementX, elementY, elementW, elementH)) == null) continue;
                modelElements.add(element);
            }
        }
        if (legacyResourcePath != null && legacyResourcePath.length() > 0) {
            URL resourceURL = this.getClass().getResource(legacyResourcePath);
            if (resourceURL == null) {
                throw new IOException("Element model resource not found: " + legacyResourcePath);
            }
            InputStream in = resourceURL.openStream();
            try {
                Rectangle2D modelBounds;
                DefaultPersistenceManager persMan = new DefaultPersistenceManager(resourceRegistry);
                Model model = persMan.readModel(in);
                elementModel = (ElementModel)model;
                if (elementModel != null && Double.isNaN(modelX) && (modelBounds = elementModel.getBounds()) != null) {
                    modelX = modelBounds.getX();
                    modelY = modelBounds.getY();
                    modelWidth = modelBounds.getWidth();
                    modelHeight = modelBounds.getHeight();
                }
            }
            finally {
                in.close();
            }
        }
        double cellWidth = 500.0;
        double cellHeight = 500.0;
        int gridColumns = 5;
        int gridRows = 5;
        if (elementModel == null) {
            elementModel = new ElementModel(cellWidth, cellHeight, gridColumns, gridRows);
        }
        if (Double.isNaN(modelX)) {
            modelX = 0.0;
        }
        if (Double.isNaN(modelY)) {
            modelY = 0.0;
        }
        if (Double.isNaN(modelWidth)) {
            modelWidth = 0.0;
        }
        if (Double.isNaN(modelHeight)) {
            modelHeight = 0.0;
        }
        for (Element element : modelElements) {
            double elementX = element.getX();
            double elementY = element.getY();
            double elementWidth = element.getWidth();
            double elementHeight = element.getHeight();
            double elementX2 = elementX + elementWidth;
            double elementY2 = elementY + elementHeight;
            if (elementX2 > modelWidth) {
                modelWidth = elementX2;
            }
            if (!(elementY2 > modelHeight)) continue;
            modelHeight = elementY2;
        }
        gridColumns = (int)Math.ceil(modelWidth / cellWidth);
        gridRows = (int)Math.ceil(modelHeight / cellHeight);
        if (gridColumns < 0) {
            gridColumns = 1;
        }
        if (gridRows < 0) {
            gridRows = 1;
        }
        elementModel.resizeMap(gridColumns, gridRows, cellWidth, cellHeight);
        for (Element element : modelElements) {
            elementModel.add(element);
        }
        return elementModel;
    }
}

