/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AbstractElementTypeResource;
import com.spacekiller.game2d.resource.DefaultElementTypeResourceType;
import org.w3c.dom.Node;

public class DefaultElementTypeResource
extends AbstractElementTypeResource {
    private Node resourceNode;
    private transient ResourceRegistry resourceRegistry;
    private String imageResourceId;

    public DefaultElementTypeResource(String id, ResourceType type, ResourceRegistry resourceRegistry, Node resourceNode, String imageResourceId) {
        super(id, type);
        this.setResourceRegistry(resourceRegistry);
        this.setResourceNode(resourceNode);
        this.setImageResourceId(imageResourceId);
    }

    @Override
    protected ElementType createElementType() throws Exception {
        ResourceType resType = this.getType();
        if (resType != null && resType instanceof DefaultElementTypeResourceType) {
            DefaultElementTypeResourceType etrt = (DefaultElementTypeResourceType)resType;
            ElementType et = etrt.readElementType(this.resourceNode, this.resourceRegistry, this.imageResourceId);
            return et;
        }
        return null;
    }

    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    protected void setResourceRegistry(ResourceRegistry resourceRegistry) {
        this.resourceRegistry = resourceRegistry;
    }

    protected Node getResourceNode() {
        return this.resourceNode;
    }

    protected void setResourceNode(Node resourceNode) {
        this.resourceNode = resourceNode;
    }

    public String getImageResourceId() {
        return this.imageResourceId;
    }

    protected void setImageResourceId(String imageResourceId) {
        this.imageResourceId = imageResourceId;
    }
}

