/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.AbstractElementType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.CollisionGroup;
import com.spacekiller.game2d.DefaultElementType;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.ImageRenderer;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceProvider;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.resource.AbstractResourceType;
import com.spacekiller.game2d.resource.DefaultElementTypeResource;
import com.spacekiller.game2d.resource.ElementTypeResource;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.util.ImageToolkit;
import java.awt.Image;
import java.beans.Customizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultElementTypeResourceType
extends AbstractResourceType {
    public static final String TYPE_ID = "DefaultElementTypeResourceType";
    public static final String NODE_ELEMENT_TYPE = "elementType";
    public static final String ATTR_ELEMENT_TYPE_ID = "id";
    public static final String ATTR_ELEMENT_TYPE_GROUP = "group";
    public static final String NODE_ELEMENT_BOUNDS = "elementBounds";
    public static final String ATTR_ELEMENT_WIDTH = "width";
    public static final String ATTR_ELEMENT_HEIGHT = "height";
    public static final String NODE_ELEMENT_IMAGE = "elementImage";
    public static final String ATTR_IMAGE_RESOURCE_ID = "imageResourceId";
    private static DefaultElementTypeResourceType INSTANCE;

    protected DefaultElementTypeResourceType(String typeId) {
        super(typeId);
    }

    public static DefaultElementTypeResourceType getDefaultElementTypeResourceType() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultElementTypeResourceType(TYPE_ID);
        }
        return INSTANCE;
    }

    @Override
    public Customizer createCustomizer(ResourceProvider provider) throws Exception {
        return null;
    }

    @Override
    public void writeResource(Resource resource, Node node, ResourceRegistry registry) throws Exception {
        if (resource != null && resource instanceof ElementTypeResource) {
            ElementTypeResource elementTypeResource = (ElementTypeResource)resource;
            ElementType elementType = elementTypeResource.getElementType();
            if (elementType != null) {
                this.writeElementType(elementType, node, registry);
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource.getClass());
    }

    @Override
    public Resource readResource(String id, Node node, ResourceRegistry registry) throws Exception {
        String imageResourceId = null;
        DefaultElementTypeResource elementTypeResource = new DefaultElementTypeResource(id, DefaultElementTypeResourceType.getDefaultElementTypeResourceType(), registry, node, imageResourceId);
        return elementTypeResource;
    }

    public void writeElementType(ElementType elementType, Node resourceNode, ResourceRegistry resourceRegistry) throws Exception {
        this.clearChildNodes(resourceNode);
        if (elementType instanceof AbstractElementType) {
            AbstractElementType aet = (AbstractElementType)elementType;
            String id = aet.getId();
            String group = aet.getGroup();
            Element nodeElementType = this.createChildElement(resourceNode, NODE_ELEMENT_TYPE);
            if (id != null) {
                nodeElementType.setAttribute(ATTR_ELEMENT_TYPE_ID, id);
            }
            if (group != null) {
                nodeElementType.setAttribute(ATTR_ELEMENT_TYPE_GROUP, group);
            }
            Element nodeElementBounds = null;
            Element nodeElementImage = null;
            if (elementType instanceof DefaultElementType) {
                DefaultElementType det = (DefaultElementType)aet;
                double elementWidth = det.getElementWidth();
                double elementHeight = det.getElementHeight();
            }
            nodeElementBounds = this.createChildElement(resourceNode, NODE_ELEMENT_BOUNDS);
            nodeElementImage = this.createChildElement(resourceNode, NODE_ELEMENT_IMAGE);
            resourceNode.appendChild(nodeElementType);
            if (nodeElementBounds != null) {
                resourceNode.appendChild(nodeElementBounds);
            }
            if (nodeElementImage != null) {
                resourceNode.appendChild(nodeElementImage);
            }
        }
    }

    public ElementType readElementType(Node resourceNode, ResourceRegistry resourceRegistry, String imageResourceId) throws Exception {
        ImageResource imageResource;
        String elementTypeId = null;
        String elementTypeGroup = null;
        double elementWidth = Double.NaN;
        double elementHeight = Double.NaN;
        CollisionBounds collisionBounds = null;
        CollisionGroup collisionGroup = null;
        NodeList childNodes = resourceNode == null ? null : resourceNode.getChildNodes();
        int num = childNodes == null ? 0 : childNodes.getLength();
        for (int i = 0; i < num; ++i) {
            String s;
            Node childNode = childNodes.item(i);
            if (childNode == null || !(childNode instanceof Element)) continue;
            Element childElement = (Element)childNode;
            String tagName = childElement.getTagName();
            if (NODE_ELEMENT_TYPE.equals(tagName)) {
                s = this.getAttrValue(childElement, ATTR_ELEMENT_TYPE_ID);
                if (s != null) {
                    elementTypeId = s;
                }
                if ((s = this.getAttrValue(childElement, ATTR_ELEMENT_TYPE_GROUP)) == null) continue;
                elementTypeGroup = s;
                continue;
            }
            if (NODE_ELEMENT_BOUNDS.equals(tagName)) {
                s = this.getAttrValue(childElement, ATTR_ELEMENT_WIDTH);
                if (s != null) {
                    elementWidth = this.parseDouble(s);
                }
                if ((s = this.getAttrValue(childElement, ATTR_ELEMENT_HEIGHT)) == null) continue;
                elementHeight = this.parseDouble(s);
                continue;
            }
            if (!NODE_ELEMENT_IMAGE.equals(tagName) || (s = this.getAttrValue(childElement, ATTR_IMAGE_RESOURCE_ID)) == null) continue;
            imageResourceId = s;
        }
        ImageRenderer renderer = null;
        Image image = null;
        if (imageResourceId != null && (imageResource = (ImageResource)resourceRegistry.getResource(imageResourceId)) != null) {
            image = imageResource.getImage();
        }
        if (image != null && renderer == null) {
            renderer = new ImageRenderer(image);
            if (Double.isNaN(elementWidth)) {
                elementWidth = image.getWidth(null);
            }
            if (Double.isNaN(elementHeight)) {
                elementHeight = image.getHeight(null);
            }
            if (collisionBounds == null) {
                collisionBounds = ImageToolkit.getInstance().createCollisionBounds(image);
            }
        }
        if (renderer == null) {
            throw new RuntimeException("No Renderer available for DefaultElementTypeResource: " + elementTypeId);
        }
        DefaultElementType elementType = this.createElementType(elementTypeId);
        elementType.setGroup(elementTypeGroup);
        elementType.setRenderer(renderer);
        elementType.setElementWidth(elementWidth);
        elementType.setElementHeight(elementHeight);
        elementType.setCollisionBounds(collisionBounds);
        elementType.setCollisionGroup(collisionGroup);
        return elementType;
    }

    protected DefaultElementType createElementType(String elementTypeId) throws Exception {
        return new DefaultElementType(elementTypeId);
    }
}

