/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.resource.AbstractImageResource;
import com.spacekiller.game2d.resource.DefaultImageResourceType;
import com.spacekiller.game2d.util.ImageToolkit;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;

public class DefaultImageResource
extends AbstractImageResource {
    private String resourcePath;
    private Color background = null;
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    private double rotateTheta = 0.0;

    public DefaultImageResource(String id, String resourcePath) {
        super(id, DefaultImageResourceType.getDefaultImageResourceType());
        this.setResourcePath(resourcePath);
    }

    public DefaultImageResource(String id, String resourcePath, Color background, double scaleFactorX, double scaleFactorY, double rotateTheta) {
        this(id, resourcePath);
        this.setBackground(background);
        this.setScaleFactorX(scaleFactorX);
        this.setScaleFactorY(scaleFactorY);
        this.setRotateTheta(rotateTheta);
    }

    @Override
    protected Image createImage() throws Exception {
        URL url = this.getResource(this.resourcePath);
        if (url == null) {
            throw new IOException("Resource not found: " + this.resourcePath);
        }
        Image image = ImageToolkit.getInstance().createImage(url);
        if (image == null) {
            throw new IOException("Unsupported image resource: " + this.resourcePath + " -> " + url);
        }
        boolean transform = false;
        if (this.background != null) {
            transform = true;
        }
        if (this.scaleFactorX != 1.0 || this.scaleFactorY != 1.0) {
            transform = true;
        }
        if (this.rotateTheta != 0.0) {
            transform = true;
        }
        if (transform) {
            ImageObserver observer = null;
            BufferedImage transImage = ImageToolkit.getInstance().transformImage(image, observer, this.background, this.scaleFactorX, this.scaleFactorY, this.rotateTheta);
            image = transImage;
        }
        return image;
    }

    @Override
    public String toString() {
        return "DefaultImageResource[id=" + this.getId() + ", resourcePath=" + this.resourcePath + "]";
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    protected void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Color getBackground() {
        return this.background;
    }

    protected void setBackground(Color background) {
        this.background = background;
    }

    public double getScaleFactorX() {
        return this.scaleFactorX;
    }

    protected void setScaleFactorX(double scaleFactorX) {
        this.scaleFactorX = scaleFactorX;
    }

    public double getScaleFactorY() {
        return this.scaleFactorY;
    }

    protected void setScaleFactorY(double scaleFactorY) {
        this.scaleFactorY = scaleFactorY;
    }

    public double getRotateTheta() {
        return this.rotateTheta;
    }

    protected void setRotateTheta(double rotateTheta) {
        this.rotateTheta = rotateTheta;
    }
}

