/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceProvider;
import com.spacekiller.game2d.ResourceRegistry;
import com.spacekiller.game2d.resource.AbstractResourceType;
import com.spacekiller.game2d.resource.DefaultImageResource;
import com.spacekiller.game2d.resource.DefaultImageResourceCustomizer;
import java.awt.Color;
import java.beans.Customizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultImageResourceType
extends AbstractResourceType {
    public static final String TYPE_ID = "DefaultImageResourceType";
    public static final String NODE_RESOURCE_PATH = "resourcePath";
    public static final String NODE_BACKGROUND = "background";
    public static final String NODE_SCALE_FACTOR_X = "scaleFactorX";
    public static final String NODE_SCALE_FACTOR_Y = "scaleFactorY";
    public static final String NODE_ROTATE_THETA = "rotateTheta";
    private static DefaultImageResourceType INSTANCE;

    protected DefaultImageResourceType(String typeId) {
        super(typeId);
    }

    public static DefaultImageResourceType getDefaultImageResourceType() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultImageResourceType(TYPE_ID);
        }
        return INSTANCE;
    }

    @Override
    public Customizer createCustomizer(ResourceProvider provider) throws Exception {
        return new DefaultImageResourceCustomizer();
    }

    @Override
    public void writeResource(Resource resource, Node node, ResourceRegistry registry) throws Exception {
        if (resource instanceof DefaultImageResource) {
            double totateTheta;
            double scaleFactorY;
            double scaleFactorX;
            String backgroundString;
            Color background;
            DefaultImageResource imageResource = (DefaultImageResource)resource;
            this.clearChildNodes(node);
            String resourcePath = imageResource.getResourcePath();
            if (resourcePath != null) {
                Element element = this.createChildElement(node, NODE_RESOURCE_PATH, resourcePath);
                node.appendChild(element);
            }
            if ((background = imageResource.getBackground()) != null && (backgroundString = this.formatColor(background)) != null) {
                Element element = this.createChildElement(node, NODE_BACKGROUND, backgroundString);
                node.appendChild(element);
            }
            if ((scaleFactorX = imageResource.getScaleFactorX()) != 1.0) {
                String valueString = this.formatDouble(scaleFactorX);
                Element element = this.createChildElement(node, NODE_SCALE_FACTOR_X, valueString);
                node.appendChild(element);
            }
            if ((scaleFactorY = imageResource.getScaleFactorY()) != 1.0) {
                String valueString = this.formatDouble(scaleFactorY);
                Element element = this.createChildElement(node, NODE_SCALE_FACTOR_Y, valueString);
                node.appendChild(element);
            }
            if ((totateTheta = imageResource.getRotateTheta()) != 0.0) {
                String valueString = this.formatDouble(totateTheta);
                Element element = this.createChildElement(node, NODE_ROTATE_THETA, valueString);
                node.appendChild(element);
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported resource: " + resource.getClass());
    }

    @Override
    public Resource readResource(String id, Node node, ResourceRegistry registry) throws Exception {
        String resourcePath = this.getChildNodeValue(node, NODE_RESOURCE_PATH);
        Color background = null;
        String backgroundString = this.getChildNodeValue(node, NODE_BACKGROUND);
        if (backgroundString != null) {
            background = this.parseColor(backgroundString);
        }
        double scaleFactorX = 1.0;
        String scaleFactorXString = this.getChildNodeValue(node, NODE_SCALE_FACTOR_X);
        if (scaleFactorXString != null) {
            scaleFactorX = this.parseDouble(scaleFactorXString);
        }
        double scaleFactorY = 1.0;
        String scaleFactorYString = this.getChildNodeValue(node, NODE_SCALE_FACTOR_Y);
        if (scaleFactorYString != null) {
            scaleFactorY = this.parseDouble(scaleFactorYString);
        }
        double rotateTheta = 0.0;
        String rotateThetaString = this.getChildNodeValue(node, NODE_ROTATE_THETA);
        if (rotateThetaString != null) {
            rotateTheta = this.parseDouble(rotateThetaString);
        }
        return new DefaultImageResource(id, resourcePath, background, scaleFactorX, scaleFactorY, rotateTheta);
    }
}

