/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.BehaviorType;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.ElementType;
import com.spacekiller.game2d.Resource;
import com.spacekiller.game2d.ResourceType;
import com.spacekiller.game2d.resource.AbstractResourceRegistry;
import com.spacekiller.game2d.resource.DefaultElementTypeResourceType;
import com.spacekiller.game2d.sound.AudioSequence;
import java.awt.Image;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.sampled.Clip;

public class DefaultResourceRegistry
extends AbstractResourceRegistry {
    private Map resources = new HashMap();

    public CollisionBounds getCollisionBounds(String key) throws Exception {
        return (CollisionBounds)this.getObject(key);
    }

    @Override
    public Image getImage(String key) throws Exception {
        return (Image)this.getObject(key);
    }

    @Override
    public Clip getAudioClip(String key) throws Exception {
        return (Clip)this.getObject(key);
    }

    @Override
    public Object getObject(String key) throws Exception {
        Resource resource = (Resource)this.resources.get(key);
        if (resource == null) {
            throw new Exception("Resource not found: key=" + key);
        }
        return this.getObject(resource, key);
    }

    protected Object getObject(Resource resource, String key) throws Exception {
        Object object;
        try {
            object = resource.getObject();
        }
        catch (Exception e) {
            throw new Exception("Failed to get resource: key=" + key + ", resource=" + resource, e);
        }
        if (object == null) {
            System.out.println("getObject: " + key + " -> " + resource);
            throw new Exception("Resource not found: key=" + key + ", resource=" + resource);
        }
        return object;
    }

    @Override
    public URL getURL(String key) throws Exception {
        return (URL)this.getObject(key);
    }

    @Override
    public Iterator getKeys() {
        return this.resources.keySet().iterator();
    }

    @Override
    public int size() {
        return this.resources.size();
    }

    public boolean containsKey(String key) {
        return this.resources.containsKey(key);
    }

    @Override
    public ElementType getElementType(String key) throws Exception {
        return (ElementType)this.getObject(key);
    }

    @Override
    public void getElementTypes(Collection dst) throws Exception {
        this.getObjects(DefaultElementTypeResourceType.getDefaultElementTypeResourceType(), dst);
    }

    @Override
    public BehaviorType getBehaviorType(String key) throws Exception {
        return (BehaviorType)this.getObject(key);
    }

    @Override
    public void getObjects(ResourceType type, Collection dst) throws Exception {
        if (type == null || dst == null) {
            throw new NullPointerException();
        }
        for (String key : this.resources.keySet()) {
            Object value;
            ResourceType resourceType;
            Resource resource = (Resource)this.resources.get(key);
            if (resource == null || (resourceType = resource.getType()) == null || !type.getClass().isAssignableFrom(resourceType.getClass()) || (value = this.getObject(resource, key)) == null) continue;
            dst.add(value);
        }
    }

    @Override
    public AudioSequence getAudioSequence(String key) throws Exception {
        return (AudioSequence)this.getObject(key);
    }

    @Override
    public void add(Resource resource) {
        String key;
        if (resource != null && (key = resource.getId()) != null) {
            this.resources.put(key, resource);
        }
    }

    @Override
    public void remove(Resource resource) {
        String key;
        if (resource != null && (key = resource.getId()) != null && this.resources.get(key) == resource) {
            this.resources.remove(key);
        }
    }

    public void dump(PrintStream out) {
        Resource resource;
        out.println("------- " + this + " -------");
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        for (String key : this.resources.keySet()) {
            resource = (Resource)this.resources.get(key);
            map.put(key, resource);
        }
        for (String key : map.keySet()) {
            resource = (Resource)this.resources.get(key);
            out.println("" + key + " => " + resource);
        }
    }

    @Override
    public Resource getResource(String key) {
        return (Resource)this.resources.get(key);
    }
}

