/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.resource.AbstractImageResource;
import com.spacekiller.game2d.resource.DefaultImageResourceType;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.util.ImageToolkit;
import java.awt.Image;

public class RotatedImageResource
extends AbstractImageResource {
    private ImageResource imageResource;
    private double theta;

    public RotatedImageResource(String id, ImageResource imageResource, double theta) {
        super(id, DefaultImageResourceType.getDefaultImageResourceType());
        this.imageResource = imageResource;
        this.theta = theta;
    }

    @Override
    protected Image createImage() throws Exception {
        Image image = this.imageResource.getImage();
        Image rotatedImage = null;
        if (image != null) {
            rotatedImage = ImageToolkit.getInstance().createRotatedImage(image, this.theta);
        }
        return rotatedImage;
    }

    @Override
    public String toString() {
        return "RotatedImageResource[image=" + this.imageResource + ", theta=" + this.theta + "]";
    }
}

