/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.resource.AbstractAnimationResource;
import com.spacekiller.game2d.resource.AnimationResource;
import com.spacekiller.game2d.resource.DefaultAnimationResourceType;
import com.spacekiller.game2d.util.ImageToolkit;

public class ScaledAnimationResource
extends AbstractAnimationResource {
    private AnimationResource animationResource;
    private int width;
    private int height;
    private int hints;

    public ScaledAnimationResource(String id, AnimationResource animationResource, int width, int height, int hints) {
        super(id, DefaultAnimationResourceType.getAnimationResourceType());
        this.animationResource = animationResource;
        this.width = width;
        this.height = height;
        this.hints = hints;
    }

    @Override
    protected Animation createAnimation() throws Exception {
        Animation ani = this.animationResource.getAnimation();
        Animation scaledAnimation = null;
        if (ani != null) {
            scaledAnimation = ImageToolkit.getInstance().createScaledAnimation(ani, this.width, this.height, this.hints);
        }
        return scaledAnimation;
    }

    @Override
    public String toString() {
        return "ScaledAnimationResource[animation=" + this.animationResource + ", width=" + this.width + ", height=" + this.height + ", hints=" + this.hints + "]";
    }
}

