/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.resource;

import com.spacekiller.game2d.resource.AbstractImageResource;
import com.spacekiller.game2d.resource.DefaultImageResourceType;
import com.spacekiller.game2d.resource.ImageResource;
import com.spacekiller.game2d.util.ImageToolkit;
import java.awt.Image;

public class ScaledImageResource
extends AbstractImageResource {
    private ImageResource imageResource;
    private int width;
    private int height;
    private int hints;

    public ScaledImageResource(String id, ImageResource image, int width, int height, int hints) {
        super(id, DefaultImageResourceType.getDefaultImageResourceType());
        this.imageResource = image;
        this.width = width;
        this.height = height;
        this.hints = hints;
    }

    @Override
    protected Image createImage() throws Exception {
        Image image = this.imageResource.getImage();
        Image scaledImage = null;
        if (image != null) {
            scaledImage = ImageToolkit.getInstance().createScaledImage(image, this.width, this.height, this.hints);
        }
        return scaledImage;
    }

    @Override
    public String toString() {
        return "ScaledImageResource[image=" + this.imageResource + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

