/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.sound;

import com.spacekiller.game2d.sound.AudioFragment;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AudioBuffer
extends AudioFragment {
    AudioBuffer nextBuf;
    AudioBuffer prevBuf;
    private AudioFormat audioFormat;
    private byte[] buf;
    private int ofs;
    private int len;
    private boolean locked;

    public AudioBuffer(byte[] buf, int ofs, int len) {
        this.setBuffer(buf, ofs, len);
    }

    public AudioBuffer(AudioFormat format, byte[] buf, int ofs, int len) {
        this.setAudioFormat(format);
        this.setBuffer(buf, ofs, len);
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(AudioFormat f) {
        this.audioFormat = f;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    @Override
    public int getOffset() {
        return this.ofs;
    }

    @Override
    public int getLength() {
        return this.len;
    }

    public void setBuffer(byte[] buf, int ofs, int len) {
        this.buf = buf;
        this.ofs = ofs;
        this.len = len;
    }

    public InputStream createInputStream() {
        this.locked = true;
        return new AudioBufferInputStream();
    }

    public AudioInputStream createAudioInputStream() {
        InputStream stream = this.createInputStream();
        AudioFormat format = this.audioFormat;
        int frameSize = format.getFrameSize();
        int frames = this.len / frameSize;
        return new AudioInputStream(stream, format, frames);
    }

    public boolean isLocked() {
        return this.locked;
    }

    void setLocked(boolean locked) {
        this.locked = locked;
    }

    void dispose() {
        this.len = 0;
        this.locked = false;
    }

    @Override
    protected final boolean isFrag() {
        return false;
    }

    protected class AudioBufferInputStream
    extends InputStream {
        private int i;
        private int end;

        public AudioBufferInputStream() {
            this.i = AudioBuffer.this.ofs;
            this.end = AudioBuffer.this.ofs + AudioBuffer.this.len;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int num) throws IOException {
            AudioBuffer.this.locked = true;
            int avail = this.end - this.i;
            if (num <= avail) {
                System.arraycopy(AudioBuffer.this.buf, this.i, b, off, num);
                this.i += num;
                return num;
            }
            System.arraycopy(AudioBuffer.this.buf, this.i, b, off, avail);
            this.i = this.end;
            return avail;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public void close() throws IOException {
            super.close();
            AudioBuffer.this.locked = false;
        }
    }
}

