/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.sound;

import com.spacekiller.game2d.sound.AudioBuffer;
import com.spacekiller.game2d.sound.AudioFragment;
import java.util.ArrayList;
import java.util.HashSet;

public class AudioBufferPool {
    private byte[] buf;
    private int size;
    private AudioFragment first;
    private AudioFragment last;
    private Frag firstFrag;
    private Frag lastFrag;
    private AudioBuffer firstBuf;
    private AudioBuffer lastBuf;

    public AudioBufferPool(byte[] buf) {
        this.buf = buf;
        this.size = buf.length;
        Frag frag = new Frag();
        frag.ofs = 0;
        frag.len = this.size;
        this.first = frag;
        this.last = frag;
        this.firstFrag = frag;
        this.lastFrag = frag;
    }

    public AudioBufferPool(int length) {
        this(new byte[length]);
    }

    public AudioBuffer allocate(int len) {
        if (len > this.size) {
            return null;
        }
        Frag frag = this.firstFrag;
        while (frag != null) {
            if (frag.len >= len) {
                AudioBuffer rc = this.alloc(frag, len);
                return rc;
            }
            frag = frag.nextFrag;
        }
        AudioBuffer nextBuffer = this.firstBuf;
        while (nextBuffer != null) {
            Frag nf;
            Frag pf;
            boolean nextIsFrag;
            AudioBuffer buffer = nextBuffer;
            nextBuffer = buffer.nextBuf;
            if (buffer.isLocked()) continue;
            int bufferLen = buffer.getLength();
            frag = null;
            AudioFragment prev = buffer.prev;
            AudioFragment next = buffer.next;
            boolean prevIsFrag = prev == null ? false : prev.isFrag();
            boolean bl = nextIsFrag = next == null ? false : next.isFrag();
            if (prevIsFrag) {
                if (nextIsFrag) {
                    pf = (Frag)prev;
                    nf = (Frag)next;
                    pf.len += bufferLen + nf.len;
                    pf.next = nf;
                    nf.prev = pf;
                    this.unlinkFrag(nf);
                    frag = pf;
                } else {
                    pf = (Frag)prev;
                    pf.len += bufferLen;
                    frag = pf;
                    frag.next = next;
                    if (next == null) {
                        this.last = frag;
                    } else {
                        frag.next.prev = frag;
                    }
                }
            } else if (nextIsFrag) {
                Frag nf2 = (Frag)next;
                nf2.len += bufferLen;
                nf2.ofs -= bufferLen;
                frag = nf2;
                frag.prev = prev;
                if (prev == null) {
                    this.first = frag;
                } else {
                    frag.prev.next = frag;
                }
            } else {
                frag = new Frag();
                frag.ofs = buffer.getOffset();
                frag.len = buffer.getLength();
                pf = this.prevFrag(buffer);
                nf = this.nextFrag(buffer);
                frag.prev = prev;
                frag.next = next;
                if (frag.prev == null) {
                    this.first = frag;
                } else {
                    frag.prev.next = frag;
                }
                if (frag.next == null) {
                    this.last = frag;
                } else {
                    frag.next.prev = frag;
                }
                frag.prevFrag = pf;
                frag.nextFrag = nf;
                if (pf == null) {
                    this.firstFrag = frag;
                } else {
                    pf.nextFrag = frag;
                }
                if (nf == null) {
                    this.lastFrag = frag;
                } else {
                    nf.prevFrag = frag;
                }
            }
            System.out.println("Dispose buffer: " + buffer);
            if (buffer.prevBuf == null) {
                this.firstBuf = buffer.nextBuf;
            } else {
                buffer.prevBuf.nextBuf = buffer.nextBuf;
            }
            if (buffer.nextBuf == null) {
                this.lastBuf = buffer.prevBuf;
            } else {
                buffer.nextBuf.prevBuf = buffer.prevBuf;
            }
            buffer.prev = null;
            buffer.next = null;
            buffer.dispose();
            if (frag.len < len) continue;
            AudioBuffer rc = this.alloc(frag, len);
            return rc;
        }
        return null;
    }

    protected AudioBuffer alloc(Frag frag, int len) {
        int o = frag.ofs;
        AudioFragment prev = null;
        AudioFragment next = null;
        if (frag.len == len) {
            System.out.println("Unlink frag: " + frag);
            if (frag.prevFrag == null) {
                this.firstFrag = frag.nextFrag;
            } else {
                frag.prevFrag.nextFrag = frag.nextFrag;
            }
            if (frag.nextFrag == null) {
                this.lastFrag = frag.prevFrag;
            } else {
                frag.nextFrag.prevFrag = frag.prevFrag;
            }
            prev = frag.prev;
            next = frag.next;
            this.unlinkFragment(frag);
        } else {
            frag.ofs += len;
            frag.len -= len;
            prev = frag.prev;
            next = frag;
        }
        AudioBuffer buffer = new AudioBuffer(this.buf, o, len);
        buffer.prev = prev;
        buffer.next = next;
        if (prev == null) {
            this.first = buffer;
        } else {
            prev.next = buffer;
        }
        if (next == null) {
            this.last = buffer;
        } else {
            next.prev = buffer;
        }
        buffer.prevBuf = this.lastBuf;
        buffer.nextBuf = null;
        if (this.lastBuf == null) {
            this.firstBuf = buffer;
        } else {
            this.lastBuf.nextBuf = buffer;
        }
        this.lastBuf = buffer;
        return buffer;
    }

    protected void unlinkFrag(Frag frag) {
        if (frag.prevFrag == null) {
            this.firstFrag = frag.nextFrag;
        } else {
            frag.prevFrag.nextFrag = frag.nextFrag;
        }
        if (frag.nextFrag == null) {
            this.lastFrag = frag.prevFrag;
        } else {
            frag.nextFrag.prevFrag = frag.prevFrag;
        }
        this.unlinkFragment(frag);
    }

    protected void unlinkFragment(AudioFragment af) {
        if (af.prev == null) {
            this.first = af.next;
        } else {
            af.prev.next = af.next;
        }
        if (af.next == null) {
            this.last = af.prev;
        } else {
            af.next.prev = af.prev;
        }
    }

    protected Frag nextFrag(AudioFragment af) {
        AudioFragment f = af.next;
        while (f != null) {
            if (f.isFrag()) {
                return (Frag)f;
            }
            f = f.next;
        }
        return null;
    }

    protected Frag prevFrag(AudioFragment af) {
        AudioFragment f = af.prev;
        while (f != null) {
            if (f.isFrag()) {
                return (Frag)f;
            }
            f = f.prev;
        }
        return null;
    }

    public void checkConsistency() {
        HashSet<AudioFragment> set = new HashSet<AudioFragment>();
        AudioFragment f = this.first;
        int ofs = 0;
        AudioFragment prev = null;
        ArrayList<AudioFragment> frags = new ArrayList<AudioFragment>();
        ArrayList<AudioFragment> bufs = new ArrayList<AudioFragment>();
        while (f != null) {
            if (set.contains(f)) {
                throw new RuntimeException("Loop in pool: " + f);
            }
            set.add(f);
            if (f.getOffset() != ofs) {
                throw new RuntimeException("Invalid buffer offset: " + f + " => " + f.getOffset() + " != " + ofs);
            }
            ofs += f.getLength();
            if (f.isFrag()) {
                frags.add(f);
            } else {
                bufs.add(f);
            }
            prev = f;
            f = f.next;
        }
        if (prev != this.last) {
            throw new RuntimeException("Invalid last fragment: " + prev + " != " + this.last);
        }
        Frag frag = this.firstFrag;
        int i = 0;
        while (frag != null) {
            if (frag != frags.get(i)) {
                throw new RuntimeException("Invalid frag order: " + frag + " != " + frags.get(i));
            }
            frag = frag.nextFrag;
            ++i;
        }
        if (i != frags.size()) {
            throw new RuntimeException("Invalid number of fragments: " + i + " != " + frags.size());
        }
        AudioBuffer buf = this.firstBuf;
        while (buf != null) {
            if (!bufs.contains(buf)) {
                throw new RuntimeException("Invalid buffer: " + buf);
            }
            bufs.remove(buf);
            buf = buf.nextBuf;
        }
        if (!bufs.isEmpty()) {
            throw new RuntimeException("Missing " + bufs.size() + " buffers in order!");
        }
    }

    public void touch(AudioBuffer buf) {
        if (this.lastBuf == buf) {
            return;
        }
        if (buf.nextBuf == null) {
            return;
        }
        if (buf.prevBuf == null) {
            this.firstBuf = buf.nextBuf;
        } else {
            buf.prevBuf.nextBuf = buf.nextBuf;
        }
        buf.nextBuf.prevBuf = buf.prevBuf;
        buf.prevBuf = this.lastBuf;
        buf.nextBuf = null;
        if (this.lastBuf == null) {
            this.firstBuf = buf;
        } else {
            this.lastBuf.nextBuf = buf;
        }
        this.lastBuf = buf;
    }

    public void lock(AudioBuffer buffer) {
        buffer.setLocked(true);
    }

    public void unlock(AudioBuffer buffer) {
        buffer.setLocked(false);
    }

    protected class Frag
    extends AudioFragment {
        public int ofs;
        public int len;
        public Frag prevFrag;
        public Frag nextFrag;

        protected Frag() {
        }

        @Override
        protected boolean isFrag() {
            return true;
        }

        @Override
        public int getLength() {
            return this.len;
        }

        @Override
        public int getOffset() {
            return this.ofs;
        }
    }
}

