/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.sound;

import com.spacekiller.game2d.sound.AudioSequence;
import com.spacekiller.game2d.sound.URLAudioSequence;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class AudioPlayer
implements Runnable {
    private boolean running = false;
    private boolean cancel = false;
    private boolean stop = false;
    private byte[] buf;
    private int bufOfs;
    private boolean loop = false;
    private List list = new ArrayList();
    private int index;
    private AudioFormat format = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.running = true;
            DataLine line = null;
            AudioSequence sequence = null;
            while (!this.stop) {
                AudioPlayer audioPlayer = this;
                synchronized (audioPlayer) {
                    if (this.index < this.list.size()) {
                        sequence = (AudioSequence)this.list.get(this.index++);
                    } else {
                        this.index = 0;
                        sequence = this.list.isEmpty() ? null : (AudioSequence)this.list.get(this.index++);
                    }
                }
                if (sequence != null) {
                    try {
                        sequence.reset();
                        AudioInputStream astream = null;
                        while (!this.stop && !this.cancel) {
                            AudioInputStream stream = sequence.nextAudioInputStream();
                            if (stream == null) {
                                System.out.println("oops, stream=null >> sequence: " + sequence);
                                break;
                            }
                            astream = stream;
                            AudioFormat streamFormat = stream.getFormat();
                            if (this.format == null || line == null || !this.equalFormats(this.format, streamFormat)) {
                                if (line != null) {
                                    line.drain();
                                    line.stop();
                                    line = null;
                                }
                                this.format = streamFormat;
                                DataLine.Info info = new DataLine.Info(SourceDataLine.class, stream.getFormat());
                                line = (SourceDataLine)AudioSystem.getLine(info);
                                line.open(stream.getFormat());
                                line.start();
                                this.bufOfs = 0;
                            }
                            if (this.buf == null || this.buf.length != line.getBufferSize()) {
                                this.buf = new byte[line.getBufferSize()];
                            }
                            this.cancel = false;
                            this.play(stream, (SourceDataLine)line);
                            stream.close();
                        }
                        if (astream != null) continue;
                        if (this.cancel && !this.stop) {
                            this.cancel = false;
                            this.index = 0;
                            continue;
                        }
                        System.out.println("TODO: No sound stream! => " + sequence);
                        sequence.reset();
                        astream = sequence.nextAudioInputStream();
                        if (astream != null) {
                            System.out.println("TODO: AHA astream=" + astream);
                            astream.close();
                            sequence.reset();
                            continue;
                        }
                        this.list.clear();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        this.list.remove(--this.index);
                    }
                    continue;
                }
                System.out.println("OOPS, No more sound input!");
                if (line != null) {
                    line.drain();
                    line.stop();
                    line = null;
                }
                if (this.stop) continue;
                audioPlayer = this;
                synchronized (audioPlayer) {
                    this.wait();
                }
            }
            if (line != null) {
                line.drain();
                line.stop();
                line = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            this.running = false;
        }
    }

    protected void play(AudioInputStream in, SourceDataLine out) throws Exception {
        this.cancel = false;
        int numRead = 0;
        int bufLen = this.buf.length;
        while (!this.cancel && (numRead = in.read(this.buf, this.bufOfs, bufLen - this.bufOfs)) >= 0) {
            this.bufOfs += numRead;
            if (this.bufOfs < bufLen) continue;
            for (int offset = 0; offset < bufLen; offset += out.write(this.buf, offset, bufLen - offset)) {
                Thread.yield();
            }
            this.bufOfs = 0;
        }
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.stop = false;
        this.cancel = false;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stop = true;
        this.cancel = true;
        AudioPlayer audioPlayer = this;
        synchronized (audioPlayer) {
            this.notify();
        }
    }

    public void add(URL url) {
        this.add(new URLAudioSequence(url));
    }

    public synchronized void add(AudioSequence seq) {
        if (seq == null) {
            return;
        }
        this.list.add(seq);
        if (this.running) {
            this.notify();
        }
    }

    public synchronized void clear() {
        this.index = 0;
        this.list.clear();
    }

    public synchronized void skip() {
        this.cancel = true;
    }

    protected AudioInputStream getAudioInputStream(URL url) throws Exception {
        return AudioSystem.getAudioInputStream(url);
    }

    protected boolean equalFormats(AudioFormat f1, AudioFormat f2) {
        if (f1.getFrameSize() != f2.getFrameSize()) {
            return false;
        }
        if (f1.getFrameRate() != f2.getFrameRate()) {
            return false;
        }
        return f1.getChannels() == f2.getChannels();
    }

    public boolean isRunning() {
        return this.running;
    }
}

