/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.sound;

import com.spacekiller.game2d.sound.AudioSequence;
import javax.sound.sampled.AudioInputStream;

public class LoopAudioSequence
implements AudioSequence {
    public static final int LOOP_FOREVER = -1;
    private int count;
    private AudioSequence audioSequence;
    private int done = 0;
    private AudioSequence current = null;

    public LoopAudioSequence(AudioSequence seq, int count) {
        this.setAudioSequence(seq);
        this.setCount(count);
    }

    @Override
    public AudioInputStream nextAudioInputStream() throws Exception {
        AudioSequence seq;
        if (this.current != null) {
            AudioInputStream rc = this.current.nextAudioInputStream();
            if (rc != null) {
                return rc;
            }
            this.current = null;
        }
        if ((seq = this.getAudioSequence()) == null) {
            return null;
        }
        if (this.done >= this.count && this.count >= 0) {
            return null;
        }
        this.current = seq;
        ++this.done;
        seq.reset();
        return seq.nextAudioInputStream();
    }

    @Override
    public void reset() {
        this.done = 0;
        this.current = null;
    }

    public AudioSequence getAudioSequence() {
        return this.audioSequence;
    }

    public void setAudioSequence(AudioSequence audioSequence) {
        this.audioSequence = audioSequence;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

