/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.sound;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;

public class PooledAudioClip
implements Clip {
    private URL audioFile;
    private ArrayList clips = new ArrayList();
    private int maxClips = -1;

    public PooledAudioClip(URL audioFile) throws Exception {
        this.setAudioFile(audioFile);
        Clip clip = this.createClip();
        this.clips.add(clip);
    }

    protected AudioInputStream createAudioInputStream() throws Exception {
        return AudioSystem.getAudioInputStream(this.audioFile);
    }

    protected Clip createClip() throws Exception {
        AudioInputStream audioInput = this.createAudioInputStream();
        AudioFormat format = audioInput.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, format);
        Clip clip = (Clip)AudioSystem.getLine(info);
        clip.open(audioInput);
        return clip;
    }

    @Override
    public int getFrameLength() {
        throw new UnsupportedOperationException("PENDING");
    }

    @Override
    public long getMicrosecondLength() {
        throw new UnsupportedOperationException("PENDING");
    }

    @Override
    public void loop(int count) {
        throw new UnsupportedOperationException("PENDING");
    }

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        throw new UnsupportedOperationException("PENDING");
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        throw new UnsupportedOperationException("PENDING");
    }

    @Override
    public void setFramePosition(int frames) {
    }

    @Override
    public void setLoopPoints(int start, int end) {
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public void drain() {
    }

    @Override
    public void flush() {
    }

    @Override
    public int getBufferSize() {
        return 0;
    }

    @Override
    public AudioFormat getFormat() {
        return null;
    }

    @Override
    public int getFramePosition() {
        return 0;
    }

    @Override
    public long getLongFramePosition() {
        return 0L;
    }

    @Override
    public float getLevel() {
        return 0.0f;
    }

    @Override
    public long getMicrosecondPosition() {
        return 0L;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void start() {
        for (Clip clip : this.clips) {
            if (clip.isRunning()) continue;
            clip.setFramePosition(0);
            clip.start();
            return;
        }
        try {
            if (this.clips.size() >= this.maxClips && this.maxClips > 0) {
                return;
            }
            Clip clip = this.createClip();
            this.clips.add(clip);
            clip.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void addLineListener(LineListener listener) {
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl(Control.Type control) {
        return null;
    }

    @Override
    public Control[] getControls() {
        return null;
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return false;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void open() throws LineUnavailableException {
    }

    @Override
    public void removeLineListener(LineListener listener) {
    }

    @Override
    public Line.Info getLineInfo() {
        return null;
    }

    public URL getAudioFile() {
        return this.audioFile;
    }

    public void setAudioFile(URL url) {
        this.audioFile = url;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.audioFile + "]";
    }

    public int getMaxClips() {
        return this.maxClips;
    }

    public void setMaxClips(int i) {
        this.maxClips = i;
    }
}

