/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.sound;

import com.spacekiller.game2d.sound.AudioBuffer;
import com.spacekiller.game2d.sound.AudioBufferPool;
import com.spacekiller.game2d.sound.AudioSequence;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class PooledAudioSequence
implements AudioSequence {
    private AudioSequence sequence;
    private AudioBufferPool pool;
    private AudioBuffer buffer;
    private boolean buffered;
    private boolean done;

    public PooledAudioSequence(AudioSequence sequence, AudioBufferPool pool) {
        this.sequence = sequence;
        this.pool = pool;
    }

    @Override
    public AudioInputStream nextAudioInputStream() throws Exception {
        if (this.done) {
            return null;
        }
        this.done = true;
        if (this.buffer != null && this.buffered) {
            if (this.buffer.getLength() > 0) {
                this.pool.touch(this.buffer);
                AudioInputStream bin = this.buffer.createAudioInputStream();
                if (bin != null) {
                    return bin;
                }
            }
            this.buffer = null;
        }
        this.sequence.reset();
        AudioInputStream in = this.sequence.nextAudioInputStream();
        if (in == null) {
            return null;
        }
        AudioInputStream pooled = this.createPooledAudioInputStream(in);
        if (pooled == null) {
            return in;
        }
        return pooled;
    }

    protected AudioInputStream createPooledAudioInputStream(AudioInputStream in) throws Exception {
        long frames = in.getFrameLength();
        if (frames < 1L) {
            return null;
        }
        AudioFormat format = in.getFormat();
        int frameCount = (int)frames;
        int frameSize = format.getFrameSize();
        int len = frameCount * frameSize;
        this.buffer = this.pool.allocate(len);
        if (this.buffer == null) {
            return null;
        }
        this.buffer.setLocked(true);
        this.buffer.setAudioFormat(format);
        PoolInputStream poolIn = new PoolInputStream(in, this.buffer);
        return new AudioInputStream(poolIn, format, frames);
    }

    @Override
    public void reset() {
        this.done = false;
    }

    public AudioSequence getSequence() {
        return this.sequence;
    }

    protected void setSequence(AudioSequence sequence) {
        this.sequence = sequence;
    }

    public boolean isBuffered() {
        AudioBuffer abuf = this.buffer;
        if (abuf == null) {
            return false;
        }
        if (!this.buffered) {
            return false;
        }
        return this.buffer.getLength() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buffer(byte[] temp) throws Exception {
        if (this.buffer != null && this.buffered && this.buffer.getLength() > 0) {
            return true;
        }
        this.sequence.reset();
        AudioInputStream in = this.sequence.nextAudioInputStream();
        if (in == null) {
            return false;
        }
        try {
            int n;
            AudioInputStream pooled = this.createPooledAudioInputStream(in);
            if (pooled == null) {
                boolean bl = false;
                return bl;
            }
            while ((n = pooled.read(temp)) >= 0) {
            }
            pooled.close();
        }
        finally {
            in.close();
        }
        return true;
    }

    public String toString() {
        return super.toString() + "[" + this.sequence + "]";
    }

    protected class PoolInputStream
    extends InputStream {
        private AudioInputStream in;
        private byte[] buf;
        private int ofs;
        private int len;
        private int pos;

        public PoolInputStream(AudioInputStream in, AudioBuffer buffer) {
            this.in = in;
            this.buf = buffer.getBuffer();
            this.ofs = buffer.getOffset();
            this.len = buffer.getLength();
            this.pos = this.ofs;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int num) throws IOException {
            int n = this.in.read(this.buf, this.pos, num);
            System.arraycopy(this.buf, this.pos, b, off, n);
            this.pos += n;
            if (this.pos - this.ofs >= this.len) {
                PooledAudioSequence.this.buffered = true;
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            super.close();
            PooledAudioSequence.this.buffer.setLocked(false);
        }
    }
}

