/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.surface;

import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferStrategy;

public class BeneBlitBufferStrategy
extends BufferStrategy {
    protected GraphicsConfiguration config;
    protected Graphics2D onScreen;
    protected Graphics2D offScreen;
    protected Image offImage;
    protected BufferCapabilities capabilities;

    public BeneBlitBufferStrategy(Graphics2D screen, GraphicsConfiguration cfg) {
        this.initStrategy(screen, cfg);
    }

    public BeneBlitBufferStrategy(Component component) {
        this.initStrategy((Graphics2D)component.getGraphics(), component.getGraphicsConfiguration());
    }

    protected void initStrategy(Graphics2D screen, GraphicsConfiguration cfg) {
        this.onScreen = screen;
        this.config = cfg;
        this.capabilities = this.config.getBufferCapabilities();
        Rectangle bounds = this.config.getBounds();
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        try {
            boolean accelerated = true;
            ImageCapabilities caps = new ImageCapabilities(accelerated);
            this.offImage = this.config.createCompatibleVolatileImage(width, height, caps, 1);
        }
        catch (Throwable e) {
            this.offImage = this.config.createCompatibleVolatileImage(width, height);
        }
        this.offScreen = (Graphics2D)this.offImage.getGraphics();
        this.offScreen.setColor(Color.blue);
        this.offScreen.fillRect(0, 0, width, height);
        this.offScreen.setColor(Color.RED);
        this.offScreen.fillRect(300, 100, 100, 100);
        this.offScreen.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.offScreen.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        System.out.println("" + this + " initialized: " + width + " x " + height);
        BufferCapabilities bufCaps = this.config.getBufferCapabilities();
        System.out.println("BufferCapabilities: " + bufCaps);
        System.out.println(" - isFullScreenRequired = " + bufCaps.isFullScreenRequired());
        System.out.println(" - isPageFlipping = " + bufCaps.isPageFlipping());
        System.out.println(" - isMultiBufferAvailable = " + bufCaps.isMultiBufferAvailable());
    }

    @Override
    public boolean contentsLost() {
        return false;
    }

    @Override
    public boolean contentsRestored() {
        return false;
    }

    @Override
    public BufferCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public Graphics getDrawGraphics() {
        return this.offScreen;
    }

    @Override
    public void show() {
        this.onScreen.drawImage(this.offImage, 0, 0, null);
    }
}

