/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.ui;

import com.spacekiller.game2d.ClockType;
import com.spacekiller.game2d.DefaultGameConfig;
import com.spacekiller.game2d.Environment;
import com.spacekiller.game2d.InputBinder;
import com.spacekiller.game2d.InputManager;
import com.spacekiller.game2d.SurfaceType;
import com.spacekiller.util.swing.DisplayModePropertyEditor;
import com.spacekiller.util.swing.GraphicsDevicePropertyEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DefaultGameConfigCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = 711905913382238494L;
    private Environment environment;
    private DefaultGameConfig gameConfig;
    private boolean refreshing = false;
    private JPanel jPanelOptions = null;
    private JRadioButton jRadioButtonWindowMode = null;
    private JRadioButton jRadioButtonFullscreen = null;
    private JCheckBox jCheckBoxAudioEnabled = null;
    private JComboBox jComboBoxClockStrategy = null;
    private JComboBox jComboBoxBufferStrategy = null;
    private JComboBox jComboBoxInputManager = null;
    private JComboBox jComboBoxInputBinder = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JPanel jPanel4 = null;
    private JLabel jLabel7 = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel5 = null;
    private JPanel jPanel3 = null;
    private JLabel jLabel6 = null;
    private DisplayModePropertyEditor displayModePropertyEditor = null;
    private JRadioButton jRadioButtonExclusive;
    private JLabel lblNewLabel;
    private GraphicsDevicePropertyEditor displayDevicePropertyEditor;

    public DefaultGameConfigCustomizer() {
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout3 = new GridLayout();
        this.setLayout(gridLayout3);
        this.setSize(503, 403);
        this.setBackground(Color.gray);
        gridLayout3.setRows(1);
        this.add((Component)this.getJPanelOptions(), null);
    }

    private JComboBox getJComboBoxInputBinder() {
        if (this.jComboBoxInputBinder == null) {
            this.jComboBoxInputBinder = new JComboBox();
            this.jComboBoxInputBinder.setOpaque(false);
            this.jComboBoxInputBinder.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DefaultGameConfigCustomizer.this.refreshing) {
                        int i = DefaultGameConfigCustomizer.this.getJComboBoxInputBinder().getSelectedIndex();
                        InputBinder binder = DefaultGameConfigCustomizer.this.getEnvironment().getInputBinderAt(i);
                        DefaultGameConfigCustomizer.this.getGameConfig().setProperty("inputBinder", binder.getId());
                    }
                }
            });
        }
        return this.jComboBoxInputBinder;
    }

    private JPanel getJPanelOptions() {
        if (this.jPanelOptions == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            this.jPanelOptions = new JPanel();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints21 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints51 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints52 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints12 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints61 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints71 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints8 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints34 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints11 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints22 = new GridBagConstraints();
            consGridBagConstraints22.weightx = 1.0;
            consGridBagConstraints22.fill = 2;
            consGridBagConstraints22.gridy = 5;
            consGridBagConstraints22.gridx = 1;
            consGridBagConstraints22.insets = new Insets(4, 4, 5, 4);
            consGridBagConstraints11.gridx = 0;
            consGridBagConstraints11.gridy = 5;
            consGridBagConstraints11.anchor = 17;
            consGridBagConstraints11.insets = new Insets(4, 4, 5, 5);
            consGridBagConstraints61.weightx = 1.0;
            consGridBagConstraints61.fill = 2;
            consGridBagConstraints61.gridx = 1;
            consGridBagConstraints61.gridy = 4;
            consGridBagConstraints61.insets = new Insets(4, 4, 5, 4);
            consGridBagConstraints71.weightx = 1.0;
            consGridBagConstraints71.fill = 2;
            consGridBagConstraints71.gridx = 1;
            consGridBagConstraints71.gridy = 3;
            consGridBagConstraints71.insets = new Insets(4, 4, 5, 4);
            consGridBagConstraints8.gridx = 0;
            consGridBagConstraints8.gridy = 4;
            consGridBagConstraints34.gridx = 1;
            consGridBagConstraints34.gridy = 7;
            consGridBagConstraints34.anchor = 17;
            consGridBagConstraints12.gridx = 0;
            consGridBagConstraints12.gridy = 3;
            consGridBagConstraints12.anchor = 17;
            consGridBagConstraints12.insets = new Insets(4, 4, 5, 5);
            consGridBagConstraints52.gridy = 7;
            consGridBagConstraints52.gridx = 0;
            consGridBagConstraints52.anchor = 18;
            consGridBagConstraints52.insets = new Insets(4, 4, 4, 5);
            consGridBagConstraints4.gridy = 9;
            consGridBagConstraints4.gridx = 1;
            consGridBagConstraints4.anchor = 12;
            consGridBagConstraints4.weighty = 1.0;
            consGridBagConstraints1.gridx = 0;
            consGridBagConstraints1.gridy = 0;
            consGridBagConstraints1.anchor = 17;
            consGridBagConstraints51.gridx = 1;
            consGridBagConstraints51.gridy = 0;
            consGridBagConstraints51.fill = 0;
            consGridBagConstraints51.anchor = 17;
            consGridBagConstraints21.gridx = 0;
            consGridBagConstraints21.gridy = 2;
            consGridBagConstraints21.anchor = 18;
            consGridBagConstraints21.insets = new Insets(4, 4, 5, 5);
            consGridBagConstraints34.insets = new Insets(4, 4, 4, 4);
            consGridBagConstraints51.insets = new Insets(4, 4, 5, 4);
            consGridBagConstraints1.insets = new Insets(4, 4, 5, 5);
            consGridBagConstraints8.insets = new Insets(4, 4, 5, 5);
            consGridBagConstraints8.anchor = 17;
            GridBagLayout gbl_jPanelOptions = new GridBagLayout();
            gbl_jPanelOptions.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            gbl_jPanelOptions.columnWeights = new double[]{0.0, 0.0};
            this.jPanelOptions.setLayout(gbl_jPanelOptions);
            this.jPanelOptions.add((Component)this.getJLabel3(), consGridBagConstraints1);
            this.jPanelOptions.add((Component)this.getJPanel3(), consGridBagConstraints51);
            GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
            gbc_lblNewLabel.anchor = 17;
            gbc_lblNewLabel.insets = new Insets(4, 4, 5, 5);
            gbc_lblNewLabel.gridx = 0;
            gbc_lblNewLabel.gridy = 1;
            this.jPanelOptions.add((Component)this.getLblNewLabel(), gbc_lblNewLabel);
            GridBagConstraints gbc_displayDevicePropertyEditor = new GridBagConstraints();
            gbc_displayDevicePropertyEditor.insets = new Insets(4, 4, 5, 4);
            gbc_displayDevicePropertyEditor.fill = 2;
            gbc_displayDevicePropertyEditor.gridx = 1;
            gbc_displayDevicePropertyEditor.gridy = 1;
            this.jPanelOptions.add((Component)this.getDisplayDevicePropertyEditor(), gbc_displayDevicePropertyEditor);
            this.jPanelOptions.add((Component)this.getJLabel6(), consGridBagConstraints12);
            this.jPanelOptions.add((Component)this.getJLabel7(), consGridBagConstraints8);
            this.jPanelOptions.add((Component)this.getJComboBoxClockStrategy(), consGridBagConstraints61);
            this.jPanelOptions.add((Component)this.getJComboBoxBufferStrategy(), consGridBagConstraints71);
            this.jPanelOptions.add((Component)this.getJLabel1(), consGridBagConstraints11);
            this.jPanelOptions.add((Component)this.getJComboBoxInputManager(), consGridBagConstraints22);
            this.jPanelOptions.setSize(500, 350);
            this.jPanelOptions.setBackground(new Color(0, 75, 97));
            this.jPanelOptions.setOpaque(false);
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 6;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(4, 4, 5, 5);
            jLabel2.setText("Input mapping:");
            jLabel2.setForeground(Color.white);
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 6;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.gridy = 2;
            gridBagConstraints9.anchor = 18;
            gridBagConstraints9.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.fill = 2;
            this.jPanelOptions.add((Component)this.getJLabel4(), consGridBagConstraints21);
            this.jPanelOptions.add((Component)this.getJLabel5(), consGridBagConstraints52);
            this.jPanelOptions.add((Component)this.getJPanel4(), consGridBagConstraints34);
            this.jPanelOptions.add((Component)jLabel2, gridBagConstraints1);
            this.jPanelOptions.add((Component)this.getJComboBoxInputBinder(), gridBagConstraints2);
            this.jPanelOptions.add((Component)this.getDisplayModePropertyEditor(), gridBagConstraints9);
            ButtonGroup buttonGroup1 = new ButtonGroup();
            buttonGroup1.add(this.getJRadioButtonWindowMode());
            buttonGroup1.add(this.getJRadioButtonFullscreen());
            buttonGroup1.add(this.getJRadioButtonExclusive());
        }
        return this.jPanelOptions;
    }

    private JRadioButton getJRadioButtonWindowMode() {
        if (this.jRadioButtonWindowMode == null) {
            this.jRadioButtonWindowMode = new JRadioButton();
            this.jRadioButtonWindowMode.setText("Window");
            this.jRadioButtonWindowMode.setOpaque(false);
            this.jRadioButtonWindowMode.setForeground(Color.WHITE);
            this.jRadioButtonWindowMode.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefaultGameConfigCustomizer.this.handleSurfaceModeChanged();
                }
            });
        }
        return this.jRadioButtonWindowMode;
    }

    private JRadioButton getJRadioButtonFullscreen() {
        if (this.jRadioButtonFullscreen == null) {
            this.jRadioButtonFullscreen = new JRadioButton();
            this.jRadioButtonFullscreen.setText("Fullscreen");
            this.jRadioButtonFullscreen.setOpaque(false);
            this.jRadioButtonFullscreen.setForeground(Color.WHITE);
            this.jRadioButtonFullscreen.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefaultGameConfigCustomizer.this.handleSurfaceModeChanged();
                }
            });
        }
        return this.jRadioButtonFullscreen;
    }

    private JCheckBox getJCheckBoxAudioEnabled() {
        if (this.jCheckBoxAudioEnabled == null) {
            this.jCheckBoxAudioEnabled = new JCheckBox();
            this.jCheckBoxAudioEnabled.setOpaque(false);
            this.jCheckBoxAudioEnabled.setText("enabled");
            this.jCheckBoxAudioEnabled.setForeground(Color.white);
            this.jCheckBoxAudioEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.jCheckBoxAudioEnabled;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            GridLayout layGridLayout2 = new GridLayout();
            layGridLayout2.setColumns(1);
            this.jPanel4.setLayout(layGridLayout2);
            this.jPanel4.add((Component)this.getJCheckBoxAudioEnabled(), null);
            this.jPanel4.setOpaque(false);
            this.jPanel4.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jPanel4;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("Clock strategy:");
            this.jLabel7.setForeground(Color.white);
        }
        return this.jLabel7;
    }

    private JComboBox getJComboBoxClockStrategy() {
        if (this.jComboBoxClockStrategy == null) {
            this.jComboBoxClockStrategy = new JComboBox();
            this.jComboBoxClockStrategy.setOpaque(false);
            this.jComboBoxClockStrategy.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DefaultGameConfigCustomizer.this.refreshing) {
                        int i = DefaultGameConfigCustomizer.this.getJComboBoxClockStrategy().getSelectedIndex();
                        ClockType type = DefaultGameConfigCustomizer.this.getEnvironment().getClockTypeAt(i);
                        DefaultGameConfigCustomizer.this.getGameConfig().setProperty("clockStrategy", type.getId());
                    }
                }
            });
        }
        return this.jComboBoxClockStrategy;
    }

    private JComboBox getJComboBoxBufferStrategy() {
        if (this.jComboBoxBufferStrategy == null) {
            this.jComboBoxBufferStrategy = new JComboBox();
            this.jComboBoxBufferStrategy.setOpaque(false);
            this.jComboBoxBufferStrategy.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DefaultGameConfigCustomizer.this.refreshing) {
                        int i = DefaultGameConfigCustomizer.this.getJComboBoxBufferStrategy().getSelectedIndex();
                        SurfaceType type = DefaultGameConfigCustomizer.this.getEnvironment().getSurfaceTypeAt(i);
                        DefaultGameConfigCustomizer.this.getGameConfig().setProperty("bufferStrategy", type.getId());
                    }
                }
            });
        }
        return this.jComboBoxBufferStrategy;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Input controller:");
            this.jLabel1.setForeground(Color.white);
        }
        return this.jLabel1;
    }

    private JComboBox getJComboBoxInputManager() {
        if (this.jComboBoxInputManager == null) {
            this.jComboBoxInputManager = new JComboBox();
            this.jComboBoxInputManager.setOpaque(false);
            this.jComboBoxInputManager.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DefaultGameConfigCustomizer.this.refreshing) {
                        int i = DefaultGameConfigCustomizer.this.getJComboBoxInputManager().getSelectedIndex();
                        InputManager type = DefaultGameConfigCustomizer.this.getEnvironment().getInputManagerAt(i);
                        DefaultGameConfigCustomizer.this.getGameConfig().setProperty("inputManager", type.getId());
                    }
                }
            });
        }
        return this.jComboBoxInputManager;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Surface:");
            this.jLabel3.setForeground(Color.white);
        }
        return this.jLabel3;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Display mode:");
            this.jLabel4.setForeground(Color.white);
        }
        return this.jLabel4;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.jPanel3.getLayout();
            flowLayout.setVgap(0);
            this.jPanel3.add((Component)this.getJRadioButtonWindowMode(), null);
            this.jPanel3.add((Component)this.getJRadioButtonFullscreen(), null);
            this.jPanel3.setOpaque(false);
            this.jPanel3.add(this.getJRadioButtonExclusive());
        }
        return this.jPanel3;
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Buffer strategy:");
            this.jLabel6.setForeground(Color.white);
        }
        return this.jLabel6;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Effects:");
            this.jLabel5.setForeground(Color.white);
        }
        return this.jLabel5;
    }

    public DefaultGameConfig getGameConfig() {
        return this.gameConfig;
    }

    public void setGameConfig(DefaultGameConfig gameConfig) {
        this.gameConfig = gameConfig;
        this.refresh();
    }

    @Override
    public void setObject(Object bean) {
        this.setGameConfig((DefaultGameConfig)bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            String surfaceMode = this.gameConfig.getProperty("surface");
            if ("window".equalsIgnoreCase(surfaceMode)) {
                this.getJRadioButtonWindowMode().setSelected(true);
            } else if ("exclusive".equalsIgnoreCase(surfaceMode)) {
                this.getJRadioButtonExclusive().setSelected(true);
            } else {
                this.getJRadioButtonFullscreen().setSelected(true);
            }
            String displayDeviceId = this.gameConfig.getProperty("displayDevice");
            GraphicsDevice displayDevice = null;
            if (displayDeviceId != null) {
                displayDevice = GraphicsDevicePropertyEditor.parseDisplayDevice((String)displayDeviceId);
            }
            if (displayDevice == null) {
                displayDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            }
            this.getDisplayDevicePropertyEditor().setDisplayDevice(displayDevice);
            String displayModeId = this.gameConfig.getProperty("displayMode");
            DisplayMode displayMode = null;
            if (displayModeId != null) {
                displayMode = DisplayModePropertyEditor.parseDisplayMode((GraphicsDevice)displayDevice, (String)displayModeId);
            }
            if (displayMode == null) {
                displayMode = displayDevice == null ? null : displayDevice.getDisplayMode();
            }
            this.getDisplayModePropertyEditor().setDevice(displayDevice);
            this.getDisplayModePropertyEditor().setDisplayMode(displayMode);
            this.getJComboBoxBufferStrategy().removeAllItems();
            String surfaceTypeId = this.gameConfig.getProperty("bufferStrategy");
            SurfaceType selSurface = null;
            if (surfaceTypeId != null) {
                selSurface = this.environment.getSurfaceType(surfaceTypeId);
            }
            int num = this.environment.getSurfaceTypeCount();
            int selSurfaceIndex = -1;
            for (int c = 0; c < num; ++c) {
                SurfaceType surface = this.environment.getSurfaceTypeAt(c);
                if (surface == selSurface) {
                    selSurfaceIndex = c;
                }
                this.getJComboBoxBufferStrategy().addItem("" + (c + 1) + ". " + surface);
            }
            if (selSurfaceIndex >= 0) {
                this.getJComboBoxBufferStrategy().setSelectedIndex(selSurfaceIndex);
            }
            this.getJComboBoxClockStrategy().removeAllItems();
            String clockTypeId = this.gameConfig.getProperty("clockStrategy");
            ClockType selClockType = null;
            if (clockTypeId != null) {
                selClockType = this.environment.getClockType(clockTypeId);
            }
            num = this.environment.getClockTypeCount();
            int selClockIndex = -1;
            for (int c = 0; c < num; ++c) {
                ClockType clock = this.environment.getClockTypeAt(c);
                if (clock == selClockType) {
                    selClockIndex = c;
                }
                this.getJComboBoxClockStrategy().addItem("" + (c + 1) + ". " + clock);
            }
            if (selClockIndex >= 0) {
                this.getJComboBoxClockStrategy().setSelectedIndex(selClockIndex);
            }
            this.getJComboBoxInputManager().removeAllItems();
            String selInputManagerId = this.gameConfig.getProperty("inputManager");
            InputManager selInputManager = null;
            if (selInputManagerId != null) {
                selInputManager = this.environment.getInputManager(selInputManagerId);
            }
            num = this.environment.getInputManagerCount();
            int selInputManagerIndex = -1;
            for (int c = 0; c < num; ++c) {
                InputManager manager = this.environment.getInputManagerAt(c);
                if (manager == selInputManager) {
                    selInputManagerIndex = c;
                }
                this.getJComboBoxInputManager().addItem("" + (c + 1) + ". " + manager);
            }
            if (selInputManagerIndex >= 0) {
                this.getJComboBoxInputManager().setSelectedIndex(selInputManagerIndex);
            }
            this.getJComboBoxInputBinder().removeAllItems();
            String selInputBinderId = this.gameConfig.getProperty("inputBinder");
            InputBinder selInputBinder = null;
            if (selInputBinderId != null) {
                selInputBinder = this.environment.getInputBinder(selInputBinderId);
            }
            num = this.environment.getInputBinderCount();
            int selInputBinderIndex = -1;
            for (int c = 0; c < num; ++c) {
                InputBinder binder = this.environment.getInputBinderAt(c);
                if (binder == selInputBinder) {
                    selInputBinderIndex = c;
                }
                this.getJComboBoxInputBinder().addItem("" + (c + 1) + ". " + binder);
            }
            if (selInputBinderIndex >= 0) {
                this.getJComboBoxInputBinder().setSelectedIndex(selInputBinderIndex);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private DisplayModePropertyEditor getDisplayModePropertyEditor() {
        if (this.displayModePropertyEditor == null) {
            this.displayModePropertyEditor = new DisplayModePropertyEditor();
            this.displayModePropertyEditor.setForeground(Color.WHITE);
            this.displayModePropertyEditor.setOpaque(false);
            this.displayModePropertyEditor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!DefaultGameConfigCustomizer.this.refreshing) {
                        String mode = DefaultGameConfigCustomizer.this.displayModePropertyEditor.getAsText();
                        DefaultGameConfigCustomizer.this.getGameConfig().setProperty("displayMode", mode);
                    }
                }
            });
        }
        return this.displayModePropertyEditor;
    }

    private JRadioButton getJRadioButtonExclusive() {
        if (this.jRadioButtonExclusive == null) {
            this.jRadioButtonExclusive = new JRadioButton("Exclusive");
            this.jRadioButtonExclusive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefaultGameConfigCustomizer.this.handleSurfaceModeChanged();
                }
            });
            this.jRadioButtonExclusive.setForeground(Color.WHITE);
            this.jRadioButtonExclusive.setOpaque(false);
        }
        return this.jRadioButtonExclusive;
    }

    private JLabel getLblNewLabel() {
        if (this.lblNewLabel == null) {
            this.lblNewLabel = new JLabel("Display device:");
            this.lblNewLabel.setForeground(Color.WHITE);
        }
        return this.lblNewLabel;
    }

    private GraphicsDevicePropertyEditor getDisplayDevicePropertyEditor() {
        if (this.displayDevicePropertyEditor == null) {
            this.displayDevicePropertyEditor = new GraphicsDevicePropertyEditor();
            this.displayDevicePropertyEditor.setOpaque(false);
            this.displayDevicePropertyEditor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DefaultGameConfigCustomizer.this.handleDisplayDeviceChanged();
                }
            });
        }
        return this.displayDevicePropertyEditor;
    }

    protected void handleSurfaceModeChanged() {
        boolean window = this.getJRadioButtonWindowMode().isSelected();
        boolean exclusive = this.getJRadioButtonExclusive().isSelected();
        this.getDisplayDevicePropertyEditor().setEnabled(exclusive);
        this.getDisplayModePropertyEditor().setEnabled(exclusive);
        if (this.refreshing) {
            return;
        }
        DefaultGameConfig config = this.getGameConfig();
        if (config == null) {
            return;
        }
        if (window) {
            config.setProperty("surface", "window");
        } else if (exclusive) {
            config.setProperty("surface", "exclusive");
        } else {
            config.setProperty("surface", "fullscreen");
        }
    }

    protected void handleDisplayDeviceChanged() {
        GraphicsDevice device = this.displayDevicePropertyEditor.getDisplayDevice();
        if (device != null) {
            this.getDisplayModePropertyEditor().setDevice(device);
        }
        if (this.refreshing) {
            return;
        }
        DefaultGameConfig config = this.getGameConfig();
        if (config == null) {
            return;
        }
        String devId = this.displayDevicePropertyEditor.getAsText();
        config.setProperty("displayDevice", devId);
    }
}

