/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.util;

import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.MultiRectShape;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class CollisionBoundsAnalyzer {
    protected void addRectangle(List rects, Rectangle r) {
        int count = rects.size();
        for (int c = 0; c < count; ++c) {
            Rectangle rect = (Rectangle)rects.get(c);
            if (rect.contains(r)) {
                return;
            }
            if (!r.contains(rect)) continue;
            rects.remove(c--);
            --count;
        }
        rects.add(r);
    }

    protected Rectangle getRectangle(List rects, int x, int y) {
        int count = rects.size();
        for (int c = 0; c < count; ++c) {
            if (!((Rectangle)rects.get(c)).contains(x, y)) continue;
            return (Rectangle)rects.get(c);
        }
        return null;
    }

    public void dumpCollisionRaster(CollisionRaster raster, List rects, PrintStream out) {
        int cols = raster.getColumns();
        int rows = raster.getRows();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                Rectangle r = this.getRectangle(rects, x, y);
                if (raster.get(x, y)) {
                    if (r == null) {
                        System.out.print("+");
                        continue;
                    }
                    System.out.print("" + (char)(65 + rects.indexOf(r)));
                    continue;
                }
                if (r == null) {
                    System.out.print(":");
                    continue;
                }
                System.out.print("/");
            }
            System.out.println();
        }
    }

    public CollisionRaster createCollisionRaster(Image image, int gridWidth, int gridHeight) throws Exception {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        PixelGrabber pg = new PixelGrabber(image, 0, 0, imageWidth, imageHeight, false);
        pg.grabPixels();
        IndexColorModel colorModel = (IndexColorModel)pg.getColorModel();
        int trans = colorModel.getTransparentPixel();
        if (trans == -1) {
            // empty if block
        }
        byte bTrans = (byte)trans;
        byte[] pix = (byte[])pg.getPixels();
        int cols = 1 + (image.getWidth(null) - 1) / gridWidth;
        int rows = 1 + (image.getHeight(null) - 1) / gridHeight;
        CollisionRaster raster = new CollisionRaster(cols, rows, gridWidth, gridHeight);
        int midX = 0;
        int o = 0;
        int y = 0;
        for (int r = 0; r < rows; ++r) {
            o = y * imageWidth + midX;
            for (int c = 0; c < cols; ++c) {
                raster.set(c, r, pix[o] != bTrans);
                o += gridWidth;
            }
            y += gridHeight;
        }
        return raster;
    }

    public void createCollisionRasterBounds(CollisionRaster raster, List dstRectangles) throws Exception {
        LinkedList rects = new LinkedList();
        this.computeCollisionRasterBounds(raster, rects);
        this.sortRectangles(rects);
        dstRectangles.addAll(rects);
    }

    protected void computeCollisionRasterBounds(CollisionRaster raster, List rects) {
        int cols = raster.getColumns();
        int rows = raster.getRows();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                int m;
                int k;
                Rectangle r;
                if (!raster.get(x, y) || (r = this.getRectangle(rects, x, y)) != null) continue;
                for (k = x + 1; k < cols && raster.get(k, y); ++k) {
                }
                int xSize = k - x;
                for (m = y + 1; m < rows; ++m) {
                    int n;
                    for (n = x; n < k && raster.get(n, m); ++n) {
                    }
                    if (n < k) break;
                }
                int ySize = m - y;
                this.addRectangle(rects, new Rectangle(x, y, xSize, ySize));
                x = k - 1;
            }
        }
    }

    protected void sortRectangles(List rects) {
        int count = rects.size();
        MultiRectShape shape = new MultiRectShape();
        LinkedList sorted = new LinkedList();
        int loops = count;
        for (int c = 0; c < loops; ++c) {
            int bestSize = -1;
            int bestIndex = -1;
            for (int i = 0; i < count; ++i) {
                Rectangle r = (Rectangle)rects.get(i);
                shape.clear();
                shape.add(r);
                int num = sorted.size();
                for (int j = 0; j < num; ++j) {
                    shape.remove((Rectangle)sorted.get(j));
                }
                int currSize = shape.getSurface();
                if (currSize <= bestSize) continue;
                bestIndex = i;
                bestSize = currSize;
            }
            sorted.add(rects.remove(bestIndex));
            --count;
        }
        rects.clear();
        rects.addAll(sorted);
    }

    public CollisionBounds createCollisionBounds(CollisionRaster rasta, List rastaBounds) {
        int gridWidth = rasta.getGridWidth();
        int gridHeight = rasta.getGridHeight();
        Rectangle[] rects = new Rectangle[rastaBounds.size()];
        for (int c = 0; c < rects.length; ++c) {
            Rectangle r = (Rectangle)rastaBounds.get(c);
            rects[c] = new Rectangle(r.x * gridWidth, r.y * gridHeight, r.width * gridWidth, r.height * gridHeight);
        }
        return new CollisionBounds(rects);
    }

    public class CollisionRaster {
        private boolean[] data;
        private int columns;
        private int rows;
        private int gridWidth;
        private int gridHeight;

        public CollisionRaster(int columns, int rows, int gridWidth, int gridHeight) {
            this.columns = columns;
            this.rows = rows;
            this.data = new boolean[columns * rows];
            this.gridWidth = gridWidth;
            this.gridHeight = gridHeight;
        }

        public boolean get(int x, int y) {
            return this.data[y * this.columns + x];
        }

        public void set(int x, int y, boolean v) {
            this.data[y * this.columns + x] = v;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        public int getGridHeight() {
            return this.gridHeight;
        }

        public int getGridWidth() {
            return this.gridWidth;
        }
    }
}

