/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.game2d.util;

import com.spacekiller.game2d.Animation;
import com.spacekiller.game2d.AnimationImage;
import com.spacekiller.game2d.CollisionBounds;
import com.spacekiller.game2d.util.AnimatedGifEncoder;
import com.spacekiller.game2d.util.CollisionBoundsAnalyzer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImageToolkit {
    private static final Logger logger = Logger.getLogger(ImageToolkit.class.getName());
    private static ImageToolkit INSTANCE = null;
    private MediaTracker mediaTracker;
    private int collisionRasterWidth = 4;
    private int collisionRasterHeight = 4;
    private int maxCollisionRects = 10;

    protected ImageToolkit() {
        this(null);
    }

    public ImageToolkit(MediaTracker mediaTracker) {
        if (mediaTracker == null) {
            mediaTracker = new MediaTracker(new JPanel());
        }
        this.setMediaTracker(mediaTracker);
    }

    public static ImageToolkit getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImageToolkit();
        }
        return INSTANCE;
    }

    protected MediaTracker getMediaTracker() {
        return this.mediaTracker;
    }

    protected void setMediaTracker(MediaTracker mediaTracker) {
        this.mediaTracker = mediaTracker;
    }

    public Image createImage(URL url) throws Exception {
        Image image1 = new ImageIcon(url).getImage();
        if (image1 == null) {
            throw new Exception("Could not load image: " + url);
        }
        int imageWidth = image1.getWidth(null);
        int imageHeight = image1.getHeight(null);
        if (imageWidth < 0 || imageHeight < 0) {
            throw new Exception("Unable to load image: " + url);
        }
        return image1;
    }

    public ColorModel getColorModel(Image image) throws Exception {
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        pg.grabPixels();
        return pg.getColorModel();
    }

    public Cursor createInvisibleCursor() throws Exception {
        String name = "Invisible Cursor";
        Point hotSpot = new Point(0, 0);
        BufferedImage cursorImage = new BufferedImage(1, 1, 2);
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, hotSpot, name);
        return cursor;
    }

    public void reorder1(byte[] b, int ofs, int len, byte[] m) {
        int kl = m.length;
        byte l = 0;
        for (int c = 0; c < len; ++c) {
            int k = c % kl;
            l = (byte)(l ^ m[k]);
            m[k] = (byte)(l ^ b[ofs + c]);
            int n = ofs + c;
            b[n] = (byte)(b[n] ^ l);
        }
    }

    public void reorder2(byte[] b, int ofs, int len, byte[] m) {
        int kl = m.length;
        byte l = 0;
        for (int c = 0; c < len; ++c) {
            int k = c % kl;
            l = (byte)(l ^ m[k]);
            int n = ofs + c;
            b[n] = (byte)(b[n] ^ l);
            m[k] = (byte)(l ^ b[ofs + c]);
        }
    }

    public void writeGifImage(BufferedImage image, Color transColor, OutputStream out) throws IOException {
        AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        encoder.start(out);
        encoder.setTransparent(transColor);
        encoder.addFrame(image);
        encoder.finish();
    }

    public BufferedImage transformImage(Image image, ImageObserver observer, Color background, double scaleFactorX, double scaleFactorY, double rotateTheta) {
        int swap;
        int sourceX = 0;
        int sourceY = 0;
        int sourceWidth = image.getWidth(observer);
        int sourceHeight = image.getHeight(observer);
        double scaledWidth = Math.abs((double)sourceWidth * scaleFactorX);
        double scaledHeight = Math.abs((double)sourceHeight * scaleFactorY);
        double sinAbs = Math.abs(Math.sin(rotateTheta));
        double cosAbs = Math.abs(Math.cos(rotateTheta));
        double rotatedWidth = scaledWidth * cosAbs + scaledHeight * sinAbs;
        double rotatedHeight = scaledHeight * cosAbs + scaledWidth * sinAbs;
        int targetWidth = (int)Math.ceil(rotatedWidth);
        int targetHeight = (int)Math.ceil(rotatedHeight);
        BufferedImage bi = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D bg = bi.createGraphics();
        if (background != null) {
            bg.setColor(background);
            bg.fillRect(0, 0, targetWidth, targetHeight);
        }
        bg.translate(((double)targetWidth - scaledWidth) / 2.0, ((double)targetHeight - scaledHeight) / 2.0);
        bg.rotate(rotateTheta, scaledWidth / 2.0, scaledHeight / 2.0);
        int sx1 = sourceX;
        int sy1 = sourceY;
        int sx2 = sourceWidth;
        int sy2 = sourceHeight;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = (int)Math.floor(scaledWidth);
        int dy2 = (int)Math.floor(scaledHeight);
        if (scaleFactorX < 0.0) {
            swap = dx1;
            dx1 = dx2;
            dx2 = swap;
        }
        if (scaleFactorY < 0.0) {
            swap = dy1;
            dy1 = dy2;
            dy2 = swap;
        }
        bg.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        bg.dispose();
        return bi;
    }

    public Image createRotatedImage(Image image, double theta) throws Exception {
        if (image == null) {
            throw new NullPointerException("image is null");
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage src = null;
        if (image instanceof BufferedImage) {
            src = (BufferedImage)image;
        } else {
            ColorModel cm = ImageToolkit.getInstance().getColorModel(image);
            WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
            IndexColorModel icm = (IndexColorModel)cm;
            int trans = icm.getTransparentPixel();
            int[] pix = new int[width];
            Arrays.fill(pix, trans);
            for (int y = 0; y < height; ++y) {
                wr.setPixels(0, y, width, 1, pix);
            }
            src = new BufferedImage(cm, wr, false, null);
            Graphics2D g = src.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        HashMap hints = new HashMap();
        RenderingHints rh = new RenderingHints(hints);
        double cx = (double)width / 2.0;
        double cy = (double)height / 2.0;
        AffineTransform aff = AffineTransform.getRotateInstance(theta, cx, cy);
        AffineTransformOp op = new AffineTransformOp(aff, rh);
        BufferedImage rotated = op.filter(src, null);
        return rotated;
    }

    public Image createScaledImage(Image image, int width, int height, int hints) throws Exception {
        Image newImage = image.getScaledInstance(width, height, hints);
        MediaTracker tracker = this.getMediaTracker();
        tracker.addImage(newImage, 1);
        tracker.waitForID(1);
        tracker.removeImage(newImage, 1);
        return newImage;
    }

    public Animation createScaledAnimation(Animation ani, int width, int height, int hints) throws Exception {
        int count = ani.getAnimationImageCount();
        int oldWidth = ani.getWidth();
        int oldHeight = ani.getHeight();
        if (oldWidth == width && oldHeight == height) {
            return ani;
        }
        double scaleX = (double)width / (double)oldWidth;
        double scaleY = (double)height / (double)oldHeight;
        Animation rc = new Animation();
        rc.setWidth(width);
        rc.setHeight(height);
        ImageToolkit imageToolkit = ImageToolkit.getInstance();
        for (int c = 0; c < count; ++c) {
            AnimationImage aniImage = ani.getAnimationImageAt(c);
            if (aniImage == null) continue;
            Image oldImage = aniImage.getImage();
            int newImageX = (int)((double)aniImage.getX() * scaleX);
            int newImageY = (int)((double)aniImage.getY() * scaleY);
            int newImageWidth = (int)((double)oldImage.getWidth(null) * scaleX);
            int newImageHeight = (int)((double)oldImage.getHeight(null) * scaleY);
            Image newImage = imageToolkit.createScaledImage(oldImage, newImageWidth, newImageHeight, hints);
            rc.addAnimationImage(new AnimationImage(newImage, newImageX, newImageY, aniImage.getTime()));
        }
        return rc;
    }

    public CollisionBounds createCollisionBounds(Image image1) throws Exception {
        return this.createCollisionBounds(image1, this.collisionRasterWidth, this.collisionRasterHeight, this.maxCollisionRects);
    }

    public CollisionBounds createCollisionBounds(Image image1, int collisionRasterWidth, int collisionRasterHeight, int maxCollisionRects) throws Exception {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Analyzing image: " + image1 + " / " + image1.getSource());
            }
            CollisionBoundsAnalyzer analyzer = new CollisionBoundsAnalyzer();
            CollisionBoundsAnalyzer.CollisionRaster rasta = analyzer.createCollisionRaster(image1, collisionRasterWidth, collisionRasterHeight);
            ArrayList rastaBounds = new ArrayList();
            analyzer.createCollisionRasterBounds(rasta, rastaBounds);
            if (rastaBounds.size() > maxCollisionRects) {
                int delCount = rastaBounds.size() - maxCollisionRects;
                for (int c = 0; c < delCount; ++c) {
                    rastaBounds.remove(maxCollisionRects);
                }
            }
            CollisionBounds bounds = analyzer.createCollisionBounds(rasta, rastaBounds);
            return bounds;
        }
        catch (ClassCastException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("!! ERROR while analyzing image: " + image1 + " / " + image1.getSource());
            }
            logger.log(Level.SEVERE, e.getMessage(), e);
            int width = image1.getWidth(null);
            int height = image1.getHeight(null);
            Rectangle rect = new Rectangle(0, 0, width, height);
            CollisionBounds bounds = new CollisionBounds(rect, new Rectangle[]{rect});
            return bounds;
        }
    }
}

