/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class Debug {
    private static double javaVersion = -1.0;
    private static ArrayList debugRefs = new ArrayList();
    private static ReferenceQueue debugRefQueue = null;

    private Debug() {
    }

    static void debugReference(Object obj) {
        if (obj == null) {
            return;
        }
        if (debugRefQueue == null) {
            debugRefQueue = new ReferenceQueue();
            new Thread(new DebugRefHandler()).start();
        }
        debugRefs.add(new DebugRef(obj, debugRefQueue));
    }

    static Iterator getDebugReferences() {
        return debugRefs.iterator();
    }

    static void clearDebugReferences() {
        debugRefs = new ArrayList();
    }

    static void dumpDebugReferences(PrintStream out) {
        int num = debugRefs.size();
        out.println("----------------------------------------");
        out.println("Dump debug references: " + num);
        System.gc();
        int objs = 0;
        for (int i = 0; i < num; ++i) {
            Reference ref = (Reference)debugRefs.get(i);
            Object obj = ref.get();
            if (obj == null) {
                out.println("Garbage: " + ref);
                continue;
            }
            ++objs;
            String hexHash = Integer.toHexString(System.identityHashCode(obj));
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable e) {
                toString = "" + e;
            }
            out.println("Reference: " + obj.getClass().getName() + "@" + hexHash + " = " + toString);
        }
        out.println("Referenced objects: " + objs + " / " + num);
        out.println("----------------------------------------");
    }

    static void dumpThreads(PrintStream out) {
        int n;
        Method methGetStackTrace = null;
        try {
            methGetStackTrace = Thread.class.getMethod("getStackTrace", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        out.println("--------- Threads ---------");
        Thread currThread = Thread.currentThread();
        out.println("Thread: " + currThread);
        ThreadGroup group = currThread.getThreadGroup();
        out.println("ThreadGroup: " + group);
        Thread[] threads = new Thread[group.activeCount() + 2];
        int numThreads = 0;
        while ((n = group.enumerate(threads, true)) >= threads.length) {
            threads = new Thread[threads.length * 2];
        }
        numThreads = n;
        out.println("Number of threads: " + numThreads);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            if (thread == null) continue;
            if (methGetStackTrace == null) {
                out.println("Thread #" + i + " = " + thread);
                continue;
            }
            out.println("Thread #" + i + " = " + thread);
            try {
                StackTraceElement[] trace = (StackTraceElement[])methGetStackTrace.invoke((Object)thread, new Object[0]);
                if (trace == null) continue;
                for (int j = 0; j < trace.length; ++j) {
                    out.println("  at " + trace[j]);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
        }
    }

    static void dumpShutdownHooks(PrintStream out) {
        try {
            Class<?> classShutdown = Class.forName("java.lang.Shutdown");
            Field fieldHooks = classShutdown.getDeclaredField("hooks");
            fieldHooks.setAccessible(true);
            Collection hooks = (Collection)fieldHooks.get(null);
            out.println("--------- Shutdown hooks ---------");
            out.println("Number of shutdown hooks: " + hooks.size());
            Iterator i = hooks.iterator();
            while (i.hasNext()) {
                out.println(" - " + i.next());
            }
        }
        catch (Throwable e) {
            out.println("Shutdown hooks: <unknown> => " + e);
        }
    }

    static void dumpMemoryUsage(PrintStream out) {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        out.println("Memory: used=" + used + ", free=" + free + ", total=" + total + ", max=" + max);
    }

    static String getOperatingSystemInfoString() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            osName = "<unknown>";
        }
        String osVersion = System.getProperty("os.version");
        String osPatch = System.getProperty("sun.os.patch.level");
        String osArch = System.getProperty("os.arch");
        String osInfo = "";
        if (osVersion != null) {
            osInfo = osInfo + osVersion;
        }
        if (osPatch != null) {
            if (osInfo.length() > 0) {
                osInfo = osInfo + ", ";
            }
            osInfo = osInfo + osPatch;
        }
        if (osArch != null) {
            if (osInfo.length() > 0) {
                osInfo = osInfo + ", ";
            }
            osInfo = osInfo + osArch;
        }
        osInfo = osInfo.length() == 0 ? osName : osName + " (" + osInfo + ")";
        return osInfo;
    }

    static String getJavaVersionInfoString() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            javaVersion = "<unknown>";
        }
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String vmVendor = System.getProperty("java.vm.vendor");
        String javaInfo = "";
        if (vmName != null) {
            javaInfo = javaInfo + vmName;
        }
        if (vmVersion != null) {
            if (javaInfo.length() > 0) {
                javaInfo = javaInfo + " ";
            }
            javaInfo = javaInfo + vmVersion;
        }
        if (vmVendor != null) {
            if (javaInfo.length() > 0) {
                javaInfo = javaInfo + ", ";
            }
            javaInfo = javaInfo + vmVendor;
        }
        javaInfo = javaInfo.length() == 0 ? javaVersion : javaVersion + " (" + javaInfo + ")";
        return javaInfo;
    }

    static String getTimeString(long millis) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(millis));
    }

    public static double getJavaVersion() {
        if (javaVersion < 0.0) {
            try {
                String strVersion = System.getProperty("java.version");
                if (strVersion != null) {
                    String NUM_CHARS = "0123456789";
                    boolean dotDone = false;
                    StringBuffer sb = new StringBuffer();
                    int strLen = strVersion.length();
                    for (int i = 0; i < strLen; ++i) {
                        char ch = strVersion.charAt(i);
                        if (NUM_CHARS.indexOf(ch) >= 0) {
                            sb.append(ch);
                            continue;
                        }
                        if (ch != '.' || dotDone) continue;
                        sb.append(ch);
                        dotDone = true;
                    }
                    strVersion = sb.toString();
                }
                javaVersion = Double.parseDouble(strVersion);
            }
            catch (Exception e) {
                e.printStackTrace();
                javaVersion = 0.0;
            }
        }
        return javaVersion;
    }

    protected static class DebugRefHandler
    implements Runnable {
        protected DebugRefHandler() {
        }

        @Override
        public void run() {
            while (debugRefQueue != null) {
                try {
                    Reference ref = debugRefQueue.remove();
                    if (ref == null) continue;
                    PrintStream out = System.out;
                    out.println("DEBUG: Reference removed: " + ref);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected static class DebugRef
    extends WeakReference {
        private String name;

        public DebugRef(Object obj, ReferenceQueue arg1) {
            super(obj, arg1);
            this.name = obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
        }

        public String toString() {
            return "DebugRef[" + this.name + "]";
        }
    }
}

