/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.Debug;
import com.spacekiller.infection.InfectionAccess;
import com.spacekiller.infection.InfectionAccessImpl;
import com.spacekiller.infection.InfectionEnhancement;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.InfectionRuntimeFacade;
import com.spacekiller.infection.InfectionRuntimeImpl;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.InfectionUtilWin32;
import com.spacekiller.infection.JavaProcess;
import com.spacekiller.infection.SealedLogger;
import com.spacekiller.infection.StartupProgressBar;
import com.spacekiller.infection.log.InfectionLogFormatter;
import com.spacekiller.infection.log.InfectionLogHandler;
import com.spacekiller.infection.log.Log2ConsoleHandler;
import com.spacekiller.infection.log.Log2FileAsyncHandler;
import com.spacekiller.infection.log.Log2FileHandler;
import com.spacekiller.infection.log.Log2TraceHandler;
import com.spacekiller.infection.log.LogFileOptions;
import com.spacekiller.infection.log.LogFileStream;
import com.spacekiller.infection.log.LogFormatter;
import com.spacekiller.infection.log.LogStream;
import com.spacekiller.infection.log.LoggedStream;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.old.InfectionLegacySupport;
import com.spacekiller.infection.swing.InfectionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;

public final class Infection {
    private static final String DEV_VERSION = "Infection-2020-03-09";
    private static final String DEBUG_LOG_FILENAME = "debug.log";
    private static final String UNKNOWN = "<unknown>";
    public static final String ARG_INFECTION_INSTANCE = "instance";
    public static final String ARG_OPT_VERSION = "-version";
    public static final String ARG_OPT_DEBUG = "-debug";
    public static final String ARG_OPT_NO_EXIT = "-noexit";
    public static final String ARG_OPT_NO_UPDATE = "-noupdate";
    public static final String ARG_OPT_NO_SPLASH = "-nosplash";
    public static final String ARG_OPT_NO_VERIFY = "-noverify";
    public static final String ARG_OPT_SHELL = "-shell";
    public static final String ARG_OPT_COMMAND = "-command";
    public static final String ARG_OPT_INSTANCE = "-instance";
    private static PrintStream originalSystemOut = System.out;
    private static PrintStream originalSystemErr = System.err;
    private static Infection instance;
    private static boolean exitEnabled;
    private static boolean autoSoftwareUpdateEnabled;
    private static boolean verifyInfectionVersionEnabled;
    private static boolean debug;
    private static ArrayList errors;
    private static Object initWindow;
    private static Object initProgress;
    private static Object logger;
    private String infectionTitle;
    private String infectionVersion;
    private ClassLoader mainClassLoader;
    private String mainClassPath;
    private boolean dialogOpen = false;
    private Object dialogWindow;
    private boolean restarting = false;
    private String mminfectionURL;
    private File logDir;
    private boolean loggingInit;
    private InfectionLogHandler logHandler;
    private List globalHandlers;
    private List customHandlers;
    private SealedLogger sysOutLogger;
    private SealedLogger sysErrLogger;
    private LogFileStream log2FileStream;
    private LogFileStream log2TraceStream;
    private Map runtimes;
    private int highestExitCode = 0;
    private Thread exitThread;
    private boolean exiting;
    private Runnable replaceStartupOnExit;
    private Properties distProperties;
    private ZipFile distZipFile;
    private URL distZipURL;
    private String appName;
    private String appTitle;
    private Object xmlValidatorV1;
    private boolean xmlValidatorV1checked;
    private boolean disableURLCaches = true;

    private Infection() throws Exception {
        if (instance != null) {
            throw new Exception("Infection instance already initialized!");
        }
    }

    private static void debugMain(String message) {
        originalSystemOut.println("Infection [MAIN] " + message);
    }

    public static void debugLegacy(String message) {
        originalSystemOut.println("Infection [LEGACY] " + message);
    }

    private static void debugDumpLoggers(LogManager logManager) {
        Enumeration<String> en = logManager.getLoggerNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            Logger logger = logManager.getLogger(name);
            if (logger == null) continue;
            Level level = logger.getLevel();
            Handler[] handlers = logger.getHandlers();
            if (level == null && (handlers == null || handlers.length < 1)) continue;
            Infection.debugDumpLogger(name, logger);
        }
    }

    private static void debugDumpLogger(String name, Logger logger) {
        int num;
        Level level = logger.getLevel();
        Handler[] handlers = logger.getHandlers();
        String loggerInfo = name.length() < 1 ? "<default>" : name;
        loggerInfo = loggerInfo + " (level=" + level;
        if (handlers != null && (num = handlers.length) > 0) {
            loggerInfo = loggerInfo + ", handlers={";
            for (int i = 0; i < num; ++i) {
                if (i > 0) {
                    loggerInfo = loggerInfo + ", ";
                }
                loggerInfo = loggerInfo + handlers[i].toString();
            }
            loggerInfo = loggerInfo + "}";
        }
        loggerInfo = loggerInfo + ")";
        Infection.debugMain("Logger: " + loggerInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        if (instance != null) {
            return true;
        }
        Class<Infection> clazz = Infection.class;
        synchronized (Infection.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Infection getInstance() throws Exception {
        if (instance != null) return instance;
        Class<Infection> clazz = Infection.class;
        synchronized (Infection.class) {
            PrivilegedAction action;
            Object error;
            if (instance != null || (error = AccessController.doPrivileged(action = new PrivilegedAction(){

                public Object run() {
                    try {
                        instance = new Infection();
                        return null;
                    }
                    catch (Throwable e) {
                        Infection.handleException(e);
                        return e;
                    }
                }
            })) == null) return instance;
            throw new RuntimeException("" + error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Class<Infection> clazz = Infection.class;
        synchronized (Infection.class) {
            if (Infection.isInitialized()) {
                throw new SecurityException("Infection is already initialized!");
            }
            AccessController.doPrivileged(new Main(args));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void mainPrivileged(String[] args) throws Throwable {
        Infection.getInstance().start(args);
    }

    private void start(String[] args) throws Throwable {
        File logDir;
        File configDir;
        String indexPath;
        String classPath;
        Properties distProps;
        boolean showSplash = !Infection.isHeadless();
        boolean cliMode = false;
        String[] cliParams = null;
        boolean openShell = false;
        Properties properties = new Properties();
        if (args != null) {
            for (int c = 0; c < args.length; ++c) {
                String arg = args[c];
                if (arg.equals(ARG_OPT_VERSION)) {
                    showSplash = false;
                    cliMode = true;
                    openShell = false;
                    cliParams = new String[]{"version"};
                    break;
                }
                if (arg.equals(ARG_OPT_DEBUG)) {
                    debug = true;
                    continue;
                }
                if (arg.equals(ARG_OPT_NO_EXIT)) {
                    exitEnabled = false;
                    continue;
                }
                if (arg.equals(ARG_OPT_NO_UPDATE)) {
                    autoSoftwareUpdateEnabled = false;
                    continue;
                }
                if (arg.equals(ARG_OPT_NO_SPLASH)) {
                    showSplash = false;
                    continue;
                }
                if (arg.equals(ARG_OPT_NO_VERIFY)) {
                    verifyInfectionVersionEnabled = false;
                    continue;
                }
                if (arg.equals(ARG_OPT_SHELL)) {
                    showSplash = false;
                    cliMode = true;
                    openShell = true;
                    continue;
                }
                if (arg.equals(ARG_OPT_COMMAND)) {
                    showSplash = false;
                    cliMode = true;
                    cliParams = new String[args.length - c - 1];
                    System.arraycopy(args, c + 1, cliParams, 0, cliParams.length);
                    break;
                }
                if (!arg.startsWith("-")) continue;
                int x = arg.indexOf("=");
                String key = null;
                String value = null;
                if (x < 0) {
                    key = arg.substring(1);
                    value = "";
                } else {
                    key = arg.substring(1, x);
                    value = arg.substring(x + 1);
                }
                key = key.trim();
                properties.setProperty(key, value);
            }
        }
        try {
            Package pack = this.getClass().getPackage();
            if (pack != null) {
                String title = pack.getImplementationTitle();
                String version = pack.getImplementationVersion();
                if (title != null && version != null) {
                    this.infectionTitle = title;
                    this.infectionVersion = version;
                } else {
                    if (title == null) {
                        title = DEV_VERSION;
                    }
                    this.infectionTitle = title;
                    this.infectionVersion = null;
                }
            }
        }
        catch (Throwable e) {
            Infection.handleException(e);
        }
        String infectionInfo = UNKNOWN;
        if (this.infectionTitle != null) {
            infectionInfo = "" + this.infectionTitle + " " + this.infectionVersion;
        }
        String javaVersionInfo = Debug.getJavaVersionInfoString();
        String osVersionInfo = Debug.getOperatingSystemInfoString();
        if (debug) {
            Infection.debugMain("Current time: " + Debug.getTimeString(System.currentTimeMillis()));
            Infection.debugMain("Infection version: " + infectionInfo);
            Infection.debugMain("Java version: " + javaVersionInfo);
            Infection.debugMain("Operating system: " + osVersionInfo);
        }
        this.distProperties = distProps = this.loadDistributionProperties();
        this.appName = distProps.getProperty("name");
        if (this.appName == null) {
            throw new Error("Missing distribution property: name");
        }
        this.appTitle = distProps.getProperty("title");
        if (this.appTitle == null) {
            this.appTitle = this.appName;
        }
        if (showSplash) {
            try {
                Image image = this.getDistributionResourceImage("splash");
                if (image != null) {
                    ImageIcon splashIcon = new ImageIcon(image);
                    initWindow = Infection.showSplashWindow(splashIcon);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.exitThread = new Thread(new Exit());
        this.runtimes = new HashMap();
        File instanceFile = null;
        boolean devSupport = false;
        String argInstance = (String)properties.remove(ARG_INFECTION_INSTANCE);
        if (argInstance != null) {
            instanceFile = new File(argInstance);
            instanceFile = instanceFile.getAbsoluteFile();
        }
        try {
            CodeSource code;
            ProtectionDomain domain = this.getClass().getProtectionDomain();
            if (domain != null && (code = domain.getCodeSource()) != null) {
                this.mminfectionURL = "" + code.getLocation();
                if (debug) {
                    Infection.debugMain("Infection source: " + this.mminfectionURL);
                }
            }
        }
        catch (Throwable e) {
            Infection.handleException(e);
        }
        HashMap runtimeProperties = new HashMap();
        ClassLoader mainLoader = this.getClass().getClassLoader();
        this.setMainClassLoader(mainLoader);
        if (debug) {
            Infection.debugMain("Class loader: " + mainLoader);
            Infection.debugMain("Context loader: " + Thread.currentThread().getContextClassLoader());
        }
        if ((classPath = System.getProperty("java.class.path")) == null) {
            classPath = "";
        }
        if (debug) {
            Infection.debugMain("Class path: " + classPath);
        }
        StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator, false);
        HashSet<String> cpEntries = new HashSet<String>();
        StringBuffer cpBuf = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (!cpEntries.add(s)) continue;
            if (cpBuf.length() > 0) {
                cpBuf.append(File.pathSeparator);
            }
            cpBuf.append(s);
        }
        classPath = cpBuf.toString();
        this.setMainClassPath(classPath);
        if (instanceFile == null) {
            instanceFile = new File("instance.xml");
            instanceFile = instanceFile.getAbsoluteFile();
        }
        boolean instanceFileExists = instanceFile.exists();
        if (debug) {
            Infection.debugMain("Instance file: " + instanceFile + " (exists=" + instanceFileExists + ")");
        }
        File indexFile = null;
        InfectionInstance instance = this.loadInfectionInstance(instanceFile);
        if (instanceFileExists && (indexPath = instance.getIndexPath()) != null) {
            InfectionLegacySupport infectionLegacy;
            File newIndexFile;
            File indexFileParentDir;
            InfectionLegacySupport infectionLegacy2;
            File newIndexFile2;
            if (debug) {
                Infection.debugMain("Infection index path: " + indexPath);
            }
            indexFile = new File(indexPath);
            if ("infection.xml".equals((indexFile = InfectionUtil.getAbsoluteFile(indexFile, instanceFile.getParentFile())).getName()) && (newIndexFile2 = (infectionLegacy2 = new InfectionLegacySupport()).migrateLegacyInstanceV1(instance, indexFile)) != null) {
                indexFile = newIndexFile2;
                indexPath = indexFile.getPath();
            }
            if ((indexFileParentDir = indexFile.getParentFile()) != null && ".infection".equals(indexFileParentDir.getName()) && (newIndexFile = (infectionLegacy = new InfectionLegacySupport()).migrateLegacyInstanceV2(instance, indexFile)) != null) {
                indexFile = newIndexFile;
                indexPath = indexFile.getPath();
            }
        }
        if (indexFile == null) {
            File indexDir = new File(".artifacts");
            indexFile = new File(indexDir, "index.xml");
            if (debug) {
                Infection.debugMain("Index file not specified: Using default: " + indexFile);
            }
        }
        if (debug) {
            Infection.debugMain("Using index file: " + indexFile);
        }
        File file = configDir = instance == null ? null : instance.getConfigDir();
        if (configDir == null) {
            configDir = new File(".");
        }
        File file2 = logDir = instance == null ? null : instance.getLogDir();
        if (logDir == null) {
            logDir = new File(".");
        }
        this.logDir = logDir;
        if (debug) {
            Infection.debugMain("Config directory: " + configDir);
            Infection.debugMain("Log directory: " + logDir);
        }
        if (debug) {
            try {
                Infection.debugMain("Security manager: " + System.getSecurityManager());
                Infection.debugMain("Security policy:  " + Policy.getPolicy());
            }
            catch (Throwable e) {
                Infection.handleException(e);
            }
        }
        InfectionUtil.class.getName();
        InfectionUtil.InstanceUpdate.class.getName();
        InfectionUtilWin32.class.getName();
        Debug.class.getName();
        ErrorDialog.class.getName();
        JavaProcess.class.getName();
        JavaProcess.ProcessReader.class.getName();
        ProcessOutputHandler.class.getName();
        InfectionIndex index = this.loadInfectionIndex(indexFile);
        File indexDir = indexFile.getParentFile();
        InfectionInstallation installation = new InfectionInstallation(indexDir, indexFile);
        installation.setIndex(index);
        installation.setIndexFile(indexFile);
        if (!instanceFileExists) {
            if (debug) {
                Infection.debugMain("Instance config file not found: " + instanceFile);
            }
            boolean launchInstaller = true;
            if (devSupport) {
                launchInstaller = false;
            }
            if (cliMode) {
                launchInstaller = false;
            }
            if (launchInstaller) {
                InfectionRuntimeImpl rt;
                File workDir = new File(".");
                workDir = workDir.getAbsoluteFile();
                if (debug) {
                    Infection.debugMain("workDir=" + workDir);
                    Infection.debugMain("indexDir=" + indexDir);
                    Infection.debugMain("indexFile=" + indexFile);
                    Infection.debugMain("installation=" + installation);
                }
                if (!this.installPlatform(rt = new InfectionRuntimeImpl(this, indexFile, installation, index, instance, workDir, args, runtimeProperties), 100)) {
                    this.exit(0);
                } else {
                    this.exit(0);
                }
                return;
            }
        }
        try {
            if (!configDir.exists() && !configDir.mkdirs()) {
                Infection.debugMain("Failed to create config directory: " + configDir.getAbsolutePath());
            }
            File loggingPropFile = new File(configDir, "logging.properties");
            this.startLogging(loggingPropFile);
        }
        catch (Throwable e) {
            Infection.handleException(e);
        }
        if (cliMode) {
            int exitCode = this.shell(installation, index, instance, cliParams, openShell);
            this.exit(exitCode);
            return;
        }
        Logger log = Infection.getLogger();
        boolean info = log.isLoggable(Level.INFO);
        boolean config = log.isLoggable(Level.CONFIG);
        boolean fine = log.isLoggable(Level.FINE);
        if (info) {
            log.info("Infection version: " + infectionInfo);
            if (fine) {
                log.fine("Infection source: " + this.mminfectionURL);
            }
            log.info("Java runtime: " + javaVersionInfo);
            log.info("Operating system: " + osVersionInfo);
            if (fine) {
                Runtime runtime = Runtime.getRuntime();
                log.fine("Memory: max=" + runtime.maxMemory());
            }
        }
        if (info) {
            int numArgs;
            int n = numArgs = args == null ? 0 : args.length;
            if (fine) {
                log.fine("Main argument count: " + numArgs);
                for (int i = 0; i < numArgs; ++i) {
                    log.fine("Argument: " + args[i]);
                }
            }
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < numArgs; ++i) {
                if (i > 0) {
                    sbuf.append(" ");
                }
                sbuf.append(String.valueOf(args[i]));
            }
            log.info("Main arguments: " + sbuf.toString());
        }
        if (config) {
            log.config("Infection index: " + indexFile);
        }
        if (config) {
            log.config("=========== System Properties ===========");
            try {
                Infection.printSystemProperties(log);
            }
            catch (Throwable e) {
                String msg = "Error while getting system properties";
                log.log(Level.WARNING, msg, e);
                try {
                    log.config("Trying to get default properties..");
                    this.logSystemProperties(log);
                }
                catch (Throwable e2) {
                    log.log(Level.WARNING, msg, e2);
                }
            }
            log.config("=========================================");
        }
        File workDir = instance.getInstanceFile().getParentFile();
        try {
            if (fine) {
                log.fine("Work directory:    " + workDir);
                log.fine("Data directory:    " + instance.getDataDir());
                log.fine("Config directory:  " + instance.getConfigDir());
                log.fine("Log directory:     " + instance.getLogDir());
            }
        }
        catch (Throwable e) {
            String msg = "Unable to set current working directory: " + workDir;
            log.log(Level.WARNING, msg, e);
        }
        if (!devSupport && this.infectionVersion != null && verifyInfectionVersionEnabled) {
            String artifactName = "mminfection";
            int num = instance.getArtifactCount();
            boolean needReplace = true;
            Artifact fact = null;
            for (int i = 0; i < num; ++i) {
                Artifact art = instance.getArtifactAt(i);
                if (!artifactName.equals(art.getName())) continue;
                fact = art;
                if (!this.infectionVersion.equals(art.getVersion())) continue;
                needReplace = false;
                break;
            }
            if (needReplace) {
                String factVersion = fact == null ? null : fact.getVersion();
                log.severe("Invalid infection version: " + this.infectionVersion + " != " + factVersion);
                this.exit(51);
                return;
            }
        }
        try {
            InfectionRuntimeImpl rt = new InfectionRuntimeImpl(this, indexFile, installation, index, instance, workDir, args, runtimeProperties);
            if (fine) {
                log.fine("Starting runtime: " + rt);
            }
            rt.startup();
        }
        catch (Throwable e) {
            String msg = "Failed to start runtime! Cause: " + e;
            log.log(Level.SEVERE, msg, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Logger getLogger() {
        if (logger != null) return (Logger)logger;
        Class<Infection> clazz = Infection.class;
        synchronized (Infection.class) {
            if (logger != null) return (Logger)logger;
            logger = Logger.getLogger(Infection.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return (Logger)logger;
        }
    }

    private static Window showSplashWindow(Icon splashIcon) throws Exception {
        if (Infection.isHeadless()) {
            return null;
        }
        JWindow tempFrame = new JWindow(new JFrame());
        tempFrame.setLayout(new GridBagLayout());
        StartupProgressBar progressBar = new StartupProgressBar();
        initProgress = progressBar;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 14;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(8, 8, 8, 8);
        progressBar.setPreferredSize(new Dimension(100, 12));
        progressBar.setMinimum(0.0);
        progressBar.setMaximum(1.0);
        progressBar.setOpaque(false);
        progressBar.setBorder(new CompoundBorder());
        progressBar.setValue(0.0);
        progressBar.setTickSize(10);
        progressBar.setTickSpacing(1);
        progressBar.setForeground(new Color(1.0f, 1.0f, 1.0f, 0.4f));
        progressBar.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.4f));
        progressBar.setLightColor(new Color(1.0f, 1.0f, 1.0f, 0.4f));
        progressBar.setDarkColor(new Color(0.0f, 0.0f, 0.0f, 0.4f));
        tempFrame.add((Component)progressBar, gbc);
        JLabel label = new JLabel();
        label.setIcon(splashIcon);
        label.setText("");
        label.setBorder(new EtchedBorder(0, new Color(200, 220, 255), Color.black));
        gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        tempFrame.add((Component)label, gbc);
        tempFrame.pack();
        Infection.centerWindow(tempFrame);
        tempFrame.setVisible(true);
        tempFrame.toFront();
        return tempFrame;
    }

    public static void centerWindow(Window window) {
        Infection.centerWindow(null, window);
    }

    public static void centerWindow(Component owner, Window window) {
        Dimension windowSize = window.getSize();
        Rectangle ownerBounds = null;
        if (owner != null && owner.isShowing()) {
            try {
                Point p = owner.getLocationOnScreen();
                if (p != null) {
                    ownerBounds = owner.getBounds();
                    ownerBounds.x = p.x;
                    ownerBounds.y = p.y;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            Point center;
            if (ownerBounds != null) {
                center = new Point(ownerBounds.x + ownerBounds.width / 2, ownerBounds.y + ownerBounds.height / 2);
            } else {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                center = env.getCenterPoint();
                if (center == null) {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    center = new Point(screenSize.width / 2, screenSize.height / 2);
                }
            }
            window.setLocation(center.x - windowSize.width / 2, center.y - windowSize.height / 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Infection.ensureWindowFitsScreen(window);
    }

    static void ensureWindowFitsScreen(Window window) {
        Rectangle windowBounds = window.getBounds();
        try {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle screenBounds = env.getMaximumWindowBounds();
            if (screenBounds == null) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                screenBounds = new Rectangle(0, 0, screenSize.width, screenSize.height);
            }
            boolean valid = true;
            if (windowBounds.width > screenBounds.width) {
                windowBounds.width = screenBounds.width;
                valid = false;
            }
            if (windowBounds.height > screenBounds.height) {
                windowBounds.height = screenBounds.height;
                valid = false;
            }
            if (windowBounds.x < screenBounds.x) {
                windowBounds.x = screenBounds.x;
                valid = false;
            }
            if (windowBounds.y < screenBounds.y) {
                windowBounds.y = screenBounds.y;
                valid = false;
            }
            if (windowBounds.x + windowBounds.width > screenBounds.x + screenBounds.width) {
                windowBounds.x = screenBounds.x + screenBounds.width - windowBounds.width;
                valid = false;
            }
            if (windowBounds.y + windowBounds.height > screenBounds.y + screenBounds.height) {
                windowBounds.y = screenBounds.y + screenBounds.height - windowBounds.height;
                valid = false;
            }
            if (!valid) {
                window.setBounds(windowBounds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final ClassLoader getMainClassLoader() {
        return this.mainClassLoader;
    }

    private void setMainClassLoader(ClassLoader mainClassLoader) {
        this.mainClassLoader = mainClassLoader;
    }

    final String getMainClassPath() {
        return this.mainClassPath;
    }

    private void setMainClassPath(String mainClassPath) {
        this.mainClassPath = mainClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reloadRuntimeLoggingConfig(InfectionRuntime runtime, Properties loggingProperties) throws Exception {
        Logger logger = Infection.getLogger();
        logger.info("Reloading logging configuration...");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Number of logging properties: " + loggingProperties.size());
            TreeMap<Object, Object> map = new TreeMap<Object, Object>();
            map.putAll(loggingProperties);
            for (Map.Entry me : map.entrySet()) {
                logger.finer("" + me.getKey() + " = " + me.getValue());
            }
        }
        LogManager logManager = LogManager.getLogManager();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Log manager: " + logManager);
        }
        if (logManager == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        loggingProperties.store(baos, "Runtime logging config");
        baos.flush();
        byte[] configData = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(configData);
        try {
            logManager.readConfiguration(bais);
            logger.info("Logging configuration reloaded successfully.");
        }
        finally {
            bais.close();
            if (debug) {
                Infection.debugDumpLoggers(logManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLogging(File loggingPropFile) throws Exception {
        LogManager logManager = LogManager.getLogManager();
        if (debug) {
            Infection.debugMain("Log manager: " + logManager);
        }
        if (logManager == null) {
            return;
        }
        if (debug) {
            Infection.debugMain("Logging properties: " + loggingPropFile);
        }
        if (loggingPropFile != null && loggingPropFile.exists()) {
            FileInputStream fis = new FileInputStream(loggingPropFile);
            try {
                logManager.readConfiguration(fis);
            }
            catch (Throwable e) {
                Infection.debugMain("Error: " + e);
            }
            finally {
                fis.close();
            }
            try {
                Handler[] handlers;
                Logger rootLogger = Logger.getLogger("");
                if (rootLogger != null && (handlers = rootLogger.getHandlers()).length < 1) {
                    InfectionLegacySupport infectionLegacy = new InfectionLegacySupport();
                    infectionLegacy.migrateLegacyLoggingPropFile(loggingPropFile);
                    rootLogger.addHandler(new Log2FileAsyncHandler());
                }
            }
            catch (Throwable e) {
                Infection.debugMain("Error: " + e);
            }
        }
        if (debug) {
            Infection.debugDumpLoggers(logManager);
        }
    }

    public static LogFormatter getLog2ConsoleFormatter(Log2ConsoleHandler handler) {
        return new InfectionLogFormatter();
    }

    public static LogFormatter getLog2FileFormatter(Log2FileHandler handler) {
        return new InfectionLogFormatter();
    }

    public static PrintStream getLog2ConsoleStream(Log2ConsoleHandler handler) {
        if (handler == null) {
            return null;
        }
        if (debug) {
            Infection.debugMain("getLog2ConsoleStream: handler=" + handler + ", instance=" + instance);
        }
        if (instance == null) {
            return System.out;
        }
        return instance.initLog2ConsoleStream();
    }

    public static LogStream getLog2FileStream(Log2FileHandler handler) {
        if (handler == null) {
            return null;
        }
        if (debug) {
            Infection.debugMain("getLog2FileStream: handler=" + handler + ", instance=" + instance);
        }
        if (instance == null) {
            return null;
        }
        return instance.initLog2FileStream();
    }

    public static LogStream getLog2TraceStream(Log2TraceHandler handler) {
        if (handler == null) {
            return null;
        }
        if (debug) {
            Infection.debugMain("getLog2TraceStream: handler=" + handler + ", instance=" + instance);
        }
        if (instance == null) {
            return null;
        }
        return instance.initLog2TraceStream();
    }

    public static void registerLogHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (instance == null) {
            return;
        }
        instance.registerGlobalHandler(handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerGlobalHandler(Handler handler, boolean custom) {
        if (handler == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.registerGlobalHandler"));
        }
        this.initLogging();
        InfectionLogHandler infectionLogHandler = this.logHandler;
        synchronized (infectionLogHandler) {
            if (custom) {
                if (this.customHandlers.add(handler)) {
                    this.installCustomHandler(handler);
                }
            } else {
                this.globalHandlers.add(handler);
            }
            this.logHandler.registerHandler(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterGlobalHandler(Handler handler, boolean custom) {
        if (handler == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.unregisterGlobalHandler"));
        }
        InfectionLogHandler infectionLogHandler = this.logHandler;
        synchronized (infectionLogHandler) {
            if (custom) {
                if (this.customHandlers.remove(handler)) {
                    this.uninstallCustomHandler(handler);
                }
            } else {
                this.globalHandlers.remove(handler);
            }
            if (this.logHandler != null) {
                this.logHandler.unregisterHandler(handler);
            }
        }
    }

    final void registerCustomHandler(Handler handler) {
        this.registerGlobalHandler(handler, true);
    }

    final void unregisterCustomHandler(Handler handler) {
        this.unregisterGlobalHandler(handler, true);
    }

    private void installCustomHandler(Handler handler) {
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers != null) {
            for (int k = 0; k < handlers.length; ++k) {
                if (handlers[k] != handler) continue;
                return;
            }
        }
        rootLogger.addHandler(handler);
    }

    private void uninstallCustomHandler(Handler handler) {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.removeHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loggingConfigChanged() {
        InfectionLogHandler infectionLogHandler = this.logHandler;
        synchronized (infectionLogHandler) {
            if (!this.globalHandlers.isEmpty()) {
                for (Handler handler : this.globalHandlers) {
                    this.logHandler.unregisterHandler(handler);
                }
                this.globalHandlers.clear();
            }
            if (!this.customHandlers.isEmpty()) {
                for (Handler handler : this.customHandlers) {
                    this.installCustomHandler(handler);
                }
            }
        }
    }

    private PrintStream initLog2ConsoleStream() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.initLog2ConsoleStream"));
        }
        if (debug) {
            Infection.debugMain("initLog2ConsoleStream...");
        }
        this.initLogging();
        PrintStream stream = originalSystemOut;
        if (debug) {
            Infection.debugMain("initLog2ConsoleStream: " + stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogStream initLog2FileStream() {
        LogFileStream logStream;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.initLog2FileStream"));
        }
        if (debug) {
            Infection.debugMain("initLog2FileStream: logDir=" + this.logDir);
        }
        this.initLogging();
        LogFileOptions options = LogFileOptions.createDefaultLogFileOptions();
        options = this.getLogFileOptions("Log2FileHandler.", options);
        Infection infection = this;
        synchronized (infection) {
            if (this.log2FileStream == null) {
                this.log2FileStream = new LogFileStream(options);
            } else {
                this.log2FileStream.applyOptions(options);
            }
            logStream = this.log2FileStream;
        }
        if (debug) {
            Infection.debugMain("initLog2FileStream: logStream=" + logStream);
        }
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogStream initLog2TraceStream() {
        LogFileStream logStream;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.initLog2TraceStream"));
        }
        if (debug) {
            Infection.debugMain("initLog2TraceStream: logDir=" + this.logDir);
        }
        this.initLogging();
        LogFileOptions options = LogFileOptions.createDefaultTraceFileOptions();
        options = this.getLogFileOptions("Log2TraceHandler.", options);
        Infection infection = this;
        synchronized (infection) {
            if (this.log2TraceStream == null) {
                this.log2TraceStream = new LogFileStream(options);
            } else {
                this.log2TraceStream.applyOptions(options);
            }
            logStream = this.log2TraceStream;
        }
        if (debug) {
            Infection.debugMain("initLog2TraceStream: " + logStream);
        }
        return logStream;
    }

    private LogFileOptions getLogFileOptions(String keyPrefix, LogFileOptions options) {
        LogManager logManager;
        if (this.logDir != null) {
            options.setDirectory(this.logDir.getPath());
        }
        if ((logManager = LogManager.getLogManager()) != null) {
            options.setProperties(logManager, keyPrefix);
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLogging() {
        if (this.loggingInit) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        if (logManager == null) {
            return;
        }
        Infection infection = this;
        synchronized (infection) {
            if (this.loggingInit) {
                return;
            }
            this.loggingInit = true;
            Handler globalHandler = this.getLogHandler();
            int bufSize = 16384;
            boolean autoFlush = false;
            PrintStream debugOut = originalSystemErr;
            this.sysOutLogger = new SealedLogger("SystemOut", null);
            this.sysOutLogger.setUseParentHandlers(false);
            this.sysOutLogger.setLevel(Level.INFO);
            this.sysOutLogger.addHandler(globalHandler);
            this.sysOutLogger.seal();
            LoggedStream sysOutLogStream = new LoggedStream(this.sysOutLogger, Level.INFO, bufSize, debugOut);
            PrintStream sysOutPrintStream = new PrintStream(sysOutLogStream, autoFlush);
            System.setOut(sysOutPrintStream);
            this.sysErrLogger = new SealedLogger("SystemErr", null);
            this.sysErrLogger.setUseParentHandlers(false);
            this.sysErrLogger.setLevel(Level.INFO);
            this.sysErrLogger.addHandler(globalHandler);
            this.sysErrLogger.seal();
            LoggedStream sysErrLogStream = new LoggedStream(this.sysErrLogger, Level.INFO, bufSize, debugOut);
            PrintStream sysErrPrintStream = new PrintStream(sysErrLogStream, autoFlush);
            System.setErr(sysErrPrintStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler getLogHandler() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.getLogHandler"));
        }
        if (this.logHandler == null) {
            Infection infection = this;
            synchronized (infection) {
                if (this.logHandler == null) {
                    this.globalHandlers = new LinkedList();
                    this.customHandlers = new LinkedList();
                    this.logHandler = new InfectionLogHandler();
                }
            }
        }
        return this.logHandler;
    }

    private void flushLog() throws Exception {
        LogManager logManager = LogManager.getLogManager();
        if (logManager != null) {
            HashSet<Handler> handlers = new HashSet<Handler>();
            Enumeration<String> en = logManager.getLoggerNames();
            while (en.hasMoreElements()) {
                String name = en.nextElement();
                Logger logger = logManager.getLogger(name);
                if (logger == null) continue;
                Handler[] h = logger.getHandlers();
                for (int c = 0; c < h.length; ++c) {
                    handlers.add(h[c]);
                }
            }
            for (Handler handler : handlers) {
                handler.flush();
            }
        }
    }

    private void restoreSystemErrOut() throws Exception {
        if (System.out != originalSystemOut) {
            System.setOut(originalSystemOut);
        }
        if (System.err != originalSystemErr) {
            System.setErr(originalSystemErr);
        }
    }

    private InfectionInstaller createInfectionInstaller() {
        InfectionInstaller installer = new InfectionInstaller();
        return installer;
    }

    private InfectionDialog createInfectionDialog(InfectionRuntimeImpl runtime, boolean unattended) {
        Logger log = Infection.getLogger();
        InfectionInstaller installer = this.createInfectionInstaller();
        try {
            File infectionIndexDir;
            File infectionIndexFile = runtime.getInfectionIndexFile();
            File file = infectionIndexDir = infectionIndexFile == null ? null : infectionIndexFile.getParentFile();
            if (infectionIndexDir != null && infectionIndexDir.exists()) {
                File indexXmlFile = new File(infectionIndexDir, "index.xml");
                if (debug) {
                    Infection.debugMain("Index-File: " + indexXmlFile);
                }
                if (indexXmlFile.exists()) {
                    boolean isInstallationDir = false;
                    InfectionIndex testIndex = null;
                    try {
                        testIndex = this.loadInfectionIndex(indexXmlFile);
                        if (testIndex.getArtifactCount() > 0) {
                            isInstallationDir = true;
                        }
                        if (testIndex.getInstanceCount() > 0) {
                            isInstallationDir = true;
                        }
                    }
                    catch (Exception e) {
                        Infection.handleException(e);
                    }
                    if (isInstallationDir) {
                        File installationDir = infectionIndexDir.getAbsoluteFile().getParentFile();
                        installer.setInstallationDirectory(installationDir);
                        if (log.isLoggable(Level.INFO)) {
                            log.info("Installation directory: " + installationDir);
                        }
                    } else if (testIndex != null) {
                        int numSites = testIndex.getSiteCount();
                        for (int i = 0; i < numSites; ++i) {
                            InfectionSite site = testIndex.getSiteAt(i);
                            String sitePath = Infection.getAbsoluteSiteURL(site.getPath());
                            InfectionSite resolved = new InfectionSite(sitePath);
                            resolved.setName(site.getName());
                            resolved.setPath(sitePath);
                            resolved.setRecursive(site.isRecursive());
                            resolved.setActive(site.isActive());
                            installer.addDefaultSite(resolved);
                        }
                    }
                }
            }
            if (installer.getInstallationDirectory() == null) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("No installations found.");
                }
                boolean useCurrentDir = true;
                boolean useUserHome = true;
                if (useCurrentDir) {
                    File currDir = new File(".").getAbsoluteFile();
                    File indexDir = new File(currDir, ".artifacts");
                    if (indexDir.exists() && indexDir.isDirectory()) {
                        File defaultInstallDir = currDir.getCanonicalFile();
                        installer.setInstallationDirectory(defaultInstallDir);
                        useUserHome = false;
                    } else {
                        useCurrentDir = false;
                    }
                }
                if (useUserHome) {
                    String userHome = System.getProperty("user.home");
                    if (userHome == null) {
                        userHome = ".";
                    }
                    File defaultInstallDir = new File(userHome, this.appName);
                    defaultInstallDir = defaultInstallDir.getCanonicalFile();
                    installer.setInstallationDirectory(defaultInstallDir);
                }
            }
        }
        catch (Exception e) {
            Infection.handleException(e);
        }
        try {
            for (Map.Entry<Object, Object> me : this.distProperties.entrySet()) {
                String key = (String)me.getKey();
                if (!key.startsWith("site.")) continue;
                String name = key.substring("site.".length());
                String value = (String)me.getValue();
                InfectionSite site = new InfectionSite(value);
                site.setName(name);
                site.setPath(value);
                site.setRecursive(true);
                site.setActive(value != null && value.length() > 0);
                installer.addDefaultSite(site);
            }
        }
        catch (Exception e) {
            Infection.handleException(e);
        }
        JFrame frame = null;
        if (!unattended) {
            frame = new JFrame();
        }
        this.dialogWindow = frame;
        if (frame != null) {
            try {
                Image iconImage = this.getDistributionResourceImage("icon16");
                frame.setIconImage(iconImage);
            }
            catch (Exception e) {
                Infection.handleException(e);
            }
        }
        InfectionRuntimeFacade facade = runtime.getFacade();
        InfectionDialog id = new InfectionDialog(installer, (Window)initWindow, frame, facade);
        if (this.appTitle != null) {
            id.setDistributionTitle(this.appTitle);
        }
        return id;
    }

    final boolean installPlatform(InfectionRuntimeImpl runtime, int panelId) throws Exception {
        if (this.dialogOpen) {
            if (this.dialogWindow != null) {
                ((Window)this.dialogWindow).toFront();
            }
            throw new RuntimeException("Infection installer dialog already open");
        }
        try {
            boolean done;
            this.dialogOpen = true;
            boolean unattended = false;
            InfectionDialog id = this.createInfectionDialog(runtime, unattended);
            boolean bl = done = id.installPlatform(panelId);
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.dialogOpen = false;
            this.dialogWindow = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void handleException(Throwable e) {
        long time = System.currentTimeMillis();
        Class<Infection> clazz = Infection.class;
        synchronized (Infection.class) {
            errors.add(e);
            try {
                FileOutputStream fout = new FileOutputStream(DEBUG_LOG_FILENAME, true);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fout));
                writer.write("Infection.handleException: " + Debug.getTimeString(time));
                writer.newLine();
                writer.flush();
                PrintStream ps = new PrintStream(fout);
                e.printStackTrace(ps);
                ps.flush();
                fout.flush();
                writer.close();
            }
            catch (Throwable e2) {
                // empty catch block
            }
            PrintStream out = originalSystemErr;
            if (out == null) {
                out = System.err;
            }
            e.printStackTrace(out);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    final void shutdown(InfectionRuntimeImpl runtime) throws Exception {
        Iterator i = this.runtimes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() != runtime) continue;
            i.remove();
            InfectionRuntimeFacade facade = runtime.getFacade();
            if (facade != null) {
                facade.dispose();
            }
            runtime.setRunning(false);
            if (debug) {
                Infection.debugMain("Infection shutdown: " + runtime);
            }
            return;
        }
        if (debug) {
            Infection.debugMain("DEBUG: Runtime not registered: " + runtime);
        }
    }

    final void exit(int exitCode) throws Exception {
        int numRuntimes;
        System.out.println("Infection exit: " + exitCode);
        if (this.exiting) {
            return;
        }
        if (this.highestExitCode != exitCode && (this.highestExitCode == 0 || exitCode > this.highestExitCode)) {
            this.highestExitCode = exitCode;
        }
        if ((numRuntimes = this.runtimes.size()) > 0) {
            System.out.println("Existing runtimes available: " + numRuntimes);
            Iterator i = this.runtimes.values().iterator();
            while (i.hasNext()) {
                System.out.println(" - " + i.next());
            }
            return;
        }
        if (this.dialogOpen) {
            System.out.println("Infection dialog is open!");
            return;
        }
        if (this.restarting) {
            System.out.println("Infection already restarting!");
            return;
        }
        if (!exitEnabled) {
            System.out.println("Infection exit disabled!");
            return;
        }
        this.exiting = true;
        this.exitThread.start();
    }

    private void exitHook() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            System.gc();
            Debug.dumpShutdownHooks(System.out);
            Debug.dumpThreads(System.out);
            Iterator iter = Debug.getDebugReferences();
            if (iter != null && iter.hasNext()) {
                Debug.dumpDebugReferences(System.out);
                Debug.clearDebugReferences();
            }
        }
        try {
            this.restoreSystemErrOut();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            this.flushLog();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        Runnable replaceOnExit = this.getReplaceStartupOnExit();
        if (replaceOnExit != null) {
            this.setReplaceStartupOnExit(null);
            try {
                replaceOnExit.run();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                this.flushLog();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        try {
            if (debug) {
                Infection.debugMain("Exit: " + this.highestExitCode);
            }
            System.exit(this.highestExitCode);
        }
        catch (Throwable e) {
            originalSystemOut.println("OOPS.. system not exited!");
            e.printStackTrace(System.out);
        }
        new Throwable("OOPS: System not exited! -> trying to HALT: " + this.highestExitCode).printStackTrace(originalSystemOut);
        Runtime.getRuntime().halt(this.highestExitCode);
        originalSystemOut.println("EXIT FAILED!");
    }

    final void openInstanceConfig(final InfectionRuntime access, final int panelId) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    InfectionRuntimeImpl impl = null;
                    if (access instanceof InfectionRuntimeImpl) {
                        impl = (InfectionRuntimeImpl)access;
                    }
                    if (access instanceof InfectionRuntimeFacade) {
                        InfectionRuntimeFacade facade = (InfectionRuntimeFacade)access;
                        impl = facade.getRuntime();
                    }
                    if (impl == null) {
                        throw new RuntimeException("Infection runtime is closed!");
                    }
                    boolean done = Infection.this.installPlatform(impl, panelId);
                    System.out.println("InfectionDialog closed[1]: done=" + done);
                    if (!done) {
                        System.out.println("Runtime started: " + access.isRunning());
                        if (!access.isRunning()) {
                            Infection.getInstance().exit(0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(runnable).start();
    }

    final void openUpdateManager(final InfectionRuntime access) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    InfectionRuntimeImpl impl = null;
                    if (access instanceof InfectionRuntimeImpl) {
                        impl = (InfectionRuntimeImpl)access;
                    }
                    if (access instanceof InfectionRuntimeFacade) {
                        InfectionRuntimeFacade facade = (InfectionRuntimeFacade)access;
                        impl = facade.getRuntime();
                    }
                    if (impl == null) {
                        throw new RuntimeException("Infection runtime is closed!");
                    }
                    boolean done = Infection.this.installPlatform(impl, 100);
                    System.out.println("InfectionDialog closed[2]: done=" + done);
                    if (!done) {
                        System.out.println("Runtime started: " + access.isRunning());
                        if (!access.isRunning()) {
                            Infection.getInstance().exit(0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(runnable).start();
    }

    final boolean isAutoSoftwareUpdateEnabled() {
        return autoSoftwareUpdateEnabled;
    }

    final Thread startAutoSoftwareUpdate(final InfectionRuntime access, final boolean promptCheck, final boolean promptDownload, final boolean promptApply, final boolean ignoreHeadless) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.startAutoSoftwareUpdate"));
        }
        if (!autoSoftwareUpdateEnabled) {
            throw new IllegalStateException("Automatic software update is disabled!");
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean autoSave = true;
                boolean promptRestart = true;
                if (ignoreHeadless) {
                    promptRestart = false;
                }
                Infection.this.performAutoSoftwareUpdate(access, promptCheck, promptDownload, promptApply, autoSave, promptRestart, ignoreHeadless);
            }
        });
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAutoSoftwareUpdate(InfectionRuntime access, boolean promptCheck, boolean promptDownload, boolean promptApply, boolean autoSave, boolean promptRestart, boolean ignoreHeadless) {
        InfectionRuntimeFacade facade;
        Logger log = Infection.getLogger();
        InfectionRuntimeImpl impl = null;
        if (access instanceof InfectionRuntimeImpl) {
            impl = (InfectionRuntimeImpl)access;
        }
        if (access instanceof InfectionRuntimeFacade && (impl = (facade = (InfectionRuntimeFacade)access).getRuntime()) == null) {
            throw new RuntimeException("Infection runtime is closed!");
        }
        if (impl == null) {
            throw new RuntimeException("Invalid infection runtime: " + access);
        }
        if (!ignoreHeadless && Infection.isHeadless()) {
            log.fine("Headless: (ignore software update)");
            return;
        }
        if (this.dialogOpen) {
            if (this.dialogWindow != null) {
                ((Window)this.dialogWindow).toFront();
            }
            log.fine("Infection installer dialog already open. (ignore software update)");
            return;
        }
        if (promptCheck) {
            int messageType;
            int optionType;
            String title = "Software Update";
            String message = "An automatic software update check is scheduled.";
            Component parentComponent = null;
            int rc = JOptionPane.showConfirmDialog(parentComponent, message = message + "\nDo you want to check for available updates ?", title, optionType = 2, messageType = 3);
            if (rc != 0) {
                return;
            }
        }
        if (this.dialogOpen) {
            if (this.dialogWindow != null) {
                ((Window)this.dialogWindow).toFront();
            }
            throw new RuntimeException("Infection installer dialog already open");
        }
        try {
            String message;
            this.dialogOpen = true;
            boolean unattended = ignoreHeadless || Infection.isHeadless();
            InfectionDialog dialog = this.createInfectionDialog(impl, unattended);
            dialog.actionShowLocationMenuPage();
            dialog.actionShowUpdateSites(false);
            dialog.refreshUpdateSites(true);
            log.info("Checking for software updates...");
            dialog.showDownloadArtifactsTablePage();
            int count = dialog.getSelectedDownloadArtifactCount();
            log.info("Number of artifacts to download: " + count);
            if (count <= 0) {
                log.fine("No software updates available.");
                if (promptCheck) {
                    String title = "Software Update";
                    message = "Currently, there are no updates available.";
                    int messageType = 1;
                    Component parentComponent = null;
                    JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
                }
                return;
            }
            if (promptDownload) {
                int messageType;
                int optionType;
                String title = "Software Update";
                message = "New software updates are available: " + count;
                Component parentComponent = null;
                int rc = JOptionPane.showConfirmDialog(parentComponent, message = message + "\nDo you want to download ?", title, optionType = 2, messageType = 3);
                if (rc != 0) {
                    return;
                }
            }
            log.info("Downloading software updates: " + count);
            if (!autoSave) {
                dialog.showDialog();
            }
            dialog.setPromptUpgrade(promptApply);
            dialog.setAutoSaveConfig(autoSave);
            dialog.setPromptRestart(autoSave && promptRestart);
            dialog.startDownloadArtifacts(true);
        }
        catch (Exception e) {
            Infection.handleException(e);
        }
        finally {
            this.dialogOpen = false;
            this.dialogWindow = null;
            log.info("Software update completed.");
        }
    }

    private static void printSystemProperties(Logger log) {
        Properties props = System.getProperties();
        TreeMap<String, String> map = new TreeMap<String, String>();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = props.getProperty(key);
            map.put(key, value);
        }
        for (Map.Entry me : map.entrySet()) {
            String k = (String)me.getKey();
            String v = (String)me.getValue();
            v = Infection.getSystemPropertyValueString(k, v);
            log.config("" + k + " = " + v);
        }
    }

    public static String getSystemPropertyValueString(String k, String v) {
        if ("line.separator".equals(k) && v != null) {
            if ("\n".equals(v)) {
                v = "\\n";
            } else if ("\r\n".equals(v)) {
                v = "\\r\\n";
            }
        }
        return v;
    }

    private void logSystemProperties(Logger out) {
        this.logSystemProperty("java.version", out);
        this.logSystemProperty("java.vm.name", out);
        this.logSystemProperty("java.vm.version", out);
        this.logSystemProperty("java.vm.vendor", out);
        this.logSystemProperty("java.home", out);
        this.logSystemProperty("os.name", out);
        this.logSystemProperty("os.version", out);
        this.logSystemProperty("os.arch", out);
        this.logSystemProperty("java.class.path", out);
        this.logSystemProperty("java.library.path", out);
        this.logSystemProperty("sun.boot.class.path", out);
        this.logSystemProperty("sun.boot.library.path", out);
        this.logSystemProperty("java.util.logging.manager", out);
        this.logSystemProperty("java.util.logging.config.file", out);
        this.logSystemProperty("user.name", out);
        this.logSystemProperty("user.language", out);
        this.logSystemProperty("user.country", out);
        this.logSystemProperty("user.home", out);
        this.logSystemProperty("user.dir", out);
    }

    private void logSystemProperty(String key, Logger log) {
        try {
            String value = System.getProperty(key);
            log.config("" + key + " = " + value);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Error getting system property: " + key, e);
        }
    }

    final synchronized void registerInfectionRuntime(Thread thread, InfectionRuntime runtime) throws Exception {
        if (thread != null && runtime != null) {
            Infection.getLogger().fine("registerInfectionRuntime: " + thread + " => " + runtime);
            this.runtimes.put(thread, runtime);
        }
    }

    public final synchronized InfectionRuntime getInfectionRuntime() throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("infection.access"));
        }
        if (instance == null) {
            throw new RuntimeException("Infection not initialized");
        }
        Thread thread = Thread.currentThread();
        InfectionRuntimeImpl acc = (InfectionRuntimeImpl)this.runtimes.get(thread);
        if (acc == null) {
            return null;
        }
        return acc.getFacade();
    }

    final void closeSplashWindow() {
        Window win = (Window)initWindow;
        if (win != null) {
            win.dispose();
        }
        initWindow = null;
        initProgress = null;
    }

    final void startInfectionRuntime(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, Map runtimeProperties) throws Throwable {
        InfectionInstaller installer = new InfectionInstaller();
        JavaProcess process = installer.buildJavaProcess(installation, index, instance);
        ProcessOutputHandler handler = new ProcessOutputHandler();
        process.setOutputHandler(handler);
        process.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void restartInfectionRuntime(InfectionRuntime rt, InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, Map runtimeProperties) throws Throwable {
        InfectionRuntimeImpl impl = (InfectionRuntimeImpl)rt;
        try {
            boolean ok;
            this.restarting = true;
            if (debug) {
                Infection.debugMain("Restart runtime...");
            }
            if (!(ok = impl.shutdownNormally())) {
                throw new RuntimeException("User has cancelled the shutdown process.");
            }
            impl.shutdown();
            this.flushLog();
            this.startInfectionRuntime(installation, index, instance, runtimeProperties);
            this.setReplaceStartupOnExit(null);
            boolean isDialogOpen = this.dialogOpen;
            this.restarting = false;
            try {
                this.dialogOpen = false;
                this.exit(0);
            }
            finally {
                if (isDialogOpen) {
                    this.dialogOpen = true;
                }
            }
            return;
        }
        finally {
            this.restarting = false;
        }
    }

    private InfectionIndex loadInfectionIndex(File indexFile) throws Exception {
        InfectionIndex index = new InfectionIndex(indexFile);
        return index;
    }

    private InfectionInstance loadInfectionInstance(File configFile) throws Exception {
        InfectionInstance inst = new InfectionInstance(configFile);
        return inst;
    }

    static void setStartupProgress(double progress) {
        StartupProgressBar progressBar = (StartupProgressBar)initProgress;
        if (progressBar != null) {
            progressBar.setValue(progress);
            progressBar.repaint();
        }
    }

    final InfectionRuntime getRuntimeInstance(InfectionInstance instance) throws Exception {
        File instanceFile = instance.getInstanceFile();
        if (instanceFile == null) {
            return null;
        }
        for (InfectionRuntimeImpl rt : this.runtimes.values()) {
            File file = rt.getInstanceConfigFile();
            if (file == null || !instanceFile.equals(file)) continue;
            return rt;
        }
        return null;
    }

    final File getInstanceConfigFile(InfectionRuntime runtime) throws Exception {
        File configFile;
        InfectionRuntimeFacade facade;
        InfectionRuntimeImpl runtimeImpl;
        if (runtime == null) {
            return null;
        }
        if (runtime instanceof InfectionRuntimeFacade && (runtimeImpl = (facade = (InfectionRuntimeFacade)runtime).getRuntime()) != null && (configFile = runtimeImpl.getInstanceConfigFile()) != null) {
            return configFile;
        }
        return null;
    }

    public String getInfectionVersionInfoString() {
        if (this.infectionTitle == null) {
            return UNKNOWN;
        }
        return this.infectionTitle + " " + this.infectionVersion;
    }

    static File getCurrentDirectory() {
        String currDir = new File(".").getAbsolutePath();
        if (currDir.endsWith("" + File.separatorChar + ".")) {
            currDir = currDir.substring(0, currDir.length() - 2);
        }
        return new File(currDir);
    }

    public static String getSlashPath(String path) {
        if (path == null) {
            return null;
        }
        return path.replace('\\', '/');
    }

    static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    static String getLineSeparator() {
        String separator = "\n";
        try {
            String lineSep = System.getProperty("line.separator");
            if (lineSep != null) {
                separator = lineSep;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final InfectionEnhancement.XMLValidatorV1 getXMLValidatorV1() {
        if (this.xmlValidatorV1 == null && !this.xmlValidatorV1checked) {
            try {
                String className = "com.spacekiller.infection.j15.XMLValidatorV1J15Impl";
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                this.xmlValidatorV1 = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                this.xmlValidatorV1checked = true;
            }
        }
        return (InfectionEnhancement.XMLValidatorV1)this.xmlValidatorV1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadDistributionProperties() throws Throwable {
        String metaServicesDistributionDescriptorPath = "META-INF/services/com.spacekiller.infection.DistributionDescriptor";
        Enumeration<URL> enumDistDescr = this.getClass().getClassLoader().getResources("META-INF/services/com.spacekiller.infection.DistributionDescriptor");
        if (enumDistDescr != null) {
            while (enumDistDescr.hasMoreElements()) {
                URL metaServicesDistDescriptorURL = enumDistDescr.nextElement();
                if (metaServicesDistDescriptorURL == null) continue;
                try {
                    InputStream metaServicesDistDescriptorStream = metaServicesDistDescriptorURL.openStream();
                    try {
                        URL distDescriptorURL = metaServicesDistDescriptorURL;
                        ZipFile distJarZipFile = null;
                        Properties distProps = this.loadDistributionProperties(metaServicesDistDescriptorStream, distDescriptorURL, distJarZipFile);
                        if (distProps == null) continue;
                        Properties properties = distProps;
                        return properties;
                    }
                    finally {
                        metaServicesDistDescriptorStream.close();
                    }
                }
                catch (Throwable e) {
                    Infection.debugMain("Failed to load resource: " + metaServicesDistDescriptorURL + " -> " + e);
                }
            }
        }
        String distFilePath = null;
        String propDistJarFile = System.getProperty("infection.dist");
        if (propDistJarFile != null && propDistJarFile.length() > 0) {
            distFilePath = propDistJarFile;
        }
        if (distFilePath == null && (distFilePath = new InfectionLegacySupport().getLegacyDistJarPath()) == null) {
            String msg = "Missing distribution system-property: -Dinfection.dist";
            Infection.debugMain(msg);
            throw new Error(msg);
        }
        File distFile = new File(distFilePath);
        if (!(distFile = distFile.getAbsoluteFile()).exists()) throw new Error("The distribution archive was not found: " + distFile);
        if (!distFile.isFile()) throw new Error("The distribution archive was not found: " + distFile);
        this.distZipURL = InfectionUtil.getFileURL(distFile);
        ZipFile distZipFile = new ZipFile(distFile);
        ZipEntry metaServicesDistDescriptorEntry = distZipFile.getEntry("META-INF/services/com.spacekiller.infection.DistributionDescriptor");
        if (metaServicesDistDescriptorEntry == null) {
            throw new Error("Invalid distribution archive: " + distFile + " (Cause: missing entry: " + "META-INF/services/com.spacekiller.infection.DistributionDescriptor" + ")");
        }
        this.distZipFile = distZipFile;
        InputStream metaServicesDistDescriptorStream = distZipFile.getInputStream(metaServicesDistDescriptorEntry);
        try {
            URL distDescriptorURL = null;
            ZipFile distJarZipFile = distZipFile;
            Properties distProps = this.loadDistributionProperties(metaServicesDistDescriptorStream, distDescriptorURL, distJarZipFile);
            if (distProps == null) throw new Error("The distribution archive is not valid: " + distFile);
            Properties properties = distProps;
            return properties;
        }
        finally {
            metaServicesDistDescriptorStream.close();
        }
    }

    /*
     * Exception decompiling
     */
    private Properties loadDistributionProperties(InputStream metaServicesDistDescriptorStream, URL distDescriptorURL, ZipFile distJarZipFile) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Properties loadDistributionProperties(InputStream distPropsInputStream) throws Throwable {
        Properties distProps = new Properties();
        distProps.load(distPropsInputStream);
        return distProps;
    }

    public String getDistributionProperty(String key) {
        return this.distProperties.getProperty(key);
    }

    public InputStream getDistributionResourceInput(String key) throws IOException {
        if (key == null) {
            return null;
        }
        if (key.length() < 1) {
            return null;
        }
        String resource = this.distProperties.getProperty(key);
        if (resource == null) {
            return null;
        }
        if (resource.length() < 1) {
            return null;
        }
        if (this.distZipFile == null) {
            URL url = this.getClass().getResource(resource);
            if (url != null) {
                return url.openStream();
            }
        } else {
            ZipEntry entry;
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if ((entry = this.distZipFile.getEntry(resource)) != null) {
                return this.distZipFile.getInputStream(entry);
            }
        }
        return null;
    }

    public Image getDistributionResourceImage(String key) throws IOException {
        byte[] data = this.getDistributionResourceData(key);
        if (data != null) {
            return Toolkit.getDefaultToolkit().createImage(data);
        }
        return null;
    }

    public Icon getDistributionResourceIcon(String key) throws IOException {
        Image image = this.getDistributionResourceImage(key);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDistributionResourceData(String key) throws IOException {
        InputStream in = this.getDistributionResourceInput(key);
        if (in == null) {
            return null;
        }
        try {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[32768];
            while ((n = in.read(buf)) >= 0) {
                baos.write(buf, 0, n);
            }
            baos.flush();
            byte[] data = baos.toByteArray();
            baos.close();
            byte[] byArray = data;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static String getAbsoluteSiteURL(String sitePath) {
        try {
            if (sitePath.indexOf("://") < 0 && !sitePath.startsWith("file:")) {
                File f = new File(sitePath);
                sitePath = f.toURI().toURL().toString();
            }
        }
        catch (MalformedURLException e) {
            Infection.handleException(e);
        }
        return sitePath;
    }

    private int shell(InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, String[] cmdArgs, boolean openShell) throws Exception {
        InfectionInstaller installer = this.createInfectionInstaller();
        InputStream stdin = System.in;
        PrintStream stdout = originalSystemOut;
        PrintStream stderr = originalSystemErr;
        URL infectionJarURL = null;
        String url = this.mminfectionURL;
        if (url != null) {
            infectionJarURL = new URL(url);
        }
        URL distributionJarURL = this.distZipURL;
        Infection.getLogger().fine("Infection jar: " + infectionJarURL);
        Infection.getLogger().fine("Distribution jar: " + distributionJarURL);
        Infection infection = this;
        int resultCode = this.getInfectionAccess().executeCommand(infection, installer, installation, index, instance, stdin, stdout, stderr, infectionJarURL, distributionJarURL, cmdArgs, openShell);
        return resultCode;
    }

    public boolean isDisableURLCaches() {
        return this.disableURLCaches;
    }

    private Runnable getReplaceStartupOnExit() {
        return this.replaceStartupOnExit;
    }

    final void setReplaceStartupOnExit(Runnable replaceStartupOnExit) {
        this.replaceStartupOnExit = replaceStartupOnExit;
    }

    public InfectionAccess getInfectionAccess() throws SecurityException {
        return new InfectionAccessImpl(this);
    }

    static {
        exitEnabled = true;
        autoSoftwareUpdateEnabled = true;
        verifyInfectionVersionEnabled = true;
        debug = false;
        errors = new ArrayList();
    }

    protected class ProcessOutputHandler
    implements JavaProcess.OutputHandler {
        protected ProcessOutputHandler() {
        }

        @Override
        public void handle(String s) {
            System.out.println("Process.out >> " + s);
        }
    }

    final class LoggingChangeHandler
    implements PropertyChangeListener {
        LoggingChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Infection.this.loggingConfigChanged();
        }
    }

    final class Exit
    implements Runnable {
        Exit() {
        }

        @Override
        public void run() {
            Infection.this.exitHook();
        }
    }

    static class Main
    implements PrivilegedAction {
        private String[] args;

        public Main(String[] args) {
            this.args = args;
        }

        public Object run() {
            try {
                Infection.mainPrivileged(this.args);
                return null;
            }
            catch (Throwable e) {
                if (debug) {
                    Infection.debugMain("Infection.main: " + e);
                }
                Infection.handleException(e);
                if (exitEnabled) {
                    System.exit(2);
                }
                return null;
            }
        }
    }
}

