/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.load.ArtifactClassLoader;
import com.spacekiller.infection.load.ArtifactClassLoaderImpl;
import com.spacekiller.infection.load.ArtifactLoader;
import com.spacekiller.infection.load.ArtifactResourceLoader;
import com.spacekiller.infection.load.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InfectionArtifactLoader
implements ArtifactLoader {
    protected static final String DEFAULT_PACKAGE = ".";
    protected static final InfectionArtifactLoader[] NULL_IMPORTS = new InfectionArtifactLoader[0];
    private static final Logger logger = Logger.getLogger(InfectionArtifactLoader.class.getName());
    private Object id;
    private URL[] urls;
    private File[] libpath;
    private ClassLoader parentClassLoader;
    private AccessControlContext acc = AccessController.getContext();
    private Reference classLoader;
    private ResourceLoader resourceLoader;
    private InfectionArtifactLoader[] imports;
    private Map packages = new HashMap();
    private Permission[] defaultPermissions;

    public InfectionArtifactLoader(Object id, URL[] urls, String[] libpath, ClassLoader parentClassLoader, Permission[] defaultPermissions) throws Exception {
        this.imports = NULL_IMPORTS;
        this.id = id;
        this.urls = urls;
        this.parentClassLoader = parentClassLoader;
        this.defaultPermissions = defaultPermissions;
        ArrayList<File> libs = new ArrayList<File>();
        if (libpath != null) {
            for (int c = 0; c < libpath.length; ++c) {
                String path = libpath[c];
                if (path == null || (path = path.trim()).length() <= 0) continue;
                File dir = new File(path);
                libs.add(dir);
            }
        }
        this.libpath = libs.toArray(new File[libs.size()]);
        this.resourceLoader = this.createResourceLoader(urls);
    }

    @Override
    public ClassLoader findClass(String name) {
        ClassLoader loader;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findClass", "name=" + name + ", artifact=" + this.id);
        }
        if ((loader = this.findImportedClass(name)) == null) {
            loader = this.findLocalClass(name);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findClass", "name=" + name + ", artifact=" + this.id + ", loader=" + loader);
        }
        return loader;
    }

    @Override
    public String findLibrary(String name) {
        String path;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLibrary", "name=" + name + ", artifact=" + this.id);
        }
        if ((path = this.findImportedLibrary(name)) == null) {
            path = this.findLocalLibrary(name);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLibrary", "name=" + name + ", artifact=" + this.id + ", path=" + path);
        }
        return path;
    }

    @Override
    public URL findResource(String name) {
        URL url;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findResource", "name=" + name + ", artifact=" + this.id);
        }
        if ((url = this.findImportedResource(name)) == null) {
            url = this.findLocalResource(name);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findResource", "name=" + name + ", artifact=" + this.id + ", url=" + url);
        }
        return url;
    }

    @Override
    public Enumeration findResources(String name) throws IOException {
        Enumeration en;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findResources", "name=" + name + ", artifact=" + this.id);
        }
        if ((en = this.findImportedResources(name)) == null || !en.hasMoreElements()) {
            en = this.findLocalResources(name);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findResources", "name=" + name + ", artifact=" + this.id + ", en=" + en);
        }
        return en;
    }

    protected ResourceLoader createResourceLoader(URL[] urls) throws Exception {
        ArtifactClassLoader classLoader = this.getClassLoader();
        ArtifactResourceLoader resourceLoader = new ArtifactResourceLoader(classLoader);
        return resourceLoader;
    }

    protected ArtifactClassLoader createClassLoader() throws Exception {
        URLStreamHandlerFactory factory = null;
        ArtifactClassLoaderImpl loader = new ArtifactClassLoaderImpl(this.id, this, this.urls, this.parentClassLoader, factory);
        return loader;
    }

    protected final ArtifactClassLoader getClassLoader(boolean initialize) {
        ArtifactClassLoader loader;
        Reference ref = this.classLoader;
        if (ref != null && (loader = (ArtifactClassLoader)ref.get()) != null) {
            return loader;
        }
        if (initialize) {
            return this.getClassLoader();
        }
        return null;
    }

    protected final ArtifactClassLoader getClassLoader() {
        ArtifactClassLoader loader;
        Reference ref = this.classLoader;
        if (ref != null && (loader = (ArtifactClassLoader)ref.get()) != null) {
            return loader;
        }
        return (ArtifactClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    ArtifactClassLoader loader;
                    Reference ref = InfectionArtifactLoader.this.classLoader;
                    if (ref != null && (loader = (ArtifactClassLoader)ref.get()) != null) {
                        return loader;
                    }
                    try {
                        loader = InfectionArtifactLoader.this.createClassLoader();
                        InfectionArtifactLoader.this.classLoader = new SoftReference<ArtifactClassLoader>(loader);
                        return loader;
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }
            }
        }, this.acc);
    }

    public final boolean isClassLoaderInitialized() {
        Reference ref = this.classLoader;
        if (ref == null) {
            return false;
        }
        return ref.get() != null;
    }

    protected ClassLoader findLocalClass(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalClass", "name=" + name + ", artifact=" + this.id);
        }
        final String path = name.replace('.', '/').concat(".class");
        URL classURL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return InfectionArtifactLoader.this.resourceLoader.findResource(path, true);
            }
        }, this.acc);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLocalClass", "name=" + name + ", artifact=" + this.id + ", url=" + classURL);
        }
        if (classURL == null) {
            return null;
        }
        return this.getClassLoader();
    }

    protected String findLocalLibrary(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalLibrary", "name=" + name + ", artifact=" + this.id);
        }
        if (name == null) {
            return null;
        }
        int n = this.libpath.length;
        if (n > 0) {
            String libFileName = System.mapLibraryName(name);
            if (libFileName == null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(this.getClass().getName(), "findLocalLibrary", "name=" + name + ", artifact=" + this.id + ", error=Failed to map library name: " + name);
                }
                return null;
            }
            for (int c = 0; c < n; ++c) {
                File dir = this.libpath[c];
                File file = new File(dir, libFileName);
                if (!file.exists()) continue;
                String libFilePath = file.getAbsolutePath();
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(this.getClass().getName(), "findLocalLibrary", "name=" + name + ", artifact=" + this.id + ", path=" + libFilePath);
                }
                return libFilePath;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Artifact loader could not find native library: name=" + name + ", file=" + libFileName + ", artifact=" + this.id);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLocalLibrary", "name=" + name + ", artifact=" + this.id + ", path=" + null);
        }
        return null;
    }

    protected URL findLocalResource(final String name) {
        URL url;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalResource", "name=" + name + ", artifact=" + this.id);
        }
        if ((url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return InfectionArtifactLoader.this.resourceLoader.findResource(name, true);
            }
        }, this.acc)) == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "findLocalResource", "name=" + name + ", artifact=" + this.id + ", url=" + null);
            }
            return null;
        }
        URL localURL = this.resourceLoader.checkURL(url);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findLocalResource", "name=" + name + ", artifact=" + this.id + ", url=" + localURL);
        }
        return localURL;
    }

    protected Enumeration findLocalResources(String name) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findLocalResources", "name=" + name + ", artifact=" + this.id);
        }
        final Enumeration e = this.resourceLoader.findResources(name, true);
        return new Enumeration(){
            private URL url = null;

            private boolean next() {
                URL u;
                if (this.url != null) {
                    return true;
                }
                while ((u = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (!e.hasMoreElements()) {
                            return null;
                        }
                        return e.nextElement();
                    }
                }, InfectionArtifactLoader.this.acc)) != null) {
                    this.url = InfectionArtifactLoader.this.resourceLoader.checkURL(u);
                    if (this.url == null) continue;
                }
                return this.url != null;
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL u = this.url;
                this.url = null;
                return u;
            }

            @Override
            public boolean hasMoreElements() {
                return this.next();
            }
        };
    }

    public static String getPackageName(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0) {
            return name.substring(0, index);
        }
        return DEFAULT_PACKAGE;
    }

    protected ClassLoader findImportedClass(String name) {
        ClassLoader loader;
        String pkg;
        PackageImport imp;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findImportedClass", "name=" + name + ", artifact=" + this.id);
        }
        if ((imp = (PackageImport)this.packages.get(pkg = InfectionArtifactLoader.getPackageName(name))) != null && (loader = imp.findClass(name)) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "findImportedClass", "name=" + name + ", artifact=" + this.id + ", loader=" + loader);
            }
            return loader;
        }
        int n = this.imports.length;
        for (int i = 0; i < n; ++i) {
            loader = this.imports[i].findLocalClass(name);
            if (loader == null) continue;
            if (loader instanceof ArtifactClassLoader) {
                ArtifactClassLoader acl = (ArtifactClassLoader)loader;
                InfectionArtifactLoader al = (InfectionArtifactLoader)acl.getDelegate();
                SinglePackageImport pkgImport = new SinglePackageImport(pkg, al);
                if (imp == null) {
                    this.packages.put(pkg, pkgImport);
                } else {
                    MultiPackageImport multi;
                    SinglePackageImport def;
                    if (imp instanceof SinglePackageImport && (def = (SinglePackageImport)imp).getLoader() == al) {
                        return acl;
                    }
                    if (imp instanceof MultiPackageImport) {
                        multi = (MultiPackageImport)imp;
                        multi.addImport(pkgImport);
                    } else {
                        multi = new MultiPackageImport(pkg);
                        multi.addImport(imp);
                        multi.addImport(pkgImport);
                        this.packages.put(pkg, multi);
                    }
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "findImportedClass", "name=" + name + ", artifact=" + this.id + ", loader=" + loader);
            }
            return loader;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findImportedClass", "name=" + name + ", artifact=" + this.id + ", loader=" + null);
        }
        return null;
    }

    protected String findImportedLibrary(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findImportedLibrary", "name=" + name + ", artifact=" + this.id);
        }
        int n = this.imports.length;
        for (int i = 0; i < n; ++i) {
            String path = this.imports[i].findLocalLibrary(name);
            if (path == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "findImportedLibrary", "name=" + name + ", artifact=" + this.id + ", path=" + path);
            }
            return path;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findImportedLibrary", "name=" + name + ", artifact=" + this.id + ", path=" + null);
        }
        return null;
    }

    protected URL findImportedResource(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findImportedResource", "name=" + name + ", artifact=" + this.id);
        }
        int n = this.imports.length;
        for (int i = 0; i < n; ++i) {
            URL url = this.imports[i].findLocalResource(name);
            if (url == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "findImportedLibrary", "name=" + name + ", artifact=" + this.id + ", url=" + url);
            }
            return url;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findImportedLibrary", "name=" + name + ", artifact=" + this.id + ", url=" + null);
        }
        return null;
    }

    protected Enumeration findImportedResources(String name) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findImportedResources", "name=" + name + ", artifact=" + this.id);
        }
        int n = this.imports.length;
        for (int i = 0; i < n; ++i) {
            try {
                Enumeration en = this.imports[i].findLocalResources(name);
                if (en == null) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.exiting(this.getClass().getName(), "findImportedResources", "name=" + name + ", artifact=" + this.id + ", en=" + en);
                }
                return en;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findImportedResources", "name=" + name + ", artifact=" + this.id + ", en=" + null);
        }
        return null;
    }

    final synchronized void addImportedArtifactLoader(InfectionArtifactLoader importedLoader) {
        if (importedLoader == null) {
            return;
        }
        InfectionArtifactLoader[] oldImports = this.imports;
        int oldSize = oldImports.length;
        HashSet<InfectionArtifactLoader> set = new HashSet<InfectionArtifactLoader>();
        for (int c = 0; c < oldSize; ++c) {
            set.add(oldImports[c]);
        }
        set.add(importedLoader);
        int newSize = set.size();
        InfectionArtifactLoader[] newImports = set.toArray(new InfectionArtifactLoader[newSize]);
        this.imports = newImports;
    }

    final synchronized void dispose() {
        this.imports = new InfectionArtifactLoader[0];
    }

    public String toString() {
        return super.toString() + "[" + this.id + "]";
    }

    public final Object getId() {
        return this.id;
    }

    protected static class MultiPackageImport
    implements PackageImport {
        private String packageName;
        private List imports;

        public MultiPackageImport(String packageName) {
            this.packageName = packageName;
            this.imports = new ArrayList();
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        protected void addImport(PackageImport imp) {
            if (imp != null && !this.imports.contains(imp)) {
                this.imports.add(imp);
            }
        }

        protected void removeImport(PackageImport imp) {
            this.imports.remove(imp);
        }

        @Override
        public ClassLoader findClass(String classname) {
            int n = this.imports.size();
            for (int c = 0; c < n; ++c) {
                PackageImport imp = (PackageImport)this.imports.get(c);
                ClassLoader loader = imp.findClass(classname);
                if (loader == null) continue;
                return loader;
            }
            return null;
        }
    }

    protected static class SinglePackageImport
    implements PackageImport {
        private String packageName;
        private InfectionArtifactLoader loader;

        public SinglePackageImport(String packageName, InfectionArtifactLoader loader) {
            this.packageName = packageName;
            this.loader = loader;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        final InfectionArtifactLoader getLoader() {
            return this.loader;
        }

        @Override
        public ClassLoader findClass(String classname) {
            return this.loader.findLocalClass(classname);
        }
    }

    public static interface PackageImport {
        public String getPackageName();

        public ClassLoader findClass(String var1);
    }
}

