/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactLibPathEntry;
import com.spacekiller.infection.Debug;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionArtifactLoader;
import com.spacekiller.infection.InfectionEnhancement;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionRuntime;
import com.spacekiller.infection.InfectionRuntimeFacade;
import com.spacekiller.infection.InfectionRuntimeListener;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.load.ArtifactClassLoader;
import com.spacekiller.infection.load.ArtifactLoader;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.swing.InfectionRuntimeLoggingEditor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.channels.FileLock;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class InfectionRuntimeImpl
implements InfectionRuntime {
    private static final Logger logger = Logger.getLogger(InfectionRuntimeImpl.class.getName());
    public static final int PANEL_LICENSE = 1;
    public static final int PANEL_LOCATION = 100;
    public static final int PANEL_SITES = 110;
    public static final int PANEL_INSTANCE_MAIN = 200;
    public static final int PANEL_INSTANCE_JAVA_RUNTIME_WIZARD = 209;
    public static final int PANEL_INSTANCE_ARTIFACTS = 210;
    public static final int PANEL_INSTANCE_ADVANCED = 290;
    private Infection infection;
    private InfectionRuntimeFacade facade;
    private Thread instanceShutdownHook;
    private InfectionRuntimeListener infectionRuntimeListener;
    private String classLoaderPolicy = "system";
    private File infectionIndexFile;
    private InfectionInstallation installation;
    private InfectionIndex infectionIndex;
    private InfectionInstance infectionInstance;
    private String infectionClassPath;
    private File workingDir;
    private File dataDir;
    private File logDir;
    private File configDir;
    private File tempDir;
    private File lockFile;
    private RandomAccessFile lockRaf;
    private FileLock lock;
    private List artifactLoaders;
    private ClassLoader launcherClassLoader;
    private Class launcherClass;
    private boolean running = false;
    private String[] mainArgs;
    private Map properties;
    private double startupProgress;
    private boolean isShutdownInProgress;
    private File logFile;
    private OutputStream logOutputStream;
    private boolean debugReferenceEnabled = true;
    private Set enhancements;
    private Window loggingEditorWindow;
    private Set globalHandlers;

    protected InfectionRuntimeImpl(Infection infection, File infectionIndexFile, InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, File workingDir, String[] mainArgs, Map properties) {
        this.infection = infection;
        this.mainArgs = mainArgs;
        if (properties == null) {
            properties = new HashMap();
        }
        this.properties = properties;
        this.infectionIndexFile = infectionIndexFile;
        this.facade = new InfectionRuntimeFacade(this);
        this.setInstallation(installation);
        this.setInfectionIndex(index);
        this.setInfectionInstance(instance);
        this.setWorkingDir(workingDir);
        this.setDataDir(instance.getDataDir());
        this.setLogDir(instance.getLogDir());
        this.setConfigDir(instance.getConfigDir());
        this.setTempDir(instance.getTempDir());
        this.artifactLoaders = new ArrayList();
        this.globalHandlers = new HashSet();
        this.checkConfig();
    }

    InfectionRuntimeFacade getFacade() {
        return this.facade;
    }

    protected void checkConfig() {
        if (this.workingDir == null) {
            throw new NullPointerException("workingDir");
        }
        if (this.logDir == null) {
            throw new NullPointerException("logDir");
        }
        if (this.configDir == null) {
            throw new NullPointerException("configDir");
        }
    }

    @Override
    public void closeSplashWindow() {
        this.infection.closeSplashWindow();
    }

    @Override
    public String getClassPath() {
        return this.infectionClassPath;
    }

    private void setClassPath(String infectionClassPath) {
        this.infectionClassPath = infectionClassPath;
    }

    protected boolean shutdownNormally() throws Throwable {
        InfectionRuntimeListener l = this.getInfectionRuntimeListener();
        if (l == null) {
            return true;
        }
        return l.shutdownNormally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Throwable {
        if (!this.isRunning()) {
            return;
        }
        if (this.isShutdownInProgress) {
            return;
        }
        InfectionRuntimeImpl infectionRuntimeImpl = this;
        synchronized (infectionRuntimeImpl) {
            this.setShutdownInProgress(true);
            logger.fine("Runtime shutdown: " + this);
            Thread hook = this.instanceShutdownHook;
            if (hook != null) {
                this.instanceShutdownHook = null;
                if (!hook.isAlive()) {
                    logger.finer("Invoke instance shutdown hook: " + hook);
                    hook.start();
                    hook.join();
                    logger.finer("Instance shutdown completed.");
                }
            }
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
            if (this.lockRaf != null) {
                this.lockRaf.close();
                this.lockRaf = null;
            }
            if (this.lockFile != null) {
                this.lockFile.delete();
                this.lockFile = null;
            }
            this.launcherClass = null;
            this.launcherClassLoader = null;
            if (this.loggingEditorWindow != null) {
                this.loggingEditorWindow.dispose();
            }
            Iterator i = this.artifactLoaders.iterator();
            while (i.hasNext()) {
                InfectionArtifactLoader loader = (InfectionArtifactLoader)i.next();
                boolean initialized = loader.isClassLoaderInitialized();
                logger.fine("Dispose ArtifactLoader: " + loader + " => initialized=" + initialized);
                i.remove();
                loader.dispose();
            }
            this.infection.shutdown(this);
        }
    }

    @Override
    public synchronized void exit(int exitCode) throws Throwable {
        this.shutdown();
        this.infection.exit(exitCode);
    }

    @Override
    public void setShutdownHook(Thread waitFor) {
        this.instanceShutdownHook = waitFor;
    }

    @Override
    public String getClassLoaderPolicy() {
        return this.classLoaderPolicy;
    }

    protected void setClassLoaderPolicy(String classLoaderPolicy) {
        this.classLoaderPolicy = classLoaderPolicy;
    }

    protected InfectionIndex getInfectionIndex() {
        return this.infectionIndex;
    }

    protected void setInfectionIndex(InfectionIndex infectionIndex) {
        this.infectionIndex = infectionIndex;
    }

    protected InfectionInstance getInfectionInstance() {
        return this.infectionInstance;
    }

    protected void setInfectionInstance(InfectionInstance infectionInstance) {
        this.infectionInstance = infectionInstance;
    }

    protected Class getLauncherClass() {
        return this.launcherClass;
    }

    protected void setLauncherClass(Class launcherClass) {
        this.launcherClass = launcherClass;
    }

    protected ClassLoader getLauncherClassLoader() {
        return this.launcherClassLoader;
    }

    protected void setLauncherClassLoader(ClassLoader launcherClassLoader) {
        this.launcherClassLoader = launcherClassLoader;
    }

    protected boolean startPlatform(File infectionIndexFile, InfectionIndex index, InfectionInstance instance) throws Throwable {
        String path;
        Logger log = logger;
        boolean info = log.isLoggable(Level.INFO);
        boolean fine = log.isLoggable(Level.FINE);
        boolean finer = log.isLoggable(Level.FINER);
        if (fine) {
            log.fine("Index File: " + infectionIndexFile);
        }
        File infectionIndexDir = infectionIndexFile.getParentFile();
        if (finer) {
            log.finer("Index Directory: " + infectionIndexDir);
        }
        if (finer) {
            log.finer("Instance: " + instance);
        }
        File instanceFile = instance.getInstanceFile();
        if (fine) {
            log.fine("Instance File: " + instanceFile);
        }
        File instanceHome = instanceFile == null ? null : instanceFile.getParentFile();
        String instanceHomePath = ".";
        if (instanceHome != null) {
            instanceHomePath = instanceHome.getAbsolutePath();
        }
        if (fine) {
            log.fine("Instance Home: " + instanceHomePath);
        }
        File instanceLockFile = new File("instance.lock");
        try {
            if (instanceLockFile.exists() && !instanceLockFile.delete()) {
                throw new Exception("Instance may be locked by another process. Cannot delete lock file: " + instanceLockFile);
            }
            this.lockFile = instanceLockFile;
            this.lockRaf = new RandomAccessFile(this.lockFile, "rw");
            this.lock = this.lockRaf.getChannel().lock();
            if (fine) {
                log.fine("Instance locked successfully: " + this.lockFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            ErrorDialog.showErrorDialog(e, "Instance is locked by another process");
            Infection.getInstance().openUpdateManager(this.getFacade());
            return false;
        }
        int numArt = instance.getArtifactCount();
        ArrayList<ArtifactRuntime> artifactRuntimes = new ArrayList<ArtifactRuntime>(numArt + 10);
        ArrayList<File> classPathFiles = new ArrayList<File>(numArt + 10);
        for (int c = 0; c < numArt; ++c) {
            File workDir;
            File configDir;
            String artVersion;
            Artifact fact = instance.getArtifactAt(c);
            if (fact == null) continue;
            String artName = fact.getName();
            Artifact art = index.getArtifact(artName, artVersion = fact.getVersion());
            if (art == null) {
                String msg = "Artifact not found: " + fact;
                log.log(Level.SEVERE, msg);
                Infection.getInstance().openUpdateManager(this);
                return false;
            }
            path = art.getPath();
            ArrayList<URL> classPathList = new ArrayList<URL>();
            ArrayList<File> libPathList = new ArrayList<File>();
            File artFile = new File(path);
            if ((artFile = InfectionUtil.getAbsoluteFile(artFile, infectionIndexDir)).exists()) {
                URL artUrl = InfectionUtil.getFileURL(artFile);
                classPathFiles.add(artFile);
                classPathList.add(artUrl);
            } else {
                log.warning("WARNING: Artifact file not found: " + artFile);
            }
            File artDir = artFile.getParentFile();
            int artCPs = art.getClassPathEntryCount();
            for (int k = 0; k < artCPs; ++k) {
                String artCP = art.getClassPathEntryAt(k);
                File f = new File(artDir, artCP);
                if (!f.exists()) continue;
                URL url = InfectionUtil.getFileURL(f);
                classPathFiles.add(f);
                classPathList.add(url);
            }
            int artLPs = art.getLibPathEntryCount();
            for (int k = 0; k < artLPs; ++k) {
                File dir;
                String libArch;
                String libOs;
                ArtifactLibPathEntry entry = art.getLibPathEntryAt(k);
                String artLP = entry.getDirectory();
                if (artLP == null || (libOs = entry.getOs()) != null && libOs.length() > 0 && !InfectionRuntimeImpl.matchesLocalOsName(libOs) || (libArch = entry.getArch()) != null && libArch.length() > 0 && !InfectionRuntimeImpl.matchesLocalOsArch(libArch) || !(dir = new File(artDir, artLP)).exists() || !dir.isDirectory()) continue;
                libPathList.add(dir);
            }
            ArrayList<FilePermission> artPermList = new ArrayList<FilePermission>();
            artPermList.add(new FilePermission(artDir.getPath() + "/-", "read"));
            if (infectionIndexDir != null) {
                artPermList.add(new FilePermission(infectionIndexDir.getPath() + "/-", "read"));
            }
            if ((configDir = instance.getConfigDir()) != null) {
                artPermList.add(new FilePermission(configDir.getPath() + "/-", "read"));
            }
            if ((workDir = instance.getWorkingDir()) != null) {
                artPermList.add(new FilePermission(workDir.getPath() + "/-", "read"));
            }
            Permission[] artPerms = new Permission[artPermList.size()];
            artPerms = artPermList.toArray(artPerms);
            URL[] classPath = new URL[classPathList.size()];
            classPath = classPathList.toArray(classPath);
            File[] libPath = new File[libPathList.size()];
            libPath = libPathList.toArray(libPath);
            String id = "Artifact:" + artName + "-" + artVersion;
            ArtifactRuntime ar = new ArtifactRuntime(id, fact, classPath, libPath, artPerms);
            artifactRuntimes.add(ar);
        }
        ArrayList<URL> customClassPathURLList = new ArrayList<URL>();
        int numCP = instance.getClassPathCount();
        if (numCP > 0) {
            for (int c = 0; c < numCP; ++c) {
                String path2 = instance.getClassPathAt(c);
                File f = new File(path2);
                if (!f.exists()) {
                    log.warning("WARNING: custom classpath entry not found: " + f);
                }
                URL url = InfectionUtil.getFileURL(f);
                classPathFiles.add(f);
                customClassPathURLList.add(url);
            }
        }
        ArrayList<File> customLibPathList = new ArrayList<File>();
        int numLP = instance.getLibraryPathCount();
        if (numLP > 0) {
            for (int k = 0; k < numLP; ++k) {
                path = instance.getLibraryPathAt(k);
                File dir = new File(path);
                if (!dir.exists() || !dir.isDirectory()) continue;
                customLibPathList.add(dir);
            }
        }
        Artifact nullArtifact = null;
        URL[] customClassPathURLs = new URL[customClassPathURLList.size()];
        customClassPathURLs = customClassPathURLList.toArray(customClassPathURLs);
        File[] customLibPathDirs = new File[customLibPathList.size()];
        customLibPathDirs = customLibPathList.toArray(customLibPathDirs);
        Permission[] customPerms = new Permission[]{};
        String customId = "Custom";
        ArtifactRuntime customArtifactRuntime = new ArtifactRuntime(customId, nullArtifact, customClassPathURLs, customLibPathDirs, customPerms);
        artifactRuntimes.add(customArtifactRuntime);
        if (finer) {
            for (ArtifactRuntime artifactRuntime : artifactRuntimes) {
                int i;
                if (artifactRuntime == null) continue;
                Object artId = artifactRuntime.getId();
                Artifact artifact = artifactRuntime.getArtifact();
                URL[] cpURLs = artifactRuntime.getClassPath();
                File[] libDirs = artifactRuntime.getLibPath();
                log.finer("Artifact: " + artId + " => " + artifact);
                for (i = 0; i < cpURLs.length; ++i) {
                    log.finer(" - Class path: " + cpURLs[i]);
                }
                for (i = 0; i < libDirs.length; ++i) {
                    log.finer(" - Library path: " + libDirs[i]);
                }
            }
        }
        Properties customProps = new Properties();
        int propCount = instance.getPropertyCount();
        for (int c = 0; c < propCount; ++c) {
            String key = instance.getPropertyKeyAt(c);
            String value = instance.getPropertyValueAt(c);
            if (key == null || value == null) continue;
            customProps.setProperty(key, value);
        }
        String launcherClassName = null;
        String classLoaderPolicy = null;
        if (!customProps.isEmpty()) {
            Properties currentSystemProps = System.getProperties();
            Enumeration<Object> en = customProps.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = customProps.getProperty(key);
                if (key == null || (key = key.trim()).length() < 1) continue;
                if (value == null) {
                    value = "";
                }
                value = value.trim();
                if (currentSystemProps.containsKey(key)) continue;
                if (key.equals("infection.runtime.log.level")) {
                    if (value == null) continue;
                    this.properties.put(key, value);
                    continue;
                }
                System.setProperty(key, value);
                currentSystemProps.setProperty(key, value);
            }
        }
        if (launcherClassName == null && (launcherClassName = System.getProperty("infection.mainclass")) != null && launcherClassName.trim().length() < 1) {
            launcherClassName = null;
        }
        if (classLoaderPolicy == null) {
            classLoaderPolicy = System.getProperty("infection.classloader");
        }
        boolean useSystemClassLoader = false;
        boolean useMultiClassLoaders = false;
        if (classLoaderPolicy != null) {
            if ((classLoaderPolicy = classLoaderPolicy.trim()).equalsIgnoreCase("system")) {
                useSystemClassLoader = true;
                useMultiClassLoaders = false;
            }
            if (classLoaderPolicy.equalsIgnoreCase("single")) {
                useSystemClassLoader = false;
                useMultiClassLoaders = false;
            }
            if (classLoaderPolicy.equalsIgnoreCase("multi")) {
                useSystemClassLoader = false;
                useMultiClassLoaders = true;
            }
        }
        if (useSystemClassLoader) {
            if (fine) {
                log.fine("Using system classloader...");
            }
            this.setClassLoaderPolicy("system");
            this.setLauncherClassLoader(this.infection.getMainClassLoader());
            this.setClassPath(this.infection.getMainClassPath());
        } else {
            if (!useMultiClassLoaders) {
                if (fine) {
                    log.fine("Using single classloader...");
                }
                this.setClassLoaderPolicy("single");
            } else {
                if (fine) {
                    log.fine("Using multiple classloaders...");
                }
                this.setClassLoaderPolicy("multi");
            }
            this.initClassLoaders(useMultiClassLoaders, artifactRuntimes, classPathFiles);
        }
        ClassLoader launcherLoader = this.getLauncherClassLoader();
        if (fine) {
            log.fine("Platform ClassLoader: " + launcherLoader);
        }
        if (launcherLoader == null) {
            throw new Exception("Missing Platform ClassLoader!");
        }
        String fullClassPath = this.getClassPath();
        if (fine) {
            log.fine("Instance Classpath: " + fullClassPath);
        }
        String[] mainArgs = this.mainArgs;
        Class<?> mainClass = null;
        Method mainMethod = null;
        if (!(launcherClassName != null && launcherClassName.length() >= 1 || (launcherClassName = this.getDistributionProperty("mainClass")) != null && launcherClassName.length() >= 1)) {
            launcherClassName = "com.spacekiller.infection.platform.InfectionPlatform";
        }
        if (info) {
            log.info("Main class: " + launcherClassName);
        }
        try {
            mainClass = launcherLoader.loadClass(launcherClassName);
            if (mainClass == null) {
                throw new ClassNotFoundException(launcherClassName);
            }
            if (finer) {
                log.finer("Loaded main class: " + mainClass);
            }
            if (!Modifier.isStatic((mainMethod = mainClass.getMethod("main", String[].class)).getModifiers())) {
                throw new RuntimeException("Invalid main class: " + mainClass.getName());
            }
            if (finer) {
                log.finer("Main method: " + mainMethod);
            }
        }
        catch (ClassNotFoundException e) {
            log.info("Main class not found: " + launcherClassName);
            this.handleLauncherNotFound(e);
            return false;
        }
        catch (Throwable e) {
            String msg = "Error while loading main class: " + launcherClassName;
            log.log(Level.SEVERE, msg, e);
            this.handleLauncherNotFound(e);
            return false;
        }
        try {
            if (fine) {
                log.fine("Running main class: " + mainClass.getName());
            }
            if (info) {
                log.info("------------------------------------------------------------------------");
            }
            try {
                if (finer) {
                    log.finer("launcherLoader=" + launcherLoader + ", current=" + Thread.currentThread().getContextClassLoader());
                }
                Thread.currentThread().setContextClassLoader(launcherLoader);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            mainMethod.invoke(null, new Object[]{mainArgs});
            return true;
        }
        catch (Throwable e) {
            String msg = "Error while running main class: " + launcherClassName;
            log.log(Level.SEVERE, msg, e);
            throw e;
        }
    }

    protected void initClassLoaders(boolean multi, List artifactRuntimes, List classPathFiles) throws Exception {
        ClassLoader parentLoader = this.infection.getMainClassLoader();
        StringBuffer platPath = new StringBuffer();
        int num = classPathFiles.size();
        for (int c = 0; c < num; ++c) {
            File f = (File)classPathFiles.get(c);
            if (c > 0) {
                platPath.append(File.pathSeparator);
            }
            platPath.append(f.getPath());
        }
        this.setClassPath(platPath.toString());
        if (!multi) {
            ArrayList<URL> cpURLs = new ArrayList<URL>();
            ArrayList<String> lpDirs = new ArrayList<String>();
            ArrayList<Permission> perms = new ArrayList<Permission>();
            int numRuntimes = artifactRuntimes.size();
            for (int c = 0; c < numRuntimes; ++c) {
                Permission[] ps;
                File[] lp;
                ArtifactRuntime ar = (ArtifactRuntime)artifactRuntimes.get(c);
                URL[] cp = ar.getClassPath();
                if (cp != null) {
                    for (int k = 0; k < cp.length; ++k) {
                        cpURLs.add(cp[k]);
                    }
                }
                if ((lp = ar.getLibPath()) != null) {
                    for (int k = 0; k < lp.length; ++k) {
                        File dir = lp[k];
                        if (dir == null) continue;
                        lpDirs.add(dir.getPath());
                    }
                }
                if ((ps = ar.getDefaultPermissions()) == null) continue;
                for (int p = 0; p < ps.length; ++p) {
                    perms.add(ps[p]);
                }
            }
            String id = "Infection";
            URL[] urlArray = new URL[cpURLs.size()];
            urlArray = cpURLs.toArray(urlArray);
            String[] singleLibPath = new String[lpDirs.size()];
            singleLibPath = lpDirs.toArray(singleLibPath);
            Permission[] permArray = new Permission[perms.size()];
            permArray = perms.toArray(permArray);
            InfectionArtifactLoader artifactLoader = new InfectionArtifactLoader(id, urlArray, singleLibPath, parentLoader, permArray);
            ArtifactClassLoader singleLoader = artifactLoader.getClassLoader();
            this.debugReference(artifactLoader);
            this.debugReference(singleLoader);
            this.artifactLoaders.add(artifactLoader);
            this.setLauncherClassLoader(singleLoader);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Single ClassLoader: " + singleLoader);
            }
            return;
        }
        ArrayList<InfectionArtifactLoader> artifactLoaderList = new ArrayList<InfectionArtifactLoader>();
        int numRuntimes = artifactRuntimes.size();
        for (int c = 0; c < numRuntimes; ++c) {
            ArtifactRuntime ar = (ArtifactRuntime)artifactRuntimes.get(c);
            URL[] cp = ar.getClassPath();
            File[] libPath = ar.getLibPath();
            ArrayList<String> lpDirs = new ArrayList<String>();
            if (libPath != null) {
                for (int k = 0; k < libPath.length; ++k) {
                    File dir = libPath[k];
                    if (dir == null) continue;
                    lpDirs.add(dir.getPath());
                }
            }
            Object id = ar.getId();
            URL[] urlArray = cp;
            String[] artifactLibPath = new String[lpDirs.size()];
            artifactLibPath = lpDirs.toArray(artifactLibPath);
            Permission[] permArray = ar.getDefaultPermissions();
            InfectionArtifactLoader artifactLoader = new InfectionArtifactLoader(id, urlArray, artifactLibPath, parentLoader, permArray);
            artifactLoaderList.add(artifactLoader);
            this.debugReference(artifactLoader);
            this.artifactLoaders.add(artifactLoader);
        }
        int numLoaders = artifactLoaderList.size();
        for (int c = 0; c < numLoaders; ++c) {
            InfectionArtifactLoader delegate = (InfectionArtifactLoader)artifactLoaderList.get(c);
            for (int k = 0; k < numLoaders; ++k) {
                InfectionArtifactLoader importDelegate;
                if (k == c || (importDelegate = (InfectionArtifactLoader)artifactLoaderList.get(k)) == null) continue;
                delegate.addImportedArtifactLoader(importDelegate);
            }
        }
        String id = "infection";
        URL[] urlArray = new URL[]{};
        String[] libpath = new String[]{};
        Permission[] permArray = new Permission[]{};
        InfectionArtifactLoader launcherDelegate = new InfectionArtifactLoader(id, urlArray, libpath, parentLoader, permArray);
        ArtifactClassLoader launcherClassLoader = launcherDelegate.getClassLoader();
        this.setLauncherClassLoader(launcherClassLoader);
        for (int k = 0; k < numLoaders; ++k) {
            InfectionArtifactLoader importDelegate = (InfectionArtifactLoader)artifactLoaderList.get(k);
            if (importDelegate == null) continue;
            launcherDelegate.addImportedArtifactLoader(importDelegate);
        }
        this.debugReference(launcherClassLoader);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Multiple ClassLoaders: " + numLoaders);
        }
    }

    @Override
    public synchronized void startup() throws Throwable {
        if (this.isRunning()) {
            throw new Exception("Infection runtime instance is already running: " + this);
        }
        Thread thread = new Thread(new Startup());
        this.infection.registerInfectionRuntime(thread, this);
        this.debugReference(this);
        this.setRunning(true);
        thread.start();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    protected void handleLauncherNotFound(Throwable error) throws Throwable {
        this.shutdown();
        boolean showErrorDialog = true;
        if (error instanceof ClassNotFoundException) {
            File instanceFile = null;
            if (this.infectionInstance != null) {
                instanceFile = this.infectionInstance.getInstanceFile();
            }
            boolean instanceExists = false;
            if (instanceFile != null) {
                instanceExists = instanceFile.exists();
            }
            if (!instanceExists) {
                showErrorDialog = false;
            }
        }
        if (showErrorDialog) {
            ErrorDialog.showErrorDialog(error);
        }
        boolean done = this.infection.installPlatform(this, 200);
        logger.fine("InfectionDialog closed[handleLauncherNotFound]: done=" + done);
        if (!done) {
            logger.fine("Installation cancelled by user.");
            throw new RuntimeException("Installation cancelled by user");
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    @Override
    public Map getProperties() {
        HashMap rc = new HashMap();
        rc.putAll(this.properties);
        return rc;
    }

    @Override
    public double getStartupProgress() {
        return this.startupProgress;
    }

    @Override
    public void setStartupProgress(double newStartupProgress) {
        if (this.startupProgress == newStartupProgress) {
            return;
        }
        this.startupProgress = newStartupProgress;
        Infection.setStartupProgress(newStartupProgress);
    }

    protected File getInstanceConfigFile() {
        return this.infectionInstance == null ? null : this.infectionInstance.getInstanceFile();
    }

    protected File getInfectionIndexFile() {
        return this.infectionIndexFile;
    }

    public boolean isShutdownInProgress() {
        return this.isShutdownInProgress;
    }

    protected void setShutdownInProgress(boolean isShutdownInProgress) {
        this.isShutdownInProgress = isShutdownInProgress;
    }

    protected InfectionRuntimeListener getInfectionRuntimeListener() {
        return this.infectionRuntimeListener;
    }

    @Override
    public void setInfectionRuntimeListener(InfectionRuntimeListener infectionRuntimeListener) {
        this.infectionRuntimeListener = infectionRuntimeListener;
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    protected void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    protected File getLogFile() {
        return this.logFile;
    }

    protected void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    protected OutputStream getLogOutputStream() {
        return this.logOutputStream;
    }

    protected void setLogOutputStream(OutputStream logOutputStream) {
        this.logOutputStream = logOutputStream;
    }

    @Override
    public File getConfigDir() {
        return this.configDir;
    }

    protected void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    @Override
    public File getLogDir() {
        return this.logDir;
    }

    protected void setLogDir(File logDir) {
        this.logDir = logDir;
    }

    @Override
    public void debugReference(Object obj) {
        if (!this.debugReferenceEnabled) {
            return;
        }
        Debug.debugReference(obj);
    }

    @Override
    public Iterator getDebugReferences() {
        if (!this.debugReferenceEnabled) {
            return null;
        }
        return Debug.getDebugReferences();
    }

    @Override
    public void dumpDebugReferences(PrintStream out) {
        if (!this.debugReferenceEnabled) {
            return;
        }
        Debug.dumpDebugReferences(out);
    }

    @Override
    public void clearDebugReferences() {
        if (!this.debugReferenceEnabled) {
            return;
        }
        Debug.clearDebugReferences();
    }

    @Override
    public void registerInfectionEnhancement(InfectionEnhancement impl) {
        if (impl == null) {
            return;
        }
        if (this.enhancements == null) {
            this.enhancements = new TreeSet(new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    double prio1;
                    InfectionEnhancement e0 = (InfectionEnhancement)arg0;
                    InfectionEnhancement e1 = (InfectionEnhancement)arg1;
                    double prio0 = e0.getPriority();
                    if (prio0 != (prio1 = e1.getPriority())) {
                        return prio0 < prio1 ? 1 : -1;
                    }
                    return 1;
                }
            });
        }
        this.enhancements.add(impl);
    }

    @Override
    public void unregisterInfectionEnhancement(InfectionEnhancement impl) {
        if (this.enhancements == null) {
            return;
        }
        this.enhancements.remove(impl);
    }

    protected InfectionEnhancement.DownloadManagerV1 getDownloadManagerV1() {
        if (this.enhancements == null) {
            return null;
        }
        for (InfectionEnhancement e : this.enhancements) {
            InfectionEnhancement.DownloadManagerV1 rc = e.getDownloadManagerV1();
            if (rc == null) continue;
            return rc;
        }
        return null;
    }

    protected InfectionEnhancement.XMLValidatorV1 getXMLValidatorV1() {
        if (this.enhancements != null) {
            for (InfectionEnhancement e : this.enhancements) {
                InfectionEnhancement.XMLValidatorV1 rc = e.getXMLValidatorV1();
                if (rc == null) continue;
                return rc;
            }
        }
        return this.infection.getXMLValidatorV1();
    }

    @Override
    public void validateInfectionXML(InputStream in) throws Exception {
        InfectionEnhancement.XMLValidatorV1 validator = this.getXMLValidatorV1();
        if (validator == null) {
            return;
        }
        validator.validateInfectionXML(in);
    }

    @Override
    public File getTempDir() {
        return this.tempDir;
    }

    protected void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    protected void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    @Override
    public ArtifactLoader[] getArtifactLoaders() {
        return this.artifactLoaders.toArray(new ArtifactLoader[this.artifactLoaders.size()]);
    }

    @Override
    public ClassLoader getClassLoader(ArtifactLoader artifactLoader, boolean initialize) {
        if (artifactLoader != null && artifactLoader instanceof InfectionArtifactLoader) {
            InfectionArtifactLoader loader = (InfectionArtifactLoader)artifactLoader;
            return loader.getClassLoader(initialize);
        }
        return null;
    }

    @Override
    public ClassLoader getClassLoader(ArtifactLoader artifactLoader) {
        return this.getClassLoader(artifactLoader, true);
    }

    @Override
    public Package[] getPackages(ArtifactLoader artifactLoader) {
        boolean init = false;
        ClassLoader loader = this.getClassLoader(artifactLoader, init);
        if (loader != null && loader instanceof ArtifactClassLoader) {
            ArtifactClassLoader acl = (ArtifactClassLoader)loader;
            return acl.getPackages();
        }
        return new Package[0];
    }

    @Override
    public void openInstanceConfig() throws Exception {
        this.infection.openInstanceConfig(this, 200);
    }

    @Override
    public void openUpdateManager() throws Exception {
        this.infection.openUpdateManager(this);
    }

    @Override
    public boolean isAutoSoftwareUpdateEnabled() throws Exception {
        return this.infection.isAutoSoftwareUpdateEnabled();
    }

    @Override
    public void startAutoSoftwareUpdate(boolean promptCheck, boolean promptDownload, boolean promptApply) throws Exception {
        boolean unattended = false;
        this.infection.startAutoSoftwareUpdate(this, promptCheck, promptDownload, promptApply, unattended);
    }

    @Override
    public void openLoggingConfigPanel() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                InfectionRuntimeImpl.this.showLoggingConfigPanel();
            }
        }).start();
    }

    private void showLoggingConfigPanel() {
        if (this.loggingEditorWindow != null && this.loggingEditorWindow.isVisible()) {
            this.loggingEditorWindow.toFront();
            return;
        }
        InfectionRuntimeLoggingEditor editor = new InfectionRuntimeLoggingEditor();
        editor.setRuntime(this);
        editor.setInstallation(this.installation);
        editor.setIndex(this.infectionIndex);
        editor.setInstance(this.infectionInstance);
        editor.setPreferredSize(new Dimension(500, 480));
        Image iconImage = null;
        try {
            iconImage = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/config_16.gif")).getImage();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        JFrame frame = new JFrame("Logging Configuration");
        frame.setContentPane(editor);
        frame.setIconImage(iconImage);
        frame.pack();
        Infection.centerWindow(frame);
        frame.setVisible(true);
        this.loggingEditorWindow = frame;
        editor.refreshAsync();
    }

    protected InfectionInstallation getInstallation() {
        return this.installation;
    }

    protected void setInstallation(InfectionInstallation installation) {
        this.installation = installation;
    }

    @Override
    public String getApplicationName() {
        String s = this.infection.getDistributionProperty("name");
        return s == null ? "unknown" : s;
    }

    @Override
    public String getApplicationTitle() {
        String s = this.infection.getDistributionProperty("title");
        return s == null ? "Unknown" : s;
    }

    @Override
    public String getApplicationVersion() {
        String s = this.infection.getDistributionProperty("version");
        return s == null ? "0.0" : s;
    }

    @Override
    public String getDistributionProperty(String key) {
        return this.infection.getDistributionProperty(key);
    }

    @Override
    public byte[] getDistributionResourceData(String key) throws IOException {
        return this.infection.getDistributionResourceData(key);
    }

    public static boolean matchesOsName(String osPrefix, String osName) {
        if (osPrefix == null) {
            return true;
        }
        if (osPrefix.length() < 1) {
            return true;
        }
        if (osName == null) {
            return false;
        }
        return osName.toLowerCase().startsWith(osPrefix.toLowerCase());
    }

    public static boolean matchesOsArch(String arch, String osArch) {
        if (arch == null) {
            return true;
        }
        if (arch.length() < 1) {
            return true;
        }
        if (osArch == null) {
            return false;
        }
        return osArch.equalsIgnoreCase(arch);
    }

    public static boolean matchesLocalOsName(String osPrefix) {
        String osName = System.getProperty("os.name");
        return InfectionRuntimeImpl.matchesOsName(osPrefix, osName);
    }

    public static boolean matchesLocalOsArch(String arch) {
        String osArch = System.getProperty("os.arch");
        return InfectionRuntimeImpl.matchesOsArch(arch, osArch);
    }

    @Override
    public Handler getLogHandler() {
        return this.infection.getLogHandler();
    }

    @Override
    public void registerGlobalHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (this.globalHandlers.add(handler)) {
            this.infection.registerCustomHandler(handler);
        }
    }

    @Override
    public void unregisterGlobalHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        if (this.globalHandlers.remove(handler)) {
            this.infection.unregisterCustomHandler(handler);
        }
    }

    @Override
    public boolean showJavaRuntimeWizard(Object invoker) {
        try {
            this.infection.openInstanceConfig(this, 209);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    protected class ArtifactRuntime {
        private Object id;
        private Artifact artifact;
        private URL[] classPath;
        private File[] libPath;
        private Permission[] defaultPermissions;

        public ArtifactRuntime(Object id, Artifact artifact, URL[] classPath, File[] libPath, Permission[] defaultPermissions) {
            this.setId(id);
            this.setArtifact(artifact);
            this.setClassPath(classPath);
            this.setLibPath(libPath);
            this.setDefaultPermissions(defaultPermissions);
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        private void setArtifact(Artifact artifact) {
            this.artifact = artifact;
        }

        public URL[] getClassPath() {
            return this.classPath;
        }

        private void setClassPath(URL[] classPath) {
            this.classPath = classPath;
        }

        public File[] getLibPath() {
            return this.libPath;
        }

        private void setLibPath(File[] libPath) {
            this.libPath = libPath;
        }

        public Object getId() {
            return this.id;
        }

        private void setId(Object id) {
            this.id = id;
        }

        private Permission[] getDefaultPermissions() {
            return this.defaultPermissions;
        }

        private void setDefaultPermissions(Permission[] defaultPermissions) {
            this.defaultPermissions = defaultPermissions;
        }
    }

    private class Startup
    implements Runnable {
        @Override
        public void run() {
            boolean done = false;
            try {
                done = InfectionRuntimeImpl.this.startPlatform(InfectionRuntimeImpl.this.infectionIndexFile, InfectionRuntimeImpl.this.infectionIndex, InfectionRuntimeImpl.this.infectionInstance);
            }
            catch (Throwable e) {
                Infection.handleException(e);
            }
            if (!done) {
                try {
                    InfectionRuntimeImpl.this.shutdown();
                }
                catch (Throwable e2) {
                    Infection.handleException(e2);
                }
                InfectionRuntimeImpl.this.setRunning(false);
                try {
                    InfectionRuntimeImpl.this.infection.exit(0);
                }
                catch (Exception e2) {
                    Infection.handleException(e2);
                }
            }
        }
    }
}

