/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.cmd;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionAccess;
import com.spacekiller.infection.InfectionConst;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionInstaller;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionSelfTest;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.cmd.InfectionCommand;
import com.spacekiller.infection.cmd.InfectionCommandException;
import com.spacekiller.infection.cmd.InfectionCommandLine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InfectionCommandLineImpl
implements InfectionCommandLine,
InfectionConst {
    private static final Logger logger = Logger.getLogger(InfectionCommandLineImpl.class.getName());
    private Infection infection;
    private InfectionInstaller installer;
    private InfectionInstallation installation;
    private InfectionIndex index;
    private InfectionInstance instance;
    private URL infectionJarURL;
    private URL distributionJarURL;
    private InputStream stdin;
    private PrintStream stdout;
    private PrintStream stderr;
    private Map commands;
    private String promptTitle = "infect>";
    private int returnCode = 0;
    private boolean exitCommandShell = false;
    private int exitCode = -1;

    public InfectionCommandLineImpl(Infection infection, InfectionInstaller installer, InfectionInstallation installation, InfectionIndex index, InfectionInstance instance, InputStream stdin, PrintStream stdout, PrintStream stderr, URL infectionJarURL, URL distributionJarURL) {
        this.infection = infection;
        this.installer = installer;
        this.installation = installation;
        this.index = index;
        this.instance = instance;
        this.stdout = stdout;
        this.stderr = stderr;
        this.stdin = stdin;
        this.infectionJarURL = infectionJarURL;
        this.distributionJarURL = distributionJarURL;
        this.commands = new HashMap();
        this.initCommands();
    }

    protected String prompt() throws IOException {
        return this.prompt(null);
    }

    protected String prompt(String title) throws IOException {
        if (title != null) {
            this.stdout.print(title);
        }
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = this.stdin.read()) == 13) {
                continue;
            }
            if (ch == 10) break;
            buf.append((char)ch);
        }
        return buf.toString();
    }

    protected void printShellIntro() {
        String sepLine = "===============";
        this.println(sepLine);
        this.println("Infection Shell");
        this.println(sepLine);
    }

    protected void printShellInfo() {
        this.println("Type 'help' for command arguments or 'exit' to leave. ");
    }

    protected void println(String s) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(s);
        }
        this.stdout.println(s);
    }

    protected String[] parseCommand(String cmd) {
        StringTokenizer tok = new StringTokenizer(cmd, " ", false);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            list.add(s);
        }
        String[] rc = new String[list.size()];
        rc = list.toArray(rc);
        return rc;
    }

    protected void handleException(Throwable e) {
        logger.log(Level.SEVERE, e.getMessage(), e);
        this.stdout.println("-------------------------------------------------------------------------");
        this.stdout.println("Error: " + e.getMessage());
        this.stdout.println("-------------------------------------------------------------------------");
        e.printStackTrace(this.stdout);
        this.stdout.println("-------------------------------------------------------------------------");
    }

    @Override
    public synchronized int shell(String[] args) {
        this.printShellIntro();
        this.exitCommandShell = false;
        this.exitCode = -1;
        if (args != null && args.length > 0) {
            this.execute(args);
            this.println("");
        }
        this.printShellInfo();
        while (!this.exitCommandShell) {
            String cmd;
            this.println("");
            try {
                cmd = this.prompt(this.promptTitle);
            }
            catch (IOException e) {
                this.exitCode = 43;
                this.exitCommandShell = true;
                break;
            }
            String[] cmdArgs = this.parseCommand(cmd);
            if (cmdArgs.length <= 0) continue;
            this.returnCode = this.execute(cmdArgs);
        }
        return this.exitCode;
    }

    private void exit(int code) {
        this.exitCode = code;
        this.exitCommandShell = true;
    }

    @Override
    public synchronized int execute(String[] args) {
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        if (logger.isLoggable(Level.INFO)) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.promptTitle);
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(String.valueOf(args[i]));
            }
            logger.info(buf.toString());
        }
        try {
            this.invoke(args);
            return 0;
        }
        catch (InfectionCommandException e) {
            this.handleException(e);
            return e.getReturnCode();
        }
        catch (Throwable e) {
            this.handleException(e);
            return 42;
        }
    }

    protected void invoke(String[] args) throws InfectionCommandException {
        if (args == null) {
            throw new NullPointerException("args is null");
        }
        if (args.length < 1) {
            throw new InfectionCommandException(41, "No arguments specified");
        }
        String key = args[0];
        InfectionCommand command = (InfectionCommand)this.commands.get(key);
        if (command == null) {
            logger.severe("Invalid command: " + key);
            logger.info("Type 'help' to display list of possible commands.");
            throw new InfectionCommandException(41, "Invalid command: " + key);
        }
        String[] params = new String[args.length - 1];
        System.arraycopy(args, 1, params, 0, params.length);
        command.invoke(params);
    }

    protected void initCommands() {
        this.registerCommand(new ReturnCodeCommand());
        this.registerCommand(new ExitCommand());
        this.registerCommand(new HelpCommand());
        this.registerCommand(new VersionCommand());
        this.registerCommand(new MemoryCommand());
        this.registerCommand(new GcCommand());
        this.registerCommand(new SelfTestCommand());
        this.registerCommand(new PropertiesCommand());
        this.registerCommand(new InfoCommand());
        this.registerCommand(new ListCommand());
        this.registerCommand(new CleanupCommand());
        this.registerCommand(new BundleCommand());
        this.registerCommand(new UpgradeCommand());
    }

    protected void registerCommand(InfectionCommand command) {
        String[] aliases;
        if (command == null) {
            throw new IllegalArgumentException("Command is null");
        }
        String name = command.getName();
        if (name != null && name.length() > 0) {
            if (this.commands.containsKey(name)) {
                logger.warning("Command already registered: " + name);
            } else {
                this.commands.put(name, command);
            }
        }
        if ((aliases = command.getAliases()) != null) {
            for (int i = 0; i < aliases.length; ++i) {
                String alias = aliases[i];
                if (alias == null || alias.length() <= 0) continue;
                if (this.commands.containsKey(alias)) {
                    logger.warning("Command already registered: " + alias);
                    continue;
                }
                this.commands.put(alias, command);
            }
        }
    }

    protected void printHelp() throws Exception {
        TreeMap<String, InfectionCommand> map = new TreeMap<String, InfectionCommand>();
        int maxCommandLen = 0;
        for (InfectionCommand command : this.commands.values()) {
            String name = command.getName();
            if (name == null) continue;
            map.put(name, command);
            if (name.length() <= maxCommandLen) continue;
            maxCommandLen = name.length();
        }
        String sep = this.lengthString('-', maxCommandLen) + "  " + this.lengthString('-', 30);
        this.println(sep);
        this.println(this.lengthString("Command", maxCommandLen) + "  " + "Description");
        this.println(sep);
        for (InfectionCommand command : map.values()) {
            String name = command.getName();
            String descr = command.getDescription();
            this.println(this.lengthString(name, maxCommandLen) + "  " + descr);
        }
    }

    protected void printVersion() throws Exception {
        InfectionAccess access = this.infection.getInfectionAccess();
        this.println("Infection version: " + access.getInfectionVersionInfoString());
        this.println("Java runtime: " + access.getJavaVersionInfoString());
        this.println("Operating system: " + access.getOperatingSystemInfoString());
    }

    protected void printJavaRuntimeInfo() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        this.println("Available processors: " + runtime.availableProcessors());
    }

    protected void printMemoryUsage() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        this.println("Memory: used=" + used + ", free=" + free + ", total=" + total + ", max=" + max);
    }

    protected void gc() throws Exception {
        this.printMemoryUsage();
        this.println("Running garbage collection...");
        long ms = -System.currentTimeMillis();
        Runtime.getRuntime().gc();
        this.println("Garbage collection completed in " + (ms += System.currentTimeMillis()) + " ms.");
        this.printMemoryUsage();
    }

    protected void performSelfTest() throws Exception {
        InfectionSelfTest.performSelfTest();
        this.println("Successful.");
    }

    protected void printProperties() throws Exception {
        Properties props = System.getProperties();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(props);
        for (Map.Entry me : map.entrySet()) {
            String k = (String)me.getKey();
            String v = (String)me.getValue();
            v = Infection.getSystemPropertyValueString(k, v);
            this.println("" + k + " = " + v);
        }
    }

    protected void printInfo() throws Exception {
        InfectionSite site;
        int i;
        this.printVersion();
        this.println("");
        this.printJavaRuntimeInfo();
        this.printMemoryUsage();
        this.println("");
        this.println("Index file: " + this.installation.getIndexFile());
        HashSet<String> artifactNames = new HashSet<String>();
        int artifactCount = this.index.getArtifactCount();
        for (int i2 = 0; i2 < artifactCount; ++i2) {
            Artifact art = this.index.getArtifactAt(i2);
            artifactNames.add(art.getName());
        }
        this.println("Installed artifacts: " + artifactNames.size());
        this.println("Installed versions:  " + artifactCount);
        int siteCount = this.index.getSiteCount();
        int activeSiteCount = 0;
        for (i = 0; i < siteCount; ++i) {
            site = this.index.getSiteAt(i);
            if (!site.isActive()) continue;
            ++activeSiteCount;
        }
        this.println("");
        this.println("Update sites: " + activeSiteCount);
        for (i = 0; i < siteCount; ++i) {
            site = this.index.getSiteAt(i);
            if (!site.isActive()) continue;
            this.println(" - " + site.getPath());
        }
        int instanceCount = this.index.getInstanceCount();
        this.println("");
        this.println("Instances: " + instanceCount);
        for (int i3 = 0; i3 < instanceCount; ++i3) {
            String instancePath = this.index.getInstancePathAt(i3);
            this.println(" - " + instancePath);
        }
    }

    protected void listInstalledArtifacts() throws Exception {
        int num = this.index.getArtifactCount();
        if (num > 0) {
            Artifact[] artifacts = new Artifact[num];
            for (int i = 0; i < num; ++i) {
                artifacts[i] = this.index.getArtifactAt(i);
            }
            this.listArtifacts(artifacts);
            this.println("");
        }
        this.println("Number of installed artifacts: " + num);
    }

    protected void listUnusedArtifacts() throws Exception {
        Artifact[] artifacts = this.installer.enumerateUnusedArtifacts(this.installation, this.index);
        int num = artifacts.length;
        if (num > 0) {
            this.listArtifacts(artifacts);
            this.println("");
        }
        this.println("Number of unused artifacts: " + num);
    }

    protected void listArtifacts(Artifact[] artifacts) throws Exception {
        int nameLen = 10;
        int verLen = 10;
        TreeMap artifactMap = new TreeMap();
        for (Artifact art : artifacts) {
            String name = art.getName();
            TreeMap<String, Artifact> versionMap = (TreeMap<String, Artifact>)artifactMap.get(name);
            if (versionMap == null) {
                versionMap = new TreeMap<String, Artifact>();
                artifactMap.put(name, versionMap);
            }
            String ver = art.getVersion();
            versionMap.put(ver, art);
            if (name != null) {
                nameLen = Math.max(nameLen, name.length());
            }
            if (ver == null) continue;
            verLen = Math.max(verLen, ver.length());
        }
        boolean printHeader = true;
        if (printHeader) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(this.lengthString('-', nameLen));
            sbuf.append(' ');
            sbuf.append(this.lengthString('-', verLen));
            String separatorLine = sbuf.toString();
            sbuf = new StringBuffer();
            sbuf.append(this.lengthString("Artifact", nameLen));
            sbuf.append(' ');
            sbuf.append(this.lengthString("Version", verLen));
            this.println(separatorLine);
            this.println(sbuf.toString());
            this.println(separatorLine);
        }
        for (TreeMap versionMap : artifactMap.values()) {
            for (Artifact art : versionMap.values()) {
                StringBuffer sbuf = new StringBuffer();
                String name = String.valueOf(art.getName());
                sbuf.append(this.lengthString(name, nameLen));
                sbuf.append(' ');
                String ver = String.valueOf(art.getVersion());
                sbuf.append(this.lengthString(ver, verLen));
                this.println(sbuf.toString());
            }
        }
    }

    protected void cleanupUnusedArtifacts() throws Exception {
        this.println("Cleaning unused artifacts...");
        Artifact[] artifacts = this.installer.cleanupUnusedArtifacts(this.installation, this.index);
        int numDeleted = artifacts.length;
        if (numDeleted < 1) {
            this.println("There are no unused artifacts.");
        } else {
            this.println("Number of artifacts removed: " + numDeleted);
            this.listArtifacts(artifacts);
        }
    }

    protected void performSoftwareUpgrade() throws Exception {
        this.println("Performing software upgrade...");
        InfectionAccess access = this.infection.getInfectionAccess();
        Thread thread = access.startAutoSoftwareUpdate(this.installation, this.index, this.instance);
        if (thread != null) {
            thread.join();
        }
        this.println("Software upgrade completed.");
    }

    protected void bundleArtifacts(File destZipFile, String appName, String appTitle) throws Exception {
        this.println("Creating bundle: " + destZipFile);
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        int numArtifacts = this.index.getArtifactCount();
        for (int i = 0; i < numArtifacts; ++i) {
            artifactList.add(this.index.getArtifactAt(i));
        }
        Artifact[] artifacts = artifactList.toArray(new Artifact[artifactList.size()]);
        boolean includeUpdateSites = false;
        String mainJarFile = null;
        if (this.infectionJarURL != null) {
            String urlPath = this.getAbsoluteUrlPath(this.infectionJarURL);
            if (urlPath != null) {
                String indexDirUrlPath;
                URL indexDirURL;
                File indexDir = this.installation.getIndexDirectory();
                URL uRL = indexDirURL = indexDir == null ? null : indexDir.toURL();
                if (indexDirURL != null && (indexDirUrlPath = this.getAbsoluteUrlPath(indexDirURL)) != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("urlPath=         " + urlPath);
                        logger.fine("indexDirUrlPath= " + indexDirUrlPath);
                    }
                    if (urlPath.startsWith(indexDirUrlPath)) {
                        mainJarFile = urlPath.substring(indexDirUrlPath.length());
                    }
                }
            }
            if (mainJarFile == null) {
                mainJarFile = urlPath;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("mainJarFile=" + mainJarFile);
        }
        String distJarFile = null;
        if (this.distributionJarURL != null) {
            String urlPath = this.getAbsoluteUrlPath(this.distributionJarURL);
            if (urlPath != null) {
                String indexDirUrlPath;
                URL indexDirURL;
                File indexDir = this.installation.getIndexDirectory();
                URL uRL = indexDirURL = indexDir == null ? null : indexDir.toURL();
                if (indexDirURL != null && (indexDirUrlPath = this.getAbsoluteUrlPath(indexDirURL)) != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("urlPath=         " + urlPath);
                        logger.fine("indexDirUrlPath= " + indexDirUrlPath);
                    }
                    if (urlPath.startsWith(indexDirUrlPath)) {
                        distJarFile = urlPath.substring(indexDirUrlPath.length());
                    }
                }
            }
            if (distJarFile == null) {
                distJarFile = urlPath;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("distJarFile=" + distJarFile);
        }
        String zipSubDir = appName;
        this.installer.bundleArtifacts(destZipFile, zipSubDir, this.installation, this.index, artifacts, includeUpdateSites, mainJarFile, distJarFile, appTitle);
        this.println("Bundle created successfully.");
    }

    private String getAbsoluteUrlPath(URL url) {
        if (url == null) {
            return null;
        }
        String urlPath = url.getPath();
        if (urlPath == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(urlPath, "/", true);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.equals("/") || s.equals(".")) continue;
            if (s.equals("..")) {
                if (list.isEmpty()) continue;
                list.removeLast();
                continue;
            }
            list.add(s);
        }
        StringBuffer sb = new StringBuffer();
        if (urlPath.startsWith("/")) {
            sb.append("/");
        }
        int idx = 0;
        for (String s : list) {
            if (idx > 0) {
                sb.append("/");
            }
            sb.append(s);
            ++idx;
        }
        if (urlPath.endsWith("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    private String lengthString(String s, int len) {
        if (s.length() >= len) {
            return s;
        }
        char[] chars = new char[len - s.length()];
        Arrays.fill(chars, ' ');
        return s + new String(chars);
    }

    private String lengthString(char c, int len) {
        char[] chars = new char[len];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    protected class UpgradeCommand
    extends AbstractInfectionCommand {
        protected UpgradeCommand() {
        }

        @Override
        public String getName() {
            return "upgrade";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Performs software upgrade";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.performSoftwareUpgrade();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class BundleCommand
    extends AbstractInfectionCommand {
        protected BundleCommand() {
        }

        @Override
        public String getName() {
            return "bundle";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Creates bundle of installed artifacts";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                if (args.length < 1) {
                    File homeDir;
                    File indexDir = InfectionCommandLineImpl.this.installation.getIndexDirectory();
                    File defaultDestZipFileDir = homeDir = indexDir.getParentFile();
                    String defaultDestZipFileName = "bundle.zip";
                    File defaultDestZipFile = new File(defaultDestZipFileDir, defaultDestZipFileName);
                    args = new String[]{defaultDestZipFile.getPath()};
                }
                this.assertArguments(args, 1);
                String destZipFilePath = args[0];
                File destZipFile = new File(destZipFilePath);
                String appName = null;
                String appTitle = null;
                if (InfectionCommandLineImpl.this.instance != null) {
                    appName = InfectionCommandLineImpl.this.instance.getDistributionName();
                    appTitle = InfectionCommandLineImpl.this.instance.getDistributionName();
                }
                InfectionCommandLineImpl.this.bundleArtifacts(destZipFile, appName, appTitle);
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class CleanupCommand
    extends AbstractInfectionCommand {
        protected CleanupCommand() {
        }

        @Override
        public String getName() {
            return "cleanup";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Performs cleanup of unused artifacts";
        }

        @Override
        public void invoke(String[] params) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.cleanupUnusedArtifacts();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class ListCommand
    extends AbstractInfectionCommand {
        protected ListCommand() {
        }

        @Override
        public String getName() {
            return "list";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Lists installed artifacts";
        }

        @Override
        public void invoke(String[] params) throws InfectionCommandException {
            try {
                boolean invalidParams = false;
                boolean listUnused = false;
                if (params.length > 0) {
                    if (params.length == 1) {
                        String param = params[0];
                        if (!"installed".equals(param)) {
                            if ("unused".equals(param)) {
                                listUnused = true;
                            } else {
                                invalidParams = true;
                            }
                        }
                    } else {
                        invalidParams = true;
                    }
                }
                if (invalidParams) {
                    throw new Exception("Invalid command parameters specified.");
                }
                if (listUnused) {
                    InfectionCommandLineImpl.this.listUnusedArtifacts();
                    return;
                }
                InfectionCommandLineImpl.this.listInstalledArtifacts();
                return;
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class SelfTestCommand
    extends AbstractInfectionCommand {
        protected SelfTestCommand() {
        }

        @Override
        public String getName() {
            return "selftest";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Performs self-test";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.performSelfTest();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class GcCommand
    extends AbstractInfectionCommand {
        protected GcCommand() {
        }

        @Override
        public String getName() {
            return "gc";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Performs garbage collection";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.gc();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class MemoryCommand
    extends AbstractInfectionCommand {
        protected MemoryCommand() {
        }

        @Override
        public String getName() {
            return "memory";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"mem"};
        }

        @Override
        public String getDescription() {
            return "Displays current memory usage";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.printMemoryUsage();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class PropertiesCommand
    extends AbstractInfectionCommand {
        protected PropertiesCommand() {
        }

        @Override
        public String getName() {
            return "properties";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Displays current system properties";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.printProperties();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class InfoCommand
    extends AbstractInfectionCommand {
        protected InfoCommand() {
        }

        @Override
        public String getName() {
            return "info";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Displays general information";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.printInfo();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class VersionCommand
    extends AbstractInfectionCommand {
        protected VersionCommand() {
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"ver"};
        }

        @Override
        public String getDescription() {
            return "Displays version information";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.printVersion();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class ReturnCodeCommand
    extends AbstractInfectionCommand {
        protected ReturnCodeCommand() {
        }

        @Override
        public String getName() {
            return "rc";
        }

        @Override
        public String[] getAliases() {
            return new String[0];
        }

        @Override
        public String getDescription() {
            return "Displays return code of previous command";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            InfectionCommandLineImpl.this.println("" + InfectionCommandLineImpl.this.returnCode);
        }
    }

    protected class HelpCommand
    extends AbstractInfectionCommand {
        protected HelpCommand() {
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"?"};
        }

        @Override
        public String getDescription() {
            return "Displays the help";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            try {
                InfectionCommandLineImpl.this.printHelp();
            }
            catch (Exception e) {
                throw new InfectionCommandException(42, (Throwable)e);
            }
        }
    }

    protected class ExitCommand
    extends AbstractInfectionCommand {
        protected ExitCommand() {
        }

        @Override
        public String getName() {
            return "exit";
        }

        @Override
        public String[] getAliases() {
            return new String[]{"quit"};
        }

        @Override
        public String getDescription() {
            return "Exits the command shell";
        }

        @Override
        public void invoke(String[] args) throws InfectionCommandException {
            int code = 0;
            if (args != null && args.length > 0) {
                code = Integer.parseInt(args[0].trim());
            }
            InfectionCommandLineImpl.this.exit(code);
        }
    }

    protected abstract class AbstractInfectionCommand
    implements InfectionCommand {
        protected final void assertArguments(String[] args, int count) throws Exception {
            if (args.length != count) {
                throw new Exception("Invalid number of arguments: " + args.length + " (expected " + count + ")");
            }
        }
    }
}

