/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.install;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.ArtifactDependency;
import com.spacekiller.infection.install.ArtifactKey;
import com.spacekiller.infection.install.ArtifactModel;
import com.spacekiller.infection.install.InstallerStrategyBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallerStrategyV10
extends InstallerStrategyBase {
    private static final Logger logger = Logger.getLogger(InstallerStrategyV10.class.getName());
    private static final double ROOT_WEIGHT = 1024.0;
    protected ArtifactModel mergedModel;
    protected Map dependencyInfoMap;
    protected Layer firstLevel;
    protected Layer lastLevel;
    protected Layer currentLevel;
    protected long iterations;

    protected boolean isDebug(Layer level) {
        return logger.isLoggable(Level.FINER);
    }

    protected void debug(Layer level, String msg) {
        int num = level.depth;
        String indent = this.indent(num);
        String str = "debug: " + indent + msg;
        logger.finer(str);
    }

    protected String indent(int depth) {
        int num = depth * 2;
        char[] arr = new char[num];
        Arrays.fill(arr, ' ');
        return new String(arr);
    }

    @Override
    public synchronized boolean execute() {
        Artifact resultArtifact;
        int i;
        ArtifactModel mergedModel;
        ArtifactModel currentArtifactModel = this.getCurrentArtifactModel();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("currentArtifactModel: " + currentArtifactModel.getArtifactCount());
        }
        ArtifactModel availableArtifactModel = this.getAvailableArtifactModel();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("availableArtifactModel: " + availableArtifactModel.getArtifactCount());
        }
        this.mergedModel = mergedModel = this.mergeInstallerModels(currentArtifactModel, availableArtifactModel);
        this.dependencyInfoMap = new HashMap();
        ArtifactDependency[] dependencyArray = this.getDependencies();
        if (dependencyArray == null) {
            dependencyArray = new ArtifactDependency[]{};
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("dependencyArray: " + dependencyArray.length);
            if (logger.isLoggable(Level.FINER)) {
                for (int i2 = 0; i2 < dependencyArray.length; ++i2) {
                    logger.finer(" - " + dependencyArray[i2]);
                }
            }
        }
        long startTime = System.currentTimeMillis();
        Layer rootLevel = new Layer(null);
        Artifact rootArtifact = null;
        ArtifactEntry rootArtifactEntry = new ArtifactEntry(rootLevel, rootArtifact);
        for (int i3 = 0; i3 < dependencyArray.length; ++i3) {
            ArtifactDependency dependency = dependencyArray[i3];
            if (dependency == null) continue;
            DependencyEntry entry = new DependencyEntry(rootArtifactEntry, dependency);
            DependencyInfo depInfo = rootLevel.addDependencyEntry(entry);
            this.dependencyInfoMap.put(depInfo.artifactKey, depInfo);
        }
        Artifact[] currentArtifacts = currentArtifactModel.getArtifacts();
        for (int i4 = 0; i4 < currentArtifacts.length; ++i4) {
            String name;
            Artifact fact = currentArtifacts[i4];
            if (fact == null || (name = fact.getName()) == null) continue;
            String version = fact.getVersion();
            ArtifactDependency dependency = new ArtifactDependency(name, version);
            DependencyEntry entry = new DependencyEntry(rootArtifactEntry, dependency);
            DependencyInfo depInfo = rootLevel.addDependencyEntry(entry);
            this.dependencyInfoMap.put(depInfo.artifactKey, depInfo);
        }
        this.firstLevel = rootLevel;
        this.lastLevel = rootLevel;
        this.currentLevel = rootLevel;
        this.iterations = 0L;
        boolean done = this.loop();
        long totalTime = System.currentTimeMillis() - startTime;
        if (logger.isLoggable(Level.FINE)) {
            int levels = this.lastLevel.depth + 1;
            logger.fine("Levels: " + levels);
            logger.fine("Iterations: " + this.iterations + " in " + totalTime + " ms.");
            if (this.isDebug(rootLevel)) {
                this.dumpLevel(rootLevel);
            }
        }
        if (!done) {
            return false;
        }
        LinkedList bestArtifactEntries = new LinkedList();
        this.enumerateBestArtifactEntries(rootLevel, bestArtifactEntries);
        int bestArtifactCount = bestArtifactEntries.size();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("bestArtifacts: " + bestArtifactCount);
        }
        Iterator bestIter = bestArtifactEntries.iterator();
        Artifact[] resultArtifacts = new Artifact[bestArtifactCount];
        for (i = 0; i < bestArtifactCount; ++i) {
            ArtifactEntry artifactEntry = (ArtifactEntry)bestIter.next();
            resultArtifacts[i] = resultArtifact = artifactEntry.artifact;
            if (!this.isDebug(rootLevel)) continue;
            this.debug(rootLevel, "best #" + i + ": " + resultArtifact);
        }
        resultArtifacts = this.debugAmbiguousArtifacts(resultArtifacts, logger);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("resultArtifacts: " + resultArtifacts.length);
            if (logger.isLoggable(Level.FINER)) {
                for (i = 0; i < resultArtifacts.length; ++i) {
                    resultArtifact = resultArtifacts[i];
                    logger.finer(" - " + resultArtifact);
                }
            }
        }
        ArtifactModel resultModel = new ArtifactModel();
        if (resultArtifacts != null) {
            resultModel.addAllArtifacts(resultArtifacts);
        }
        this.setResultArtifactModel(resultModel);
        return true;
    }

    protected boolean loop() {
        Layer level;
        while ((level = this.currentLevel) != null) {
            if (this.cancel) {
                return false;
            }
            this.process(level);
            ++this.iterations;
        }
        return true;
    }

    protected void process(Layer level) {
        if (this.isDebug(level)) {
            this.debug(level, "process: " + level + ", dependencyInfos=" + level.dependencyInfoMap.size());
        }
        long modCount = 0L;
        for (ArtifactKey artifactKey : level.artifactKeyList) {
            int newBestIndex;
            DependencyInfo dependencyInfo = (DependencyInfo)this.dependencyInfoMap.get(artifactKey);
            if (dependencyInfo == null || !dependencyInfo.modified) continue;
            List entryList = dependencyInfo.entryList;
            ArtifactEntry[] artifactEntries = dependencyInfo.artifactEntries;
            int bestIndex = dependencyInfo.bestIndex;
            if (this.isDebug(level)) {
                this.debug(level, "DependencyInfo: key=" + artifactKey + ", deps=" + entryList.size() + ", artifacts=" + artifactEntries.length + ", bestIndex=" + bestIndex);
            }
            if ((newBestIndex = dependencyInfo.entryList.isEmpty() ? -1 : this.chooseBestArtifactEntry(dependencyInfo, artifactEntries)) != bestIndex) {
                ArtifactKey depKey;
                if (this.isDebug(level)) {
                    this.debug(level, "newBestIndex=" + newBestIndex);
                }
                if (bestIndex >= 0) {
                    ArtifactEntry oldBestEntry = artifactEntries[bestIndex];
                    if (this.isDebug(level)) {
                        this.debug(level, "oldBestEntry: " + oldBestEntry.artifact);
                    }
                    ++oldBestEntry.failedCounter;
                    int[] failedBetterIndex = oldBestEntry.failedBetterIndex;
                    if (failedBetterIndex == null) {
                        oldBestEntry.failedBetterIndex = failedBetterIndex = new int[]{newBestIndex};
                    } else {
                        int oldFailedSize = failedBetterIndex.length;
                        for (int k = 0; k < oldFailedSize; ++k) {
                            if (failedBetterIndex[k] != newBestIndex) continue;
                            logger.warning("Infinite loop detected: oldBestIndex=" + bestIndex + ", artifact=" + oldBestEntry.artifact + " --> newBestIndex=" + newBestIndex);
                            newBestIndex = bestIndex;
                            break;
                        }
                        if (newBestIndex != bestIndex) {
                            int[] newFailedBetterIndex = new int[oldFailedSize + 1];
                            System.arraycopy(failedBetterIndex, 0, newFailedBetterIndex, 0, oldFailedSize);
                            newFailedBetterIndex[oldFailedSize] = newBestIndex;
                            oldBestEntry.failedBetterIndex = newFailedBetterIndex;
                        }
                    }
                    List artDepEntryList = oldBestEntry.dependencyEntryList;
                    if (artDepEntryList != null) {
                        for (DependencyEntry oldDepEntry : artDepEntryList) {
                            boolean removed;
                            DependencyInfo depInfo;
                            depKey = this.mergedModel.artifactKey(oldDepEntry.dependency);
                            if (depKey == null || (depInfo = (DependencyInfo)this.dependencyInfoMap.get(depKey)) == null || (removed = depInfo.removeDependencyEntry(oldDepEntry))) continue;
                            logger.warning("oldDepEntry not registered: " + oldDepEntry);
                        }
                        oldBestEntry.dependencyEntryList = null;
                    }
                }
                dependencyInfo.bestIndex = bestIndex = newBestIndex;
                if (bestIndex >= 0) {
                    ArtifactEntry newBestEntry = artifactEntries[bestIndex];
                    Artifact artifact = newBestEntry.artifact;
                    int numDeps = artifact.getDependencyCount();
                    if (this.isDebug(level)) {
                        this.debug(level, "newBestEntry: " + artifact + ", numDeps=" + numDeps);
                    }
                    for (int i = 0; i < numDeps; ++i) {
                        ArtifactDependency dependency = artifact.getDependencyAt(i);
                        if (dependency == null || (depKey = this.mergedModel.artifactKey(dependency)) == null) continue;
                        DependencyEntry newDepEntry = new DependencyEntry(newBestEntry, dependency);
                        LinkedList<DependencyEntry> depEntryList = newBestEntry.dependencyEntryList;
                        if (depEntryList == null) {
                            newBestEntry.dependencyEntryList = depEntryList = new LinkedList<DependencyEntry>();
                        }
                        depEntryList.add(newDepEntry);
                        DependencyInfo depInfo = (DependencyInfo)this.dependencyInfoMap.get(depKey);
                        if (depInfo == null) {
                            Layer child = level.child;
                            if (child == null) {
                                level.child = child = new Layer(level);
                                this.lastLevel = child;
                            }
                            depInfo = child.addDependencyEntry(newDepEntry);
                            this.dependencyInfoMap.put(depKey, depInfo);
                            continue;
                        }
                        depInfo.level.addDependencyEntry(newDepEntry);
                    }
                }
            }
            dependencyInfo.modified = false;
            ++modCount;
        }
        this.currentLevel = modCount == 0L ? level.parent : this.lastLevel;
    }

    protected int chooseBestArtifactEntry(DependencyInfo dependencyInfo, ArtifactEntry[] artifactEntries) {
        List depEntryList = dependencyInfo.entryList;
        int numArtifacts = artifactEntries.length;
        int bestIndex = -1;
        double bestError = 0.0;
        for (int i = 0; i < numArtifacts; ++i) {
            ArtifactEntry artEntry = artifactEntries[i];
            Artifact artifact = artEntry.artifact;
            double artError = 0.0;
            for (DependencyEntry depEntry : depEntryList) {
                if (depEntry.dependency.acceptArtifact(artifact)) continue;
                artError += depEntry.weight;
            }
            if (bestIndex >= 0 && !(artError < bestError)) continue;
            bestIndex = i;
            bestError = artError;
            if (bestError <= 0.0) break;
        }
        return bestIndex;
    }

    protected void enumerateBestArtifactEntries(Layer level, Collection dstArtifactEntries) {
        while (level != null) {
            this.enumerateBestArtifactEntriesImpl(level, dstArtifactEntries);
            level = level.child;
        }
    }

    protected void enumerateBestArtifactEntriesImpl(Layer level, Collection dstArtifactEntries) {
        for (ArtifactKey artifactKey : level.artifactKeyList) {
            int bestIndex;
            DependencyInfo depInfo = level.getDependencyInfo(artifactKey);
            if (depInfo == null || depInfo.entryList.isEmpty() || (bestIndex = depInfo.bestIndex) < 0) continue;
            ArtifactEntry artifactEntry = depInfo.artifactEntries[bestIndex];
            dstArtifactEntries.add(artifactEntry);
        }
    }

    protected void dumpLevel(Layer level) {
        while (level != null) {
            this.dumpLevelImpl(level);
            level = level.child;
        }
    }

    protected void dumpLevelImpl(Layer level) {
        String msg = "" + level + ", weight=" + level.weight + ", keys=" + level.artifactKeyList;
        this.debug(level, msg);
        for (ArtifactKey artifactKey : level.artifactKeyList) {
            DependencyInfo depInfo = level.getDependencyInfo(artifactKey);
            if (depInfo == null) continue;
            if (depInfo.entryList.isEmpty()) {
                if (!this.isDebug(level)) continue;
                msg = "- " + artifactKey + " => OBSOLETE !";
                this.debug(level, msg);
                continue;
            }
            int bestIndex = depInfo.bestIndex;
            if (bestIndex < 0) {
                if (!this.isDebug(level)) continue;
                msg = "- " + artifactKey + " => MISSING !";
                this.debug(level, msg);
                continue;
            }
            ArtifactEntry artifactEntry = depInfo.artifactEntries[bestIndex];
            if (!this.isDebug(level)) continue;
            msg = "- " + artifactKey + " => " + artifactEntry.artifact;
            this.debug(level, msg);
        }
    }

    protected class ArtifactEntry {
        protected Layer level;
        protected Artifact artifact;
        protected List dependencyEntryList;
        protected int failedCounter;
        protected int[] failedBetterIndex;

        public ArtifactEntry(Layer level, Artifact artifact) {
            this.level = level;
            this.artifact = artifact;
        }

        public String toString() {
            return "ArtifactEntry[" + this.artifact + "]";
        }
    }

    protected class DependencyEntry {
        protected ArtifactEntry artifactEntry;
        protected ArtifactDependency dependency;
        protected double weight;

        public DependencyEntry(ArtifactEntry artifactEntry, ArtifactDependency dependency) {
            this.artifactEntry = artifactEntry;
            this.dependency = dependency;
        }
    }

    protected class DependencyInfo {
        protected Layer level;
        protected ArtifactKey artifactKey;
        protected List entryList;
        protected boolean modified;
        protected ArtifactEntry[] artifactEntries;
        protected int bestIndex;

        public DependencyInfo(Layer level, ArtifactKey artifactKey) {
            this.level = level;
            this.artifactKey = artifactKey;
            this.entryList = new LinkedList();
            this.bestIndex = -1;
        }

        public String toString() {
            return "DependencyInfo[" + this.artifactKey + "]";
        }

        public void addDependencyEntry(DependencyEntry entry) {
            if (this.entryList.add(entry)) {
                this.modified = true;
            }
        }

        public boolean removeDependencyEntry(DependencyEntry entry) {
            if (this.entryList.remove(entry)) {
                this.modified = true;
                return true;
            }
            return false;
        }
    }

    protected class Layer {
        protected Layer parent;
        protected int depth;
        protected double weight;
        protected Layer child;
        protected List artifactKeyList;
        protected Map dependencyInfoMap;

        public Layer(Layer parent) {
            this.parent = parent;
            this.depth = parent == null ? 0 : 1 + parent.depth;
            this.weight = parent == null ? 1024.0 : parent.weight / 2.0;
            this.artifactKeyList = new LinkedList();
            this.dependencyInfoMap = new HashMap();
        }

        public String toString() {
            return "Level[" + this.depth + "]";
        }

        public DependencyInfo getDependencyInfo(ArtifactKey artifactKey) {
            return (DependencyInfo)this.dependencyInfoMap.get(artifactKey);
        }

        public DependencyInfo addDependencyEntry(DependencyEntry entry) {
            ArtifactDependency dependency = entry.dependency;
            ArtifactKey artifactKey = InstallerStrategyV10.this.mergedModel.artifactKey(dependency);
            if (artifactKey == null) {
                return null;
            }
            DependencyInfo dependencyInfo = (DependencyInfo)this.dependencyInfoMap.get(artifactKey);
            if (dependencyInfo == null) {
                dependencyInfo = this.createDependencyInfo(artifactKey);
                this.dependencyInfoMap.put(artifactKey, dependencyInfo);
                this.artifactKeyList.add(artifactKey);
            }
            entry.weight = this.weight;
            dependencyInfo.addDependencyEntry(entry);
            return dependencyInfo;
        }

        protected DependencyInfo createDependencyInfo(ArtifactKey artifactKey) {
            DependencyInfo dependencyInfo = new DependencyInfo(this, artifactKey);
            Collection dstEntries = null;
            dstEntries = InstallerStrategyV10.this.mergedModel.findArtifactsForKey(artifactKey, dstEntries);
            Artifact[] sortedArtifacts = null;
            if (dstEntries != null) {
                Artifact[] foundArtifacts = dstEntries.toArray(new Artifact[dstEntries.size()]);
                ArtifactDependency dependency = null;
                sortedArtifacts = InstallerStrategyV10.this.sortArtifactsForStrategy(dependency, artifactKey, foundArtifacts);
            }
            int numArtifacts = sortedArtifacts == null ? 0 : sortedArtifacts.length;
            ArtifactEntry[] artifactEntries = new ArtifactEntry[numArtifacts];
            for (int i = 0; i < numArtifacts; ++i) {
                ArtifactEntry artifactEntry;
                void artifact = sortedArtifacts[i];
                artifactEntries[i] = artifactEntry = new ArtifactEntry(this, (Artifact)artifact);
            }
            dependencyInfo.artifactEntries = artifactEntries;
            return dependencyInfo;
        }
    }
}

