/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.j15;

import com.spacekiller.infection.InfectionEnhancement;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;

public class XMLValidatorV1J15Impl
implements InfectionEnhancement.XMLValidatorV1 {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Schema schema;

    @Override
    public void validateInfectionXML(InputStream in) throws Exception {
        Validator validator = this.getSchema().newValidator();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder parser = builderFactory.newDocumentBuilder();
        Document document = parser.parse(in);
        validator.validate(new DOMSource(document));
    }

    protected Schema createSchema() throws Exception {
        boolean fine = this.log.isLoggable(Level.FINE);
        String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
        if (fine) {
            this.log.fine("Creating SchemaFactory: " + schemaLanguage);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        if (fine) {
            this.log.fine("SchemaFactory: " + schemaFactory);
        }
        URL schemaURL = this.getClass().getResource("/com/spacekiller/infection/schema/infection_V1.xsd");
        if (fine) {
            this.log.fine("Loading Schema: " + schemaURL);
        }
        Schema schema = schemaFactory.newSchema(schemaURL);
        if (fine) {
            this.log.fine("Schema: " + schema);
        }
        return schema;
    }

    protected Schema getSchema() throws Exception {
        if (this.schema == null) {
            this.setSchema(this.createSchema());
        }
        return this.schema;
    }

    private void setSchema(Schema schema) {
        this.schema = schema;
    }
}

