/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.load;

import com.spacekiller.infection.load.ArtifactClassLoader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;

public class ArtifactClassLoaderOwner {
    private ArtifactClassLoader loader;
    private Thread thread;
    private LinkedList work = null;
    private static final Logger logger = Logger.getLogger(ArtifactClassLoaderOwner.class.getName());

    public ArtifactClassLoaderOwner(ArtifactClassLoader loader) {
        this.setLoader(loader);
        this.setThread(Thread.currentThread());
    }

    protected final Thread getThread() {
        return this.thread;
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    protected final ArtifactClassLoader getLoader() {
        return this.loader;
    }

    private void setLoader(ArtifactClassLoader loader) {
        this.loader = loader;
    }

    public String toString() {
        return super.toString() + "[thread=" + this.thread + ", loader=" + this.loader + "]";
    }

    synchronized FindClass findLocalClassMediate(String name) throws ClassNotFoundException {
        if (this.work == null) {
            this.work = new LinkedList();
        }
        FindClass action = new FindClass(name);
        this.work.add(action);
        return action;
    }

    synchronized void finishWork() {
        LinkedList work = this.work;
        if (work == null) {
            return;
        }
        if (work.isEmpty()) {
            return;
        }
        logger.fine("" + Thread.currentThread() + " >> finishWork: " + work.size());
        Iterator i = work.iterator();
        while (i.hasNext()) {
            Runnable action = (Runnable)i.next();
            i.remove();
            action.run();
        }
    }

    protected class FindClass
    implements Runnable {
        protected String name;
        protected Class clazz;
        protected ClassNotFoundException error;

        public FindClass(String name) {
            this.name = name;
        }

        public FindClass(String name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public String getName() {
            return this.name;
        }

        public Class getLoadedClass() {
            return this.clazz;
        }

        public ClassNotFoundException getError() {
            return this.error;
        }

        @Override
        public void run() {
            System.out.println("" + Thread.currentThread() + " >> findLocalClassImpl: " + this.name + " >> " + ArtifactClassLoaderOwner.this.loader);
            try {
                this.clazz = ArtifactClassLoaderOwner.this.loader.findLocalClass(this.name);
            }
            catch (ClassNotFoundException e) {
                this.error = e;
            }
            catch (Exception e) {
                this.error = new ClassNotFoundException(this.name, e);
            }
            if (this.clazz != null) {
                System.out.println("" + Thread.currentThread() + " >> findLocalClassImpl EXIT: " + this.clazz);
            } else {
                System.out.println("" + Thread.currentThread() + " >> findLocalClassImpl EXIT: Failed >> " + this.error);
            }
        }
    }
}

