/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.load;

import com.spacekiller.infection.load.ArtifactClassLoader;
import com.spacekiller.infection.load.Resource;
import com.spacekiller.infection.load.ResourceImpl;
import com.spacekiller.infection.load.ResourceLoader;
import java.io.FilePermission;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArtifactResourceLoader
implements ResourceLoader {
    private static final Logger logger = Logger.getLogger(ArtifactResourceLoader.class.getName());
    private ArtifactClassLoader classLoader;

    public ArtifactResourceLoader(ArtifactClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Resource getResource(String name, boolean check) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getResource", "name=" + name + ", loader=" + this.classLoader);
        }
        URL url = this.classLoader.getResource(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getResource", "name=" + name + ", loader=" + this.classLoader + ", url=" + url);
        }
        if (url == null) {
            return null;
        }
        return new ResourceImpl(url);
    }

    @Override
    public Enumeration getResources(String name, boolean check) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "getResources", "name=" + name + ", loader=" + this.classLoader);
        }
        Enumeration<URL> en = this.classLoader.getResources(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "getResources", "name=" + name + ", loader=" + this.classLoader + ", en=" + en);
        }
        return en;
    }

    @Override
    public URL findResource(String name, boolean check) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findResource", "name=" + name + ", loader=" + this.classLoader);
        }
        URL url = this.classLoader.findLocalResource(name);
        if (check) {
            try {
                ArtifactResourceLoader.check(url);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findResource", "name=" + name + ", loader=" + this.classLoader + ", url=" + url);
        }
        return url;
    }

    @Override
    public Enumeration findResources(String name, boolean check) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "findResources", "name=" + name + ", loader=" + this.classLoader);
        }
        Enumeration en = this.classLoader.findLocalResources(name);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "findResources", "name=" + name + ", loader=" + this.classLoader + ", en=" + en);
        }
        return en;
    }

    @Override
    public URL checkURL(URL url) {
        try {
            ArtifactResourceLoader.check(url);
        }
        catch (Exception e) {
            return null;
        }
        return url;
    }

    static void check(URL url) throws IOException {
        URLConnection urlConnection;
        Permission perm;
        SecurityManager security = System.getSecurityManager();
        if (security != null && (perm = (urlConnection = url.openConnection()).getPermission()) != null) {
            try {
                security.checkPermission(perm);
            }
            catch (SecurityException se) {
                if (perm instanceof FilePermission && perm.getActions().indexOf("read") != -1) {
                    security.checkRead(perm.getName());
                }
                if (perm instanceof SocketPermission && perm.getActions().indexOf("connect") != -1) {
                    URL locUrl = url;
                    if (urlConnection instanceof JarURLConnection) {
                        locUrl = ((JarURLConnection)urlConnection).getJarFileURL();
                    }
                    security.checkConnect(locUrl.getHost(), locUrl.getPort());
                }
                throw se;
            }
        }
    }
}

