/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.old;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionIndex;
import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionUtil;
import com.spacekiller.infection.log.Log2ConsoleAsyncHandler;
import com.spacekiller.infection.log.Log2FileAsyncHandler;
import com.spacekiller.infection.log.Log2TraceAsyncHandler;
import com.spacekiller.infection.util.InfectionXmlUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class InfectionLegacySupport {
    public static final String LEGACY_INDEX_FILENAME = "infection.xml";
    public static final String LEGACY_ARTIFACTS_DIRNAME = "artifacts";
    public static final String LEGACY_DISTRIBUTION_JARFILE = "distribution.jar";
    public static final String LEGACY_INFECTION_DIRNAME = ".infection";

    private static void debug(String msg) {
        Infection.debugLegacy(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File migrateLegacyInstanceV1(InfectionInstance instance, File indexFile) throws Exception {
        File legacyIndexFile = null;
        InfectionIndex legacyIndex = null;
        if (LEGACY_INDEX_FILENAME.equals(indexFile.getName())) {
            InfectionLegacySupport.debug("Loading legacy index: " + indexFile);
            if (indexFile.exists() && indexFile.isFile()) {
                legacyIndexFile = indexFile;
                legacyIndex = new InfectionIndex(indexFile);
            }
            boolean skipIndexMigration = false;
            File baseDir = indexFile.getParentFile();
            File newArtifactsDir = new File(baseDir, LEGACY_INFECTION_DIRNAME);
            File newIndexFile = new File(newArtifactsDir, "index.xml");
            if (newIndexFile.exists() && newIndexFile.isFile()) {
                skipIndexMigration = true;
                InfectionLegacySupport.debug("Legacy index was already migrated: " + newIndexFile);
            }
            if (!skipIndexMigration && legacyIndexFile != null) {
                int i;
                InfectionLegacySupport.debug("Migrating legacy index: " + legacyIndexFile);
                InfectionIndex migrateIndex = new InfectionIndex(legacyIndexFile);
                int instanceCount = migrateIndex.getInstanceCount();
                int artifactCount = migrateIndex.getArtifactCount();
                InfectionLegacySupport.debug("Number of instances: " + instanceCount);
                InfectionLegacySupport.debug("Number of artifacts: " + artifactCount);
                File oldBaseDir = baseDir;
                InfectionLegacySupport.debug("Infection base directory: " + oldBaseDir);
                LinkedList<String> instancePaths = new LinkedList<String>();
                for (i = 0; i < instanceCount; ++i) {
                    String instancePath = migrateIndex.getInstancePathAt(i);
                    if (instancePath == null) continue;
                    File instanceFile = new File(instancePath);
                    File absoluteFile = InfectionUtil.getAbsoluteFile(instanceFile, oldBaseDir);
                    InfectionLegacySupport.debug("Absolute instance path: " + instancePath + " -> " + absoluteFile);
                    File newInstanceFile = InfectionUtil.getRelativeFile(absoluteFile, newArtifactsDir);
                    String newInstancePath = newInstanceFile.getPath();
                    InfectionLegacySupport.debug("Updating instance path: " + instancePath + " -> " + newInstancePath);
                    instancePaths.add(newInstancePath);
                }
                for (i = instanceCount - 1; i >= 0; --i) {
                    migrateIndex.removeInstancePathAt(i);
                }
                for (String newInstancePath : instancePaths) {
                    migrateIndex.addInstancePath(newInstancePath);
                }
                for (int i2 = 0; i2 < artifactCount; ++i2) {
                    String artifactPath;
                    Artifact artifact = migrateIndex.getArtifactAt(i2);
                    if (artifact == null || (artifactPath = artifact.getPath()) == null) continue;
                    File artifactFile = new File(artifactPath);
                    File absoluteFile = InfectionUtil.getAbsoluteFile(artifactFile, oldBaseDir);
                    InfectionLegacySupport.debug("Absolute artifact path: " + artifactPath + " -> " + absoluteFile);
                    File newArtifactFile = InfectionUtil.getRelativeFile(absoluteFile, newArtifactsDir);
                    String newArtifactPath = newArtifactFile.getPath();
                    InfectionLegacySupport.debug("Updating artifact path: " + artifactPath + " -> " + newArtifactPath);
                    artifact.setPath(newArtifactPath);
                }
                File indexDirectory = newIndexFile.getParentFile();
                if (indexDirectory != null && !indexDirectory.exists()) {
                    InfectionLegacySupport.debug("Creating index directory: " + indexDirectory);
                    if (!indexDirectory.mkdirs()) {
                        InfectionLegacySupport.debug("Failed to create directory: " + indexDirectory);
                    }
                }
                InfectionLegacySupport.debug("Writing new index file: " + newIndexFile);
                boolean successIndexFile = false;
                FileOutputStream fos = new FileOutputStream(newIndexFile);
                try {
                    new InfectionXmlUtil(migrateIndex).saveIndex(fos);
                    successIndexFile = true;
                }
                finally {
                    fos.close();
                    if (!successIndexFile && !newIndexFile.delete()) {
                        InfectionLegacySupport.debug("Failed to delete incomplete index-file: " + newIndexFile);
                    }
                }
            }
            indexFile = newIndexFile;
        }
        InfectionLegacySupport.debug("New Index file: " + indexFile);
        File instanceFile = instance.getInstanceFile();
        InfectionLegacySupport.debug("Migrating legacy instance: " + instanceFile);
        File relativeRoot = instanceFile.getParentFile();
        File relativeIndexFile = InfectionUtil.getRelativeFile(indexFile, relativeRoot);
        String newIndexPath = relativeIndexFile.getPath();
        instance.setIndexPath(newIndexPath);
        instance.saveInstanceConfig();
        InfectionLegacySupport.debug("Migrated legacy instance: " + instanceFile);
        if (legacyIndex != null) {
            this.cleanupLegacyInstallationV1(legacyIndexFile, legacyIndex);
        }
        return indexFile;
    }

    protected void cleanupLegacyInstallationV1(File legacyIndexFile, InfectionIndex legacyIndex) throws Exception {
        File installationDir = legacyIndexFile.getParentFile();
        InfectionLegacySupport.debug("Installation directory: " + installationDir);
        int instanceCount = legacyIndex.getInstanceCount();
        InfectionLegacySupport.debug("Number of instances: " + instanceCount);
        if (instanceCount < 1) {
            return;
        }
        int legacyInstanceCount = 0;
        for (int i = 0; i < instanceCount; ++i) {
            InfectionInstance otherInstance;
            String otherIndexPath;
            File otherIndexFile;
            String otherInstancePath = legacyIndex.getInstancePathAt(i);
            if (otherInstancePath == null) continue;
            File otherRelativeConfigFile = new File(otherInstancePath);
            File otherInstanceConfigFile = InfectionUtil.getAbsoluteFile(otherRelativeConfigFile, installationDir);
            InfectionLegacySupport.debug(" - Instance config file: " + otherInstancePath + " -> " + otherInstanceConfigFile);
            if (!otherInstanceConfigFile.exists() || !otherInstanceConfigFile.isFile() || !LEGACY_INDEX_FILENAME.equals((otherIndexFile = new File(otherIndexPath = (otherInstance = new InfectionInstance(otherInstanceConfigFile)).getIndexPath())).getName())) continue;
            ++legacyInstanceCount;
            InfectionLegacySupport.debug(" -> Detected another legacy instance: " + otherInstanceConfigFile);
        }
        InfectionLegacySupport.debug("Number of remaining legacy instances: " + legacyInstanceCount);
        if (legacyInstanceCount > 0) {
            InfectionLegacySupport.debug("Leaving legacy index-file: " + legacyIndexFile);
            InfectionLegacySupport.debug("Note: The remaining legacy instances are responsible for the legacy index-file.");
            return;
        }
        if (legacyIndexFile.exists() && legacyIndexFile.isFile()) {
            InfectionLegacySupport.debug("Removing legacy index-file: " + legacyIndexFile);
            if (legacyIndexFile.delete()) {
                InfectionLegacySupport.debug("Removed legacy index-file: " + legacyIndexFile);
            } else {
                InfectionLegacySupport.debug("Failed to remove legacy index-file: " + legacyIndexFile);
            }
        }
    }

    public String getLegacyDistJarPath() {
        File file = new File(LEGACY_DISTRIBUTION_JARFILE);
        if (file.exists() && file.isFile()) {
            return file.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File migrateLegacyInstanceV2(InfectionInstance instance, File indexFile) throws Exception {
        File legacyIndexFile = null;
        InfectionIndex legacyIndex = null;
        File indexFileParentDir = indexFile.getParentFile();
        if (indexFileParentDir != null && LEGACY_INFECTION_DIRNAME.equals(indexFileParentDir.getName())) {
            InfectionLegacySupport.debug("Loading legacy index: " + indexFile);
            if (indexFile.exists() && indexFile.isFile()) {
                legacyIndexFile = indexFile;
                legacyIndex = new InfectionIndex(indexFile);
            }
            boolean skipIndexMigration = false;
            File baseDir = indexFileParentDir.getParentFile();
            File newArtifactsDir = new File(baseDir, ".artifacts");
            File newIndexFile = new File(newArtifactsDir, "index.xml");
            if (newIndexFile.exists() && newIndexFile.isFile()) {
                skipIndexMigration = true;
                InfectionLegacySupport.debug("Legacy index was already migrated: " + newIndexFile);
            }
            if (!skipIndexMigration && legacyIndexFile != null) {
                int i;
                InfectionLegacySupport.debug("Migrating legacy index: " + legacyIndexFile);
                InfectionIndex migrateIndex = new InfectionIndex(legacyIndexFile);
                int instanceCount = migrateIndex.getInstanceCount();
                int artifactCount = migrateIndex.getArtifactCount();
                InfectionLegacySupport.debug("Number of instances: " + instanceCount);
                InfectionLegacySupport.debug("Number of artifacts: " + artifactCount);
                File oldBaseDir = indexFileParentDir;
                InfectionLegacySupport.debug("Infection base directory: " + oldBaseDir);
                LinkedList<String> instancePaths = new LinkedList<String>();
                for (i = 0; i < instanceCount; ++i) {
                    String instancePath = migrateIndex.getInstancePathAt(i);
                    if (instancePath == null) continue;
                    File instanceFile = new File(instancePath);
                    File absoluteFile = InfectionUtil.getAbsoluteFile(instanceFile, oldBaseDir);
                    InfectionLegacySupport.debug("Absolute instance path: " + instancePath + " -> " + absoluteFile);
                    File newInstanceFile = InfectionUtil.getRelativeFile(absoluteFile, newArtifactsDir);
                    String newInstancePath = newInstanceFile.getPath();
                    InfectionLegacySupport.debug("Updating instance path: " + instancePath + " -> " + newInstancePath);
                    instancePaths.add(newInstancePath);
                }
                for (i = instanceCount - 1; i >= 0; --i) {
                    migrateIndex.removeInstancePathAt(i);
                }
                for (String newInstancePath : instancePaths) {
                    migrateIndex.addInstancePath(newInstancePath);
                }
                for (int i2 = 0; i2 < artifactCount; ++i2) {
                    String artifactPath;
                    Artifact artifact = migrateIndex.getArtifactAt(i2);
                    if (artifact == null || (artifactPath = artifact.getPath()) == null) continue;
                    File artifactFile = new File(artifactPath);
                    File absoluteFile = InfectionUtil.getAbsoluteFile(artifactFile, oldBaseDir);
                    InfectionLegacySupport.debug("Absolute artifact path: " + artifactPath + " -> " + absoluteFile);
                    File newArtifactFile = InfectionUtil.getRelativeFile(absoluteFile, newArtifactsDir);
                    String newArtifactPath = newArtifactFile.getPath();
                    InfectionLegacySupport.debug("Updating artifact path: " + artifactPath + " -> " + newArtifactPath);
                    artifact.setPath(newArtifactPath);
                }
                File indexDirectory = newIndexFile.getParentFile();
                if (indexDirectory != null && !indexDirectory.exists()) {
                    InfectionLegacySupport.debug("Creating index directory: " + indexDirectory);
                    if (!indexDirectory.mkdirs()) {
                        InfectionLegacySupport.debug("Failed to create directory: " + indexDirectory);
                    }
                }
                InfectionLegacySupport.debug("Writing new index file: " + newIndexFile);
                boolean successIndexFile = false;
                FileOutputStream fos = new FileOutputStream(newIndexFile);
                try {
                    new InfectionXmlUtil(migrateIndex).saveIndex(fos);
                    successIndexFile = true;
                }
                finally {
                    fos.close();
                    if (!successIndexFile && !newIndexFile.delete()) {
                        InfectionLegacySupport.debug("Failed to delete incomplete index-file: " + newIndexFile);
                    }
                }
            }
            indexFile = newIndexFile;
        }
        InfectionLegacySupport.debug("New Index file: " + indexFile);
        File instanceFile = instance.getInstanceFile();
        InfectionLegacySupport.debug("Migrating legacy instance: " + instanceFile);
        File relativeRoot = instanceFile.getParentFile();
        File relativeIndexFile = InfectionUtil.getRelativeFile(indexFile, relativeRoot);
        String newIndexPath = relativeIndexFile.getPath();
        instance.setIndexPath(newIndexPath);
        instance.saveInstanceConfig();
        InfectionLegacySupport.debug("Migrated legacy instance: " + instanceFile);
        if (legacyIndex != null) {
            this.cleanupLegacyInstallationV2(legacyIndexFile, legacyIndex);
        }
        return indexFile;
    }

    protected void cleanupLegacyInstallationV2(File legacyIndexFile, InfectionIndex legacyIndex) throws Exception {
        File installationDir = legacyIndexFile.getParentFile();
        InfectionLegacySupport.debug("Installation directory: " + installationDir);
        int instanceCount = legacyIndex.getInstanceCount();
        InfectionLegacySupport.debug("Number of instances: " + instanceCount);
        if (instanceCount < 1) {
            return;
        }
        int legacyInstanceCount = 0;
        for (int i = 0; i < instanceCount; ++i) {
            InfectionInstance otherInstance;
            String otherIndexPath;
            File otherIndexFile;
            File otherIndexParentDir;
            String otherInstancePath = legacyIndex.getInstancePathAt(i);
            if (otherInstancePath == null) continue;
            File otherRelativeConfigFile = new File(otherInstancePath);
            File otherInstanceConfigFile = InfectionUtil.getAbsoluteFile(otherRelativeConfigFile, installationDir);
            InfectionLegacySupport.debug(" - Instance config file: " + otherInstancePath + " -> " + otherInstanceConfigFile);
            if (!otherInstanceConfigFile.exists() || !otherInstanceConfigFile.isFile() || (otherIndexParentDir = (otherIndexFile = new File(otherIndexPath = (otherInstance = new InfectionInstance(otherInstanceConfigFile)).getIndexPath())).getParentFile()) == null || !LEGACY_INFECTION_DIRNAME.equals(otherIndexParentDir.getName())) continue;
            ++legacyInstanceCount;
            InfectionLegacySupport.debug(" -> Detected another legacy instance: " + otherInstanceConfigFile);
        }
        InfectionLegacySupport.debug("Number of remaining legacy instances: " + legacyInstanceCount);
        if (legacyInstanceCount > 0) {
            InfectionLegacySupport.debug("Leaving legacy index-file: " + legacyIndexFile);
            InfectionLegacySupport.debug("Note: The remaining legacy instances are responsible for the legacy index-file.");
            return;
        }
        if (legacyIndexFile.exists() && legacyIndexFile.isFile()) {
            InfectionLegacySupport.debug("Removing legacy index-file: " + legacyIndexFile);
            if (legacyIndexFile.delete()) {
                InfectionLegacySupport.debug("Removed legacy index-file: " + legacyIndexFile);
            } else {
                InfectionLegacySupport.debug("Failed to remove legacy index-file: " + legacyIndexFile);
            }
        }
    }

    public void migrateLegacyLoggingPropFile(File loggingPropFile) {
        try {
            if (!loggingPropFile.exists()) {
                return;
            }
            InfectionLegacySupport.debug("Migrating legacy logging.properties: " + loggingPropFile);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("com.mueller.", "com.spacekiller.");
            map.put("com.spacekiller.infection.Log2ConsoleAsyncHandler", Log2ConsoleAsyncHandler.class.getName());
            map.put("com.spacekiller.infection.Log2FileAsyncHandler", Log2FileAsyncHandler.class.getName());
            map.put("com.spacekiller.infection.Log2TraceAsyncHandler", Log2TraceAsyncHandler.class.getName());
            int replaceCount = this.replaceFile(loggingPropFile, map);
            InfectionLegacySupport.debug("Replacements: " + replaceCount);
        }
        catch (Throwable e) {
            InfectionLegacySupport.debug("" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int replaceFile(File file, Map<String, String> map) throws IOException {
        int replaceCount = 0;
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                for (Map.Entry<String, String> me : map.entrySet()) {
                    int x;
                    String key = me.getKey();
                    String val = me.getValue();
                    while ((x = s.indexOf(key)) >= 0) {
                        s = s.substring(0, x) + val + s.substring(x + key.length());
                        ++replaceCount;
                    }
                }
                sb.append(s);
                sb.append("\n");
            }
        }
        finally {
            reader.close();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(sb.toString());
        }
        finally {
            writer.close();
        }
        return replaceCount;
    }
}

