/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.install.InstallationArtifactTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class InstallationArtifactTable
extends JTable {
    private static final long serialVersionUID = -6826765353404850914L;
    private boolean refreshing = false;

    public InstallationArtifactTable() {
        this.initArtifactTable();
    }

    protected void initArtifactTable() {
        FontMetrics fm;
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setAutoResizeMode(0);
        this.setAutoCreateColumnsFromModel(false);
        DefaultTableColumnModel colModel = new DefaultTableColumnModel();
        ArtifactTableCellRenderer tableCellRenderer = new ArtifactTableCellRenderer();
        NullTableCellEditor nullCellEditor = new NullTableCellEditor();
        Font font = tableCellRenderer.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getRowMargin();
            this.setRowHeight(rowHeight);
        }
        TableColumn col0 = new TableColumn();
        col0.setHeaderValue("");
        col0.setModelIndex(0);
        col0.setMinWidth(24);
        col0.setMaxWidth(24);
        col0.setPreferredWidth(24);
        col0.setCellRenderer(new ArtifactSelectionTableCellRenderer());
        col0.setCellEditor(new ArtifactSelectionTableCellEditor());
        colModel.addColumn(col0);
        TableColumn col1 = new TableColumn();
        col1.setHeaderValue("Artifact");
        col1.setModelIndex(1);
        col1.setPreferredWidth(200);
        col1.setCellRenderer(tableCellRenderer);
        col1.setCellEditor(nullCellEditor);
        colModel.addColumn(col1);
        TableColumn col2 = new TableColumn();
        col2.setHeaderValue("Title");
        col2.setModelIndex(2);
        col2.setPreferredWidth(200);
        col2.setCellRenderer(tableCellRenderer);
        col2.setCellEditor(nullCellEditor);
        colModel.addColumn(col2);
        TableColumn col3 = new TableColumn();
        col3.setHeaderValue("Version");
        col3.setModelIndex(3);
        col3.setPreferredWidth(110);
        col3.setCellRenderer(tableCellRenderer);
        col3.setCellEditor(nullCellEditor);
        colModel.addColumn(col3);
        TableColumn col4 = new TableColumn();
        col4.setHeaderValue("Vendor");
        col4.setModelIndex(4);
        col4.setPreferredWidth(200);
        col4.setCellRenderer(tableCellRenderer);
        col4.setCellEditor(nullCellEditor);
        colModel.addColumn(col4);
        TableColumn col5 = new TableColumn();
        col5.setHeaderValue("Size");
        col5.setModelIndex(5);
        col5.setPreferredWidth(70);
        col5.setCellRenderer(tableCellRenderer);
        col5.setCellEditor(nullCellEditor);
        colModel.addColumn(col5);
        TableColumn col6 = new TableColumn();
        col6.setHeaderValue("Created");
        col6.setModelIndex(6);
        col6.setPreferredWidth(200);
        col6.setCellRenderer(tableCellRenderer);
        col6.setCellEditor(nullCellEditor);
        colModel.addColumn(col6);
        TableColumn col7 = new TableColumn();
        col7.setHeaderValue("Installed");
        col7.setModelIndex(7);
        col7.setPreferredWidth(200);
        col7.setCellRenderer(tableCellRenderer);
        col7.setCellEditor(nullCellEditor);
        colModel.addColumn(col7);
        this.setColumnModel(colModel);
        this.setModel(new InstallationArtifactTableModel());
    }

    public static List createArtifactList(Collection artifacts) {
        ArtifactComparator comp = new ArtifactComparator();
        TreeMap<String, TreeSet<Artifact>> map = new TreeMap<String, TreeSet<Artifact>>();
        for (Artifact fact : artifacts) {
            String name;
            if (fact == null || (name = fact.getName()) == null) continue;
            TreeSet<Artifact> versions = (TreeSet<Artifact>)map.get(name);
            if (versions == null) {
                versions = new TreeSet<Artifact>(comp);
                map.put(name, versions);
            }
            versions.add(fact);
        }
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        for (Map.Entry entry : map.entrySet()) {
            Set set = (Set)entry.getValue();
            for (Artifact fact : set) {
                list.add(fact);
            }
        }
        return list;
    }

    public static class ArtifactComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            Artifact a = (Artifact)arg0;
            Artifact b = (Artifact)arg1;
            String aName = a.getName();
            String bName = b.getName();
            if (aName == null) {
                if (bName != null) {
                    return -1;
                }
            } else {
                if (bName == null) {
                    return 1;
                }
                int comp = aName.compareTo(bName);
                if (comp != 0) {
                    return comp;
                }
            }
            String aVer = a.getVersion();
            String bVer = b.getVersion();
            if (aVer == null) {
                if (bVer != null) {
                    return 1;
                }
            } else {
                if (bVer == null) {
                    return -1;
                }
                int comp = bVer.compareTo(aVer);
                if (comp != 0) {
                    return comp;
                }
            }
            return 0;
        }
    }

    protected class ArtifactTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 6891463802142803328L;
        private Font defaultFont;
        private Font selectedFont;
        private Color enabledColor;
        private Color disabledColor;
        private Color missingColor;

        public ArtifactTableCellRenderer() {
            Font font = super.getFont();
            this.defaultFont = new Font(font.getName(), 0, font.getSize());
            this.selectedFont = new Font(font.getName(), 1, font.getSize());
            this.enabledColor = Color.black;
            this.disabledColor = Color.gray;
            this.missingColor = Color.red;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rc = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean checked = false;
            boolean enabled = false;
            boolean missing = false;
            if (row >= 0) {
                InstallationArtifactTableModel model = (InstallationArtifactTableModel)table.getModel();
                checked = model.isArtifactChecked(row);
                enabled = model.isArtifactEnabled(row);
                missing = model.isArtifactMissing(row);
            }
            this.setFont(checked ? this.selectedFont : this.defaultFont);
            this.setForeground(enabled ? this.enabledColor : this.disabledColor);
            if (missing) {
                this.setForeground(this.missingColor);
            }
            return rc;
        }
    }

    protected class ArtifactSelectionTableCellEditor
    implements TableCellEditor {
        private JPanel panel = new JPanel();
        private JCheckBox checkbox;
        private CellEditorListener cellEditorListener;
        private int editRow = -1;

        public ArtifactSelectionTableCellEditor() {
            this.panel.setLayout(new GridLayout(1, 1));
            this.checkbox = new JCheckBox();
            this.checkbox.setFocusable(false);
            this.panel.add(this.checkbox);
            this.checkbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    if (InstallationArtifactTable.this.refreshing) {
                        return;
                    }
                    InstallationArtifactTableModel model = (InstallationArtifactTableModel)InstallationArtifactTable.this.getModel();
                    if (ArtifactSelectionTableCellEditor.this.editRow >= 0) {
                        boolean manual = true;
                        model.selectArtifact(ArtifactSelectionTableCellEditor.this.editRow, ArtifactSelectionTableCellEditor.this.checkbox.isSelected(), manual);
                        InstallationArtifactTable.this.repaint();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean arg2, int row, int column) {
            boolean sel = false;
            this.editRow = row;
            InstallationArtifactTableModel model = (InstallationArtifactTableModel)table.getModel();
            boolean enable = model.isArtifactEnabled(row);
            this.checkbox.setEnabled(enable);
            sel = model.isArtifactChecked(row);
            try {
                InstallationArtifactTable.this.refreshing = true;
                this.checkbox.setSelected(sel);
            }
            finally {
                InstallationArtifactTable.this.refreshing = false;
            }
            return this.panel;
        }

        @Override
        public void addCellEditorListener(CellEditorListener arg0) {
            this.cellEditorListener = arg0;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener arg0) {
            if (this.cellEditorListener == arg0) {
                this.cellEditorListener = null;
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (this.cellEditorListener != null) {
                ChangeEvent ev = new ChangeEvent(this.getCellEditorValue());
                this.cellEditorListener.editingStopped(ev);
            }
            return true;
        }

        @Override
        public void cancelCellEditing() {
            if (this.cellEditorListener != null) {
                ChangeEvent ev = new ChangeEvent(this.getCellEditorValue());
                this.cellEditorListener.editingCanceled(ev);
            }
        }

        @Override
        public Object getCellEditorValue() {
            return new Boolean(this.checkbox.isSelected());
        }

        @Override
        public boolean isCellEditable(EventObject arg0) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject arg0) {
            return true;
        }
    }

    protected class NullTableCellEditor
    implements TableCellEditor {
        protected NullTableCellEditor() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener arg0) {
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject arg0) {
            return false;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener arg0) {
        }

        @Override
        public boolean shouldSelectCell(EventObject arg0) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            return null;
        }
    }

    protected class ArtifactSelectionTableCellRenderer
    implements TableCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox checkbox;

        public ArtifactSelectionTableCellRenderer() {
            this.panel.setLayout(new GridLayout(1, 1));
            this.checkbox = new JCheckBox();
            this.checkbox.setFocusable(false);
            this.panel.add(this.checkbox);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean arg2, boolean arg3, int row, int column) {
            boolean sel = false;
            InstallationArtifactTableModel model = (InstallationArtifactTableModel)table.getModel();
            boolean enable = model.isArtifactEnabled(row);
            this.checkbox.setEnabled(enable);
            sel = model.isArtifactChecked(row);
            try {
                InstallationArtifactTable.this.refreshing = true;
                this.checkbox.setSelected(sel);
            }
            finally {
                InstallationArtifactTable.this.refreshing = false;
            }
            return this.panel;
        }
    }
}

