/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.install.InstallerPageContext;
import com.spacekiller.infection.swing.InstallerBanner;
import com.spacekiller.infection.swing.InstallerPagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InstallationLocationMenuPanel
extends InstallerPagePanel {
    private static final long serialVersionUID = 2229403873778407383L;
    private static final Logger logger = Logger.getLogger(InstallationLocationMenuPanel.class.getName());
    private Icon iconProblem;
    private JPanel jPanel16 = null;
    private JPanel jPanel7 = null;
    private JPanel jPanel8 = null;
    private JLabel jLabelLocationProblem = null;
    private JButton jButtonLocationBrowse = null;
    private JLabel jLabel9 = null;
    private JLabel jLabel10 = null;
    private JLabel jLabel11 = null;
    private JButton jButtonInstall = null;
    private JButton jButtonConfig = null;
    private JButton jButtonCleanup = null;
    private InstallerBanner infectionBanner;
    private JTextField textFieldLocation;

    public InstallationLocationMenuPanel() {
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.gridx = 0;
        gridBagConstraints24.fill = 2;
        gridBagConstraints24.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints24.gridy = 1;
        GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
        gridBagConstraints66.gridx = 0;
        gridBagConstraints66.weightx = 1.0;
        gridBagConstraints66.weighty = 1.0;
        gridBagConstraints66.fill = 1;
        gridBagConstraints66.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints66.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(595, 452));
        GridBagConstraints gbc_infectionBanner = new GridBagConstraints();
        gbc_infectionBanner.fill = 2;
        gbc_infectionBanner.gridx = 0;
        gbc_infectionBanner.gridy = 0;
        this.add((Component)this.getInfectionBanner(), gbc_infectionBanner);
        this.add((Component)this.getJPanel16(), gridBagConstraints66);
        this.initInstallationLocationPanel();
    }

    protected void initInstallationLocationPanel() {
        try {
            this.iconProblem = new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/picError.gif"));
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
        String fontName = "dialog";
        int normalFontSize = 14;
        Font font = this.getJButtonLocationBrowse().getFont();
        if (font != null) {
            fontName = font.getName();
            normalFontSize = font.getSize();
        }
        int largeFontSize = normalFontSize * 4 / 3;
        this.getJButtonInstall().setFont(new Font(fontName, 1, largeFontSize));
        this.getJButtonConfig().setFont(new Font(fontName, 0, largeFontSize));
        this.getJButtonCleanup().setFont(new Font(fontName, 0, largeFontSize));
    }

    private JPanel getJPanel16() {
        if (this.jPanel16 == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.anchor = 11;
            gridBagConstraints21.insets = new Insets(8, 8, 8, 8);
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.fill = 2;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.anchor = 10;
            gridBagConstraints23.insets = new Insets(4, 8, 4, 8);
            gridBagConstraints23.gridx = 1;
            gridBagConstraints23.gridy = 0;
            gridBagConstraints23.weightx = 0.0;
            gridBagConstraints23.weighty = 1.0;
            gridBagConstraints23.fill = 2;
            this.jPanel16 = new JPanel();
            this.jPanel16.setLayout(new GridBagLayout());
            this.jPanel16.setBorder(BorderFactory.createEtchedBorder(0));
            this.jPanel16.add((Component)this.getJPanel8(), gridBagConstraints23);
            this.jPanel16.add((Component)this.getJPanel7(), gridBagConstraints21);
        }
        return this.jPanel16;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            GridBagConstraints gridBagConstraints106 = new GridBagConstraints();
            gridBagConstraints106.gridx = 0;
            gridBagConstraints106.insets = new Insets(4, 8, 4, 8);
            gridBagConstraints106.fill = 2;
            gridBagConstraints106.gridwidth = 2;
            gridBagConstraints106.gridy = 1;
            this.jLabelLocationProblem = new JLabel();
            this.jLabelLocationProblem.setText("Blabla...");
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.insets = new Insets(4, 4, 5, 8);
            gridBagConstraints26.gridy = 0;
            this.jPanel8 = new JPanel();
            GridBagLayout gbl_jPanel8 = new GridBagLayout();
            gbl_jPanel8.columnWeights = new double[]{1.0, 0.0};
            this.jPanel8.setLayout(gbl_jPanel8);
            this.jPanel8.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Installation Directory", 0, 0, null, null));
            GridBagConstraints gbc_textFieldLocation = new GridBagConstraints();
            gbc_textFieldLocation.insets = new Insets(4, 8, 5, 5);
            gbc_textFieldLocation.fill = 1;
            gbc_textFieldLocation.gridx = 0;
            gbc_textFieldLocation.gridy = 0;
            this.jPanel8.add((Component)this.getTextFieldLocation(), gbc_textFieldLocation);
            this.jPanel8.add((Component)this.getJButtonLocationBrowse(), gridBagConstraints26);
            this.jPanel8.add((Component)this.jLabelLocationProblem, gridBagConstraints106);
        }
        return this.jPanel8;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridBagConstraints gridBagConstraints74 = new GridBagConstraints();
            gridBagConstraints74.gridx = 2;
            gridBagConstraints74.anchor = 17;
            gridBagConstraints74.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints74.weightx = 1.0;
            gridBagConstraints74.gridy = 6;
            GridBagConstraints gridBagConstraints73 = new GridBagConstraints();
            gridBagConstraints73.gridx = 1;
            gridBagConstraints73.fill = 2;
            gridBagConstraints73.insets = new Insets(0, 8, 8, 8);
            gridBagConstraints73.gridy = 6;
            GridBagConstraints gridBagConstraints69 = new GridBagConstraints();
            gridBagConstraints69.gridx = 2;
            gridBagConstraints69.anchor = 17;
            gridBagConstraints69.insets = new Insets(4, 0, 4, 4);
            gridBagConstraints69.weightx = 1.0;
            gridBagConstraints69.gridy = 2;
            this.jLabel11 = new JLabel();
            this.jLabel11.setText("Remove unused versions...");
            GridBagConstraints gridBagConstraints68 = new GridBagConstraints();
            gridBagConstraints68.gridx = 2;
            gridBagConstraints68.anchor = 17;
            gridBagConstraints68.insets = new Insets(4, 0, 5, 4);
            gridBagConstraints68.weightx = 1.0;
            gridBagConstraints68.gridy = 1;
            this.jLabel10 = new JLabel();
            this.jLabel10.setText("Configure the application...");
            GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
            gridBagConstraints67.gridx = 2;
            gridBagConstraints67.anchor = 17;
            gridBagConstraints67.insets = new Insets(4, 0, 5, 4);
            gridBagConstraints67.weightx = 1.0;
            gridBagConstraints67.gridy = 0;
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("Install or update features...");
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.gridx = 1;
            gridBagConstraints47.fill = 2;
            gridBagConstraints47.insets = new Insets(0, 8, 8, 8);
            gridBagConstraints47.gridy = 2;
            GridBagConstraints gbc_jButtonConfig = new GridBagConstraints();
            gbc_jButtonConfig.gridx = 1;
            gbc_jButtonConfig.weightx = 0.0;
            gbc_jButtonConfig.anchor = 10;
            gbc_jButtonConfig.fill = 2;
            gbc_jButtonConfig.insets = new Insets(0, 8, 8, 8);
            gbc_jButtonConfig.gridy = 1;
            GridBagConstraints gbc_jButtonInstall = new GridBagConstraints();
            gbc_jButtonInstall.insets = new Insets(8, 8, 8, 8);
            gbc_jButtonInstall.gridy = 0;
            gbc_jButtonInstall.weightx = 0.0;
            gbc_jButtonInstall.anchor = 10;
            gbc_jButtonInstall.fill = 2;
            gbc_jButtonInstall.gridx = 1;
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new GridBagLayout());
            this.jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Installation Menu", 0, 0, null, null));
            this.jPanel7.add((Component)this.getJButtonInstall(), gbc_jButtonInstall);
            this.jPanel7.add((Component)this.getJButtonConfig(), gbc_jButtonConfig);
            this.jPanel7.add((Component)this.getJButtonCleanup(), gridBagConstraints47);
            this.jPanel7.add((Component)this.jLabel9, gridBagConstraints67);
            this.jPanel7.add((Component)this.jLabel10, gridBagConstraints68);
            this.jPanel7.add((Component)this.jLabel11, gridBagConstraints69);
        }
        return this.jPanel7;
    }

    private JButton getJButtonLocationBrowse() {
        if (this.jButtonLocationBrowse == null) {
            this.jButtonLocationBrowse = new JButton();
            this.jButtonLocationBrowse.setText("");
            this.jButtonLocationBrowse.setMargin(new Insets(2, 2, 2, 2));
            this.jButtonLocationBrowse.setToolTipText("Browse directories..");
            this.jButtonLocationBrowse.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/search.gif")));
            this.jButtonLocationBrowse.setPreferredSize(new Dimension(25, 25));
            this.jButtonLocationBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationLocationMenuPanel.this.actionLocationBrowse();
                }
            });
        }
        return this.jButtonLocationBrowse;
    }

    private JButton getJButtonInstall() {
        if (this.jButtonInstall == null) {
            this.jButtonInstall = new JButton();
            this.jButtonInstall.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/install.gif")));
            this.jButtonInstall.setText("Install");
            this.jButtonInstall.setToolTipText("Install or update features..");
            this.jButtonInstall.setHorizontalAlignment(2);
            this.jButtonInstall.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonInstall.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    InstallationLocationMenuPanel.this.actionInstall();
                }
            });
        }
        return this.jButtonInstall;
    }

    private JButton getJButtonConfig() {
        if (this.jButtonConfig == null) {
            this.jButtonConfig = new JButton();
            this.jButtonConfig.setEnabled(true);
            this.jButtonConfig.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonConfig.setText("Config");
            this.jButtonConfig.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/vjoblist16.gif")));
            this.jButtonConfig.setToolTipText("Manage configuration..");
            this.jButtonConfig.setHorizontalAlignment(2);
            this.jButtonConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationLocationMenuPanel.this.actionConfig();
                }
            });
        }
        return this.jButtonConfig;
    }

    private JButton getJButtonCleanup() {
        if (this.jButtonCleanup == null) {
            this.jButtonCleanup = new JButton();
            this.jButtonCleanup.setToolTipText("Remove unused artifacts...");
            this.jButtonCleanup.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonCleanup.setText("Cleanup");
            this.jButtonCleanup.setHorizontalAlignment(2);
            this.jButtonCleanup.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/infection/icons/tool_brush.png")));
            this.jButtonCleanup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstallationLocationMenuPanel.this.actionCleanup();
                }
            });
        }
        return this.jButtonCleanup;
    }

    public InstallerBanner getInfectionBanner() {
        if (this.infectionBanner == null) {
            this.infectionBanner = new InstallerBanner();
            this.infectionBanner.setTitle("Installation");
            this.infectionBanner.setForeground(Color.WHITE);
        }
        return this.infectionBanner;
    }

    @Override
    protected synchronized void refresh() {
        this.decorateBanner(this.getInfectionBanner());
        this.refreshLocation();
    }

    protected void refreshLocation() {
        InstallerPageContext context = this.getPageContext();
        if (context != null) {
            File installDir = context.getInstallationDirectory();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Installation directory: " + installDir);
            }
            String text = null;
            if (installDir != null) {
                text = installDir.getPath();
            }
            if (text == null) {
                text = "";
            }
            this.getTextFieldLocation().setText(text);
        }
        try {
            this.locationSelected();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void locationSelected() {
        File instHome = null;
        String text = this.getTextFieldLocation().getText();
        if (text != null && text.length() > 0) {
            instHome = new File(text);
        }
        String installProblem = null;
        int installedArtifactCount = -1;
        InstallerPageContext context = this.getPageContext();
        if (context != null) {
            try {
                context.setInstallationDirectory(instHome);
                installProblem = context.getInstallationProblemText();
                installedArtifactCount = context.getInstalledArtifactCount();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        boolean enableInstall = installProblem == null;
        this.getJButtonInstall().setEnabled(enableInstall);
        boolean enableConfig = installedArtifactCount > 0;
        this.getJButtonConfig().setEnabled(enableConfig);
        boolean enableCleanup = installedArtifactCount > 0;
        this.getJButtonCleanup().setEnabled(enableCleanup);
        Icon problemIcon = null;
        if (installProblem == null) {
            installProblem = "";
        } else {
            problemIcon = this.iconProblem;
        }
        this.jLabelLocationProblem.setText(installProblem);
        this.jLabelLocationProblem.setIcon(problemIcon);
    }

    protected void actionLocationBrowse() {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Installation Directory");
        fileChooser.setDialogType(1);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        int rc = fileChooser.showSaveDialog(null);
        if (rc == 0 && (file = fileChooser.getSelectedFile()) != null) {
            this.getTextFieldLocation().setText(file.getPath());
            this.locationSelected();
        }
    }

    protected void actionInstall() {
        try {
            InstallerPageContext context = this.getPageContext();
            context.showUpdatePage();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionConfig() {
        try {
            InstallerPageContext context = this.getPageContext();
            context.showConfigPage();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    protected void actionCleanup() {
        try {
            InstallerPageContext context = this.getPageContext();
            context.showCleanupPage();
            this.refresh();
        }
        catch (Exception e) {
            this.handleException(e, logger);
        }
    }

    private JTextField getTextFieldLocation() {
        if (this.textFieldLocation == null) {
            this.textFieldLocation = new JTextField();
            this.textFieldLocation.setEditable(false);
            this.textFieldLocation.setColumns(30);
        }
        return this.textFieldLocation;
    }
}

