/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class InstallerBanner
extends JComponent {
    private static final long serialVersionUID = -3341257503408453072L;
    private String title;
    private Icon icon;
    private Paint backgroundPaint = Color.BLUE;
    private JLabel label;

    public InstallerBanner() {
        this.initInfectionBanner();
    }

    protected void initInfectionBanner() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(8, 8, 8, 8);
        this.label = new JLabel("Banner");
        this.label.setIconTextGap(8);
        this.add((Component)this.label, gbc);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Paint back = this.getBackgroundPaint();
        if (back != null) {
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            g2d.setPaint(back);
            g.fillRect(0, 0, w, h);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.label.setText(String.valueOf(title));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.label.setIcon(icon);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.label.setFont(font);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.label.setForeground(fg);
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }
}

