/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.Artifact;
import com.spacekiller.infection.Infection;
import com.spacekiller.infection.InfectionInstallation;
import com.spacekiller.infection.InfectionSite;
import com.spacekiller.infection.install.InstallerPageContext;
import com.spacekiller.infection.install.InstallerPageManager;
import com.spacekiller.infection.install.InstallerTaskListener;
import com.spacekiller.infection.install.InstallerTaskManager;
import com.spacekiller.infection.old.ErrorDialog;
import com.spacekiller.infection.swing.InstallationArtifactDownloadPanel;
import com.spacekiller.infection.swing.InstallationArtifactTablePanel;
import com.spacekiller.infection.swing.InstallationInstanceConfigPanel;
import com.spacekiller.infection.swing.InstallationLicenseAcceptPanel;
import com.spacekiller.infection.swing.InstallationLocationMenuPanel;
import com.spacekiller.infection.swing.InstallationSiteAddPanel;
import com.spacekiller.infection.swing.InstallationSiteProxyPanel;
import com.spacekiller.infection.swing.InstallationSiteTreePanel;
import com.spacekiller.infection.swing.InstallerPagePanel;
import com.spacekiller.infection.swing.InstanceCustomizer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InstallerPageManagerPanel
extends JPanel {
    private static final long serialVersionUID = -3711908218495930323L;
    private static final Logger logger = Logger.getLogger(InstallerPageManagerPanel.class.getName());
    private InstallerPageManagerImpl installerPageManager;
    private InstallerPagePanel currentInstallerPagePanel;
    private Font bannerFont;
    private Color bannerForeground;
    private Paint bannerBackgroundPaint;
    private Icon bannerIcon;

    public InstallerPageManagerPanel() {
        this.initInstallerPageManagerPanel();
    }

    protected void initInstallerPageManagerPanel() {
        this.setLayout(new GridLayout(1, 1));
        this.refreshInfectionBanner();
        this.installerPageManager = new InstallerPageManagerImpl();
        this.installerPageManager.showLicenseAcceptPage();
        Dimension prefSize = this.installerPageManager.getPreferredSize();
        this.setPreferredSize(prefSize);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("prefSize: " + prefSize);
        }
        this.refresh();
    }

    protected void refreshInfectionBanner() {
        try {
            Font font = new JLabel().getFont();
            if (font != null) {
                String fontName = font.getName();
                int normalFontSize = font.getSize();
                int largeFontSize = normalFontSize * 4 / 3;
                int bannerFontSize = largeFontSize * 4 / 3;
                this.bannerFont = new Font(fontName, 1, bannerFontSize);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            this.bannerForeground = Color.WHITE;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            Image bannerImage = Infection.getInstance().getDistributionResourceImage("banner");
            if (bannerImage != null) {
                ImageIcon dummy = new ImageIcon(bannerImage);
                Image backImage = dummy.getImage();
                int w = backImage.getWidth(null);
                int h = backImage.getHeight(null);
                BufferedImage bi = new BufferedImage(w, h, 1);
                Graphics g = bi.getGraphics();
                g.drawImage(backImage, 0, 0, null);
                g.dispose();
                Rectangle anchor = new Rectangle(0, 0, w, h);
                this.bannerBackgroundPaint = new TexturePaint(bi, anchor);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            this.bannerIcon = Infection.getInstance().getDistributionResourceIcon("icon32");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected synchronized InstallerPagePanel getCurrentInstallerPagePanel() {
        return this.currentInstallerPagePanel;
    }

    protected synchronized void setCurrentInstallerPagePanel(InstallerPagePanel currentInstallerPagePanel) {
        this.currentInstallerPagePanel = currentInstallerPagePanel;
        this.refresh();
    }

    protected synchronized void refresh() {
        this.removeAll();
        InstallerPagePanel panel = this.getCurrentInstallerPagePanel();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("refresh: panel=" + panel);
        }
        if (panel != null) {
            this.add(panel);
        }
        this.validate();
        this.repaint();
    }

    protected synchronized boolean closePageManager() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return false;
        }
        window.dispose();
        return true;
    }

    protected synchronized boolean showInstallerPagePanel(InstallerPagePanel panel) {
        this.setCurrentInstallerPagePanel(panel);
        return true;
    }

    public InstallerPageManager getInstallerPageManager() {
        return this.installerPageManager;
    }

    public InstanceCustomizer getInfectionInstanceCustomizer() {
        return this.installerPageManager.installationInstanceConfigPanel.getInfectionInstanceCustomizer();
    }

    protected boolean showLocationCleanupPage() {
        try {
            int messageType;
            int optionType;
            Artifact[] unusedArtifacts = this.installerPageManager.enumerateUnusedArtifacts();
            if (unusedArtifacts.length < 1) {
                String title = "Clean";
                String message = "There are no unused software artifacts.\n";
                int messageType2 = 1;
                JOptionPane.showMessageDialog(this, message, title, messageType2);
                return true;
            }
            String title = "Cleanup unused artifacts";
            String message = "You are about to remove unused artifact versions.\n";
            message = message + "\nNumber of unused artifacts: " + unusedArtifacts.length;
            int rc = JOptionPane.showConfirmDialog(this, message = message + "\n\nAre you sure ?", title, optionType = 2, messageType = 3);
            if (rc != 0) {
                return false;
            }
            this.installerPageManager.cleanupUnusedArtifacts();
            return true;
        }
        catch (Exception e) {
            this.handleException(e, logger);
            return false;
        }
    }

    protected void handleException(Throwable e, Logger logger) {
        if (logger != null) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        } else {
            e.printStackTrace(System.out);
        }
        ErrorDialog.showErrorDialog(e);
    }

    protected class InstallerPageManagerImpl
    extends InstallerPageManager {
        private int prefWidth = 400;
        private int prefHeight = 300;
        private final InstallationLicenseAcceptPanel installationLicenseAcceptPanel = new InstallationLicenseAcceptPanel();
        private final InstallationLocationMenuPanel installationLocationMenuPanel;
        private final InstallationSiteTreePanel installationSiteTreePanel;
        private final InstallationSiteProxyPanel installationSiteProxyPanel;
        private final InstallationSiteAddPanel installationSiteAddPanel;
        private final InstallationArtifactTablePanel installationArtifactTablePanel;
        private final InstallationArtifactDownloadPanel installationArtifactDownloadPanel;
        private final InstallationInstanceConfigPanel installationInstanceConfigPanel;

        protected InstallerPageManagerImpl() {
            this.initInstallerPagePanel(this.installationLicenseAcceptPanel, new InstallerPageManager.LicenseAcceptPageContext());
            this.installationLocationMenuPanel = new InstallationLocationMenuPanel();
            this.initInstallerPagePanel(this.installationLocationMenuPanel, new InstallerPageManager.LocationMenuPageContext());
            this.installationSiteTreePanel = new InstallationSiteTreePanel();
            this.initInstallerPagePanel(this.installationSiteTreePanel, new InstallerPageManager.UpdateSitesTreePageContext());
            this.installationSiteProxyPanel = new InstallationSiteProxyPanel();
            this.initInstallerPagePanel(this.installationSiteProxyPanel, new InstallerPageManager.UpdateSitesProxyPageContext());
            this.installationSiteAddPanel = new InstallationSiteAddPanel();
            this.initInstallerPagePanel(this.installationSiteAddPanel, new InstallerPageManager.UpdateSitesAddPageContext());
            this.installationArtifactTablePanel = new InstallationArtifactTablePanel();
            this.initInstallerPagePanel(this.installationArtifactTablePanel, new InstallerPageManager.ArtifactsTablePageContext());
            this.installationArtifactDownloadPanel = new InstallationArtifactDownloadPanel();
            this.initInstallerPagePanel(this.installationArtifactDownloadPanel, new InstallerPageManager.ArtifactsDownloadPageContext());
            this.installationInstanceConfigPanel = new InstallationInstanceConfigPanel();
            this.initInstallerPagePanel(this.installationInstanceConfigPanel, new InstallerPageManager.InstanceConfigPageContext());
        }

        protected void initInstallerPagePanel(InstallerPagePanel panel, InstallerPageContext context) {
            panel.setBannerFont(InstallerPageManagerPanel.this.bannerFont);
            panel.setBannerForeground(InstallerPageManagerPanel.this.bannerForeground);
            panel.setBannerBackgroundPaint(InstallerPageManagerPanel.this.bannerBackgroundPaint);
            panel.setBannerIcon(InstallerPageManagerPanel.this.bannerIcon);
            panel.setPageContext(context);
            Dimension prefSize = panel.getPreferredSize();
            if (prefSize != null) {
                if (prefSize.width > this.prefWidth) {
                    this.prefWidth = prefSize.width;
                }
                if (prefSize.height > this.prefHeight) {
                    this.prefHeight = prefSize.height;
                }
            }
        }

        protected Dimension getPreferredSize() {
            return new Dimension(this.prefWidth, this.prefHeight);
        }

        @Override
        public boolean closePageManager() {
            return InstallerPageManagerPanel.this.closePageManager();
        }

        @Override
        public boolean showLicenseAcceptPage() {
            InstallationLicenseAcceptPanel panel = this.installationLicenseAcceptPanel;
            ((InstallerPagePanel)panel).refresh();
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        @Override
        public boolean showLocationMenuPage() {
            InstallationLocationMenuPanel panel = this.installationLocationMenuPanel;
            ((InstallerPagePanel)panel).refresh();
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        @Override
        public boolean showLocationConfigPage() {
            boolean refresh = true;
            return this.showInstanceConfigPage(refresh);
        }

        @Override
        public boolean showLocationCleanupPage() {
            return InstallerPageManagerPanel.this.showLocationCleanupPage();
        }

        @Override
        public boolean showUpdateSitesTreePage(boolean refresh) {
            InstallationSiteTreePanel panel = this.installationSiteTreePanel;
            this.installationSiteTreePanel.setSiteTreeModel(this.getSiteTreeModel());
            if (refresh) {
                ((InstallerPagePanel)panel).refresh();
            }
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        @Override
        public boolean showSitesProxyPage() {
            InstallationSiteProxyPanel panel = this.installationSiteProxyPanel;
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        @Override
        public boolean showSitesAddPage() {
            InstallationSiteAddPanel panel = this.installationSiteAddPanel;
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void refreshUpdateSitesImpl(InfectionInstallation installation, boolean sync) throws Exception {
            block7: {
                try {
                    super.refreshUpdateSitesImpl(installation, sync);
                    if (!sync) break block7;
                    logger.info("Waiting for swing updates...");
                }
                catch (Throwable throwable) {
                    if (sync) {
                        logger.info("Waiting for swing updates...");
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                logger.info("Swing updates completed.");
                            }
                        });
                    }
                    Runnable autoSelect = new Runnable(){

                        @Override
                        public void run() {
                            InstallerPageManagerImpl.this.installationSiteTreePanel.selectAllSites();
                        }
                    };
                    if (sync) {
                        autoSelect.run();
                    } else {
                        SwingUtilities.invokeLater(autoSelect);
                    }
                    throw throwable;
                }
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            }
            Runnable autoSelect = new /* invalid duplicate definition of identical inner class */;
            if (sync) {
                autoSelect.run();
            } else {
                SwingUtilities.invokeLater(autoSelect);
            }
        }

        @Override
        protected InfectionSite[] getSelectedUpdateSites() {
            return this.installationSiteTreePanel.getSelectedSites();
        }

        @Override
        public boolean showArtifactsTablePage(boolean refresh) {
            InstallationArtifactTablePanel panel = this.installationArtifactTablePanel;
            if (refresh) {
                ((InstallerPagePanel)panel).refresh();
            }
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        @Override
        protected boolean showArtifactsDownloadPage() {
            InstallationArtifactDownloadPanel panel = this.installationArtifactDownloadPanel;
            ((InstallerPagePanel)panel).refresh();
            return InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
        }

        @Override
        public Artifact[] getSelectedDownloadArtifacts() {
            return this.installationArtifactTablePanel.getSelectedDownloadArtifacts();
        }

        @Override
        protected InstallerTaskListener createArtifactsDownloadListener(InstallerTaskManager taskManager) {
            this.installationArtifactDownloadPanel.setTaskManager(taskManager);
            return this.installationArtifactDownloadPanel.getArtifactsDownloadListener();
        }

        @Override
        protected boolean showInstanceConfigPage(boolean refresh) {
            if (refresh) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("showInstanceConfigPage: refresh=" + refresh);
                    logger.fine("InfectionRuntime: " + this.getRuntime());
                    logger.fine("InfectionInstaller: " + this.getInstaller());
                    logger.fine("InfectionInstallation: " + this.getInstallation());
                    logger.fine("InfectionIndex: " + this.getInstallationIndex());
                }
                boolean promptUpgrade = this.isPromptUpgrade();
                boolean autoSaveConfig = this.isAutoSaveConfig();
                boolean promptRestart = this.isPromptRestart();
                this.installationInstanceConfigPanel.setPromptUpgrade(promptUpgrade);
                this.installationInstanceConfigPanel.setAutoSaveConfig(autoSaveConfig);
                this.installationInstanceConfigPanel.setPromptRestart(promptRestart);
                this.installationInstanceConfigPanel.setAccess(this.getRuntime());
                this.installationInstanceConfigPanel.setInstaller(this.getInstaller());
                this.installationInstanceConfigPanel.setInstallation(this.getInstallation());
                this.installationInstanceConfigPanel.setInstallationIndex(this.getInstallationIndex());
            }
            InstallationInstanceConfigPanel panel = this.installationInstanceConfigPanel;
            InstallerPageManagerPanel.this.showInstallerPagePanel(panel);
            if (refresh) {
                ((InstallerPagePanel)panel).refresh();
            }
            return true;
        }

        @Override
        protected boolean showArtifactsConfigPage(boolean refresh) {
            boolean shown = this.showInstanceConfigPage(refresh);
            if (!shown) {
                return false;
            }
            this.installationInstanceConfigPanel.getInfectionInstanceCustomizer().showTabArtifacts();
            return true;
        }
    }
}

