/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.infection.swing;

import com.spacekiller.infection.InfectionInstance;
import com.spacekiller.infection.InfectionSystemProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class InstancePropertiesEditor
extends JPanel {
    private static final long serialVersionUID = -4666136498069719101L;
    private JScrollPane jScrollPane = null;
    private JTable jTableProperties = null;
    private InfectionInstance instance;
    private DefaultTableModel properties;
    private List keys;
    private PropertyTableModelListener propertyTableModelListener = new PropertyTableModelListener();
    private boolean refreshing = false;
    private JPanel jPanel = null;
    private JButton jButtonAdd = null;
    private JButton jButtonRemove = null;

    public InstancePropertiesEditor() {
        this.initialize();
        this.initSystemPropertyEditor();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.weighty = 0.0;
        gridBagConstraints1.fill = 0;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.weightx = 0.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(440, 199));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJPanel(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableProperties());
        }
        return this.jScrollPane;
    }

    private JTable getJTableProperties() {
        if (this.jTableProperties == null) {
            this.jTableProperties = new JTable();
        }
        return this.jTableProperties;
    }

    protected void initSystemPropertyEditor() {
        FontMetrics fm;
        this.keys = new ArrayList();
        this.properties = new DefaultTableModel();
        this.properties.addColumn("Key");
        this.properties.addColumn("Value");
        this.properties.addTableModelListener(this.propertyTableModelListener);
        this.getJTableProperties().setModel(this.properties);
        Font font = this.getJTableProperties().getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getJTableProperties().getRowMargin();
            this.getJTableProperties().setRowHeight(rowHeight);
        }
        this.getJButtonRemove().setEnabled(false);
        this.getJTableProperties().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InstancePropertiesEditor.this.getJButtonRemove().setEnabled(InstancePropertiesEditor.this.getJTableProperties().getSelectedRowCount() > 0);
            }
        });
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(4, 0, 0, 4);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 0, 0, 4);
            gridBagConstraints2.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getJButtonAdd(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJButtonRemove(), gridBagConstraints3);
        }
        return this.jPanel;
    }

    private JButton getJButtonAdd() {
        if (this.jButtonAdd == null) {
            this.jButtonAdd = new JButton();
            this.jButtonAdd.setText("Add");
            this.jButtonAdd.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstancePropertiesEditor.this.actionAdd();
                }
            });
        }
        return this.jButtonAdd;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton();
            this.jButtonRemove.setText("Remove");
            this.jButtonRemove.setMargin(new Insets(2, 4, 2, 4));
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstancePropertiesEditor.this.actionRemove();
                }
            });
        }
        return this.jButtonRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshProperties() {
        try {
            this.refreshing = true;
            this.keys.clear();
            int rows = this.properties.getRowCount();
            for (int c = rows - 1; c >= 0; --c) {
                this.properties.removeRow(c);
            }
            if (this.instance != null) {
                int props = this.instance.getPropertyCount();
                for (int c = 0; c < props; ++c) {
                    String key;
                    InfectionSystemProperty prop = this.instance.getPropertyAt(c);
                    if (prop == null || !this.isCustomSystemProperty(key = prop.getKey())) continue;
                    this.properties.addRow(new Object[]{prop.getKey(), prop.getValue()});
                    this.keys.add(prop.getKey());
                }
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void actionAdd() {
        this.instance.addProperty("", "");
        this.refreshProperties();
    }

    protected void actionRemove() {
        int[] rows = this.getJTableProperties().getSelectedRows();
        for (int c = rows.length - 1; c >= 0; --c) {
            int row = rows[c];
            this.properties.removeRow(row);
        }
    }

    public InfectionInstance getInstance() {
        return this.instance;
    }

    public synchronized void setInstance(InfectionInstance instance) {
        this.instance = instance;
        this.refreshProperties();
    }

    protected boolean isCustomSystemProperty(String key) {
        if ("infection.mainclass".equals(key)) {
            return false;
        }
        return !"infection.classloader".equals(key);
    }

    protected class PropertyTableModelListener
    implements TableModelListener {
        protected PropertyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (InstancePropertiesEditor.this.refreshing) {
                return;
            }
            int type = e.getType();
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            switch (type) {
                case 0: {
                    for (int i = firstRow; i <= lastRow; ++i) {
                        String newKey = String.valueOf(InstancePropertiesEditor.this.properties.getValueAt(i, 0));
                        String newValue = String.valueOf(InstancePropertiesEditor.this.properties.getValueAt(i, 1));
                        InfectionSystemProperty prop = InstancePropertiesEditor.this.instance.getPropertyAt(i);
                        if (prop == null) continue;
                        prop.setKey(newKey);
                        prop.setValue(newValue);
                    }
                    InstancePropertiesEditor.this.refreshProperties();
                }
            }
        }
    }
}

